/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

public interface IMultiblockRenderHelper {
    default public Function<ResourceLocation, RenderType> getRenderTypeFunction(PreviewMode previewMode) {
        return this.getRenderTypeFunction(previewMode, RenderType::entityTranslucentCull);
    }

    default public Function<ResourceLocation, RenderType> getRenderTypeFunction(PreviewMode previewMode, Function<ResourceLocation, RenderType> defaultRenderType) {
        return previewMode.equals((Object)PreviewMode.PLACED) ? RenderType::entityCutout : defaultRenderType;
    }

    default public RenderType getRenderType(PreviewMode previewMode, ResourceLocation texture) {
        return this.getRenderType(previewMode, texture, RenderType.entityTranslucentCull((ResourceLocation)texture));
    }

    default public RenderType getRenderType(PreviewMode previewMode, ResourceLocation texture, RenderType defaultRenderType) {
        return previewMode.equals((Object)PreviewMode.PLACED) ? RenderType.entityCutout((ResourceLocation)texture) : defaultRenderType;
    }

    default public VertexConsumer getConsumer(MultiBufferSource buffer, IMultiBlockEntity blockEntity, Material materialBase, Material materialSecondary, Block blockSecondary) {
        PreviewMode previewMode = blockEntity.getPreviewMode();
        RenderType renderTypeBase = this.getRenderType(previewMode, materialBase.atlasLocation());
        RenderType renderTypeCorrupted = this.getRenderType(previewMode, materialSecondary.atlasLocation());
        VertexConsumer baseConsumer = materialBase.sprite().wrap(buffer.getBuffer(renderTypeBase));
        VertexConsumer corruptedConsumer = materialSecondary.sprite().wrap(buffer.getBuffer(renderTypeCorrupted));
        return blockEntity.getBlockEntity().getBlockState().is(blockSecondary) ? corruptedConsumer : baseConsumer;
    }

    default public Level level() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            throw new IllegalStateException("BlockEntityRenderer Level is null");
        }
        return level;
    }

    default public void render(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, PreviewMode previewMode) {
        this.render(modelPart, poseStack, vertexConsumer, packedLight, packedOverlay, -1, previewMode);
    }

    default public void render(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int r, int g, int b, int alpha, PreviewMode previewMode) {
        this.render(modelPart, poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.color((int)alpha, (int)r, (int)g, (int)b), previewMode);
    }

    default public void render(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color, PreviewMode previewMode) {
        modelPart.render(poseStack, vertexConsumer, packedLight, packedOverlay, previewMode.applyColors(color));
    }
}

