/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.client.VertexConsumerWrapper;
import net.nikdo53.tinymultiblocklib.compat.carryon.CarryOnPreviewHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import net.nikdo53.tinymultiblocklib.mixin.ItemAccessor;
import net.nikdo53.tinymultiblocklib.platform.services.IPlatformHelper;

public class MultiblockPreviewRenderer {
    public static void renderMultiblockPreviews(float partialTick, Minecraft minecraft, Level level, Camera camera, PoseStack poseStack, IPlatformHelper platformHelper) {
        BlockItem blockItem;
        Block block;
        LocalPlayer player = minecraft.player;
        assert (player != null);
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (platformHelper.isModLoaded("carryon") && CarryOnPreviewHelper.isValidMultiblock((Player)player)) {
            item = CarryOnPreviewHelper.getMultiblockItem((Player)player);
        }
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IPreviewableMultiblock) {
            IPreviewableMultiblock multiBlock = (IPreviewableMultiblock)block;
            block = blockItem.getBlock();
            if (block instanceof EntityBlock) {
                EntityBlock block2 = (EntityBlock)block;
                HitResult hitResult = minecraft.hitResult;
                if (hitResult instanceof BlockHitResult) {
                    boolean shouldShowPreview;
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    boolean placeOnWater = false;
                    if (blockItem instanceof PlaceOnWaterBlockItem) {
                        blockHitResult = ItemAccessor.getPlayerPOVHitResult(level, (Player)player, ClipContext.Fluid.SOURCE_ONLY);
                        placeOnWater = level.isWaterAt(blockHitResult.getBlockPos());
                    }
                    Direction hitDirection = blockHitResult.getDirection();
                    BlockPos hitPos = blockHitResult.getBlockPos();
                    BlockPos pos = hitPos.relative(hitDirection);
                    BlockState state = multiBlock.getDefaultStateForPreviews(player.getDirection());
                    BlockEntity entity = block2.newBlockEntity(pos, state);
                    boolean bl = shouldShowPreview = level.getBlockState(pos).canBeReplaced() && (!level.getBlockState(hitPos).isAir() || placeOnWater);
                    if (entity instanceof IMultiBlockEntity) {
                        IMultiBlockEntity multiBlockEntity = (IMultiBlockEntity)entity;
                        if (shouldShowPreview) {
                            entity.setLevel(level);
                            entity = multiBlock.getBlockEntityForPreviews(entity, level, pos);
                            boolean multiBlockCanPlace = multiBlock.canPlace((LevelReader)level, pos, state, (Entity)player, true);
                            boolean entityUnobstructed = multiBlock.entityUnobstructed((CollisionGetter)level, pos, state, (Entity)player);
                            PreviewMode previewMode = multiBlockCanPlace ? (entityUnobstructed ? PreviewMode.PREVIEW : PreviewMode.ENTITY_BLOCKED) : PreviewMode.INVALID;
                            multiBlockEntity.setPreviewMode(previewMode);
                            if (level.getBlockState(hitPos).canBeReplaced() && !placeOnWater) {
                                pos = pos.relative(hitDirection.getOpposite());
                            }
                            poseStack.pushPose();
                            double camX = camera.getPosition().x;
                            double camY = camera.getPosition().y;
                            double camZ = camera.getPosition().z;
                            poseStack.translate((double)pos.getX() - camX, (double)pos.getY() - camY, (double)pos.getZ() - camZ);
                            MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
                            BlockEntityRenderer entityRender = minecraft.getBlockEntityRenderDispatcher().getRenderer(entity);
                            if (entityRender != null) {
                                entityRender.render(entity, partialTick, poseStack, (MultiBufferSource)buffer, 0xFFFFFF, OverlayTexture.NO_OVERLAY);
                            }
                            if (!multiBlock.skipJsonRendering()) {
                                MultiblockPreviewRenderer.renderJsonModels(minecraft, level, poseStack, multiBlock, pos, state, buffer, previewMode);
                            }
                            poseStack.popPose();
                        }
                    }
                }
            }
        }
    }

    private static void renderJsonModels(Minecraft minecraft, Level level, PoseStack poseStack, IPreviewableMultiblock multiBlock, BlockPos originalPos, BlockState stateOriginal, MultiBufferSource.BufferSource buffer, final PreviewMode previewMode) {
        BlockRenderDispatcher blockRenderer = minecraft.getBlockRenderer();
        poseStack.translate(1.0E-4, 1.0E-4, 1.0E-4);
        multiBlock.prepareForPlace(level, originalPos, stateOriginal).forEach(pair -> {
            BlockState state = (BlockState)pair.getSecond();
            BlockPos pos = ((BlockPos)pair.getFirst()).immutable();
            if (!state.getRenderShape().equals((Object)RenderShape.MODEL)) {
                return;
            }
            BlockPos offset = pos.subtract((Vec3i)originalPos).immutable();
            poseStack.translate((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
            VertexConsumerWrapper tintedConsumer = new VertexConsumerWrapper(buffer.getBuffer(RenderType.translucent())){

                public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightness, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay, boolean readAlpha) {
                    super.putBulkData(pose, quad, brightness, red * previewMode.red, green * previewMode.green, blue * previewMode.blue, alpha * previewMode.alpha, lightmap, packedOverlay, readAlpha);
                }
            };
            blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)tintedConsumer, false, minecraft.level.getRandom());
            buffer.endLastBatch();
            poseStack.translate((float)(-offset.getX()), (float)(-offset.getY()), (float)(-offset.getZ()));
        });
    }
}

