package net.nikdo53.tinymultiblocklib.block;

import oshi.util.tuples.Pair;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public interface IPreviewableMultiblock extends IMultiBlock {
    /**
     * May save performance and fix translucency glitches if your preview only uses a block entity renderer.
     * Usually it's easier to override {@link class_4970#method_9604(class_2680)} instead
     * */
    default boolean skipJsonRendering() {
        return false;
    }

    /**
     * Returns the default BlockState that will be used for previews
     * */
    default class_2680 getDefaultStateForPreviews(class_2350 direction) {
        class_2680 blockState = getBlock().method_9564().method_11657(AbstractMultiBlock.CENTER, true);

        if (getDirectionProperty() == null) return blockState;
        return blockState.method_47968(getDirectionProperty(), direction);
    };

    /**
     * Prepares all blocks to be previewed
     * */
    default List<Pair<class_2338, class_2680>> getPreviewStates(class_2338 posOriginal, class_2680 stateOriginal){
        List<Pair<class_2338, class_2680>> list = new ArrayList<>();

        fullBlockShape(posOriginal, stateOriginal).forEach(posNew -> {

            posNew = posNew.method_10062();
            class_2680 stateNew = stateOriginal.method_11657(AbstractMultiBlock.CENTER, posOriginal.equals(posNew));
            if (getStateFromOffset() != null) stateNew = getStateFromOffset().apply(stateNew, posNew.method_10059(posOriginal));

            list.add(new Pair<>(posNew, stateNew));
        });

        return list;
    }
}
