package net.nikdo53.tinymultiblocklib.blockentities;

import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

public class AbstractMultiBlockEntity extends class_2586 implements IMultiBlockEntity{
    public class_2338 center;
    public boolean isPlaced;
    public PreviewMode previewMode = PreviewMode.PLACED;

    public AbstractMultiBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.center = this.method_11016();
        this.isPlaced = false;
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10566("center", class_2512.method_10692(this.center));
        tag.method_10556("placed", this.isPlaced);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        method_11007(tag, registries);
        return tag;
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.center = class_2512.method_10691(tag, "center").orElseGet(this::method_11016);
        this.isPlaced = tag.method_10577("placed");
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(class_2338 pos) {
        this.center = pos;
    }

    @Override
    public boolean isPlaced() {
        return isPlaced;
    }

    @Override
    public void setPlaced(boolean placed) {
        this.isPlaced = placed;
    }

    @Override
    public PreviewMode getPreviewMode() {
        return previewMode;
    }

    @Override
    public void setPreviewMode(PreviewMode mode) {
        this.previewMode = mode;
    }

/**
 * Certain mods let you change the location of the multiblock (like Carry on)
 * <p>
 * That's a problem because the {@link #center} won't update. This should trick it into updating
 */
 @Override
    public void method_31664(class_2680 blockState) {
        if (IMultiBlock.isCenter(blockState)){
            setCenter(this.method_11016());
        }
        super.method_31664(blockState);
    }

}
