package net.nikdo53.tinymultiblocklib.blockentities;

import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_4538;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

public interface IMultiBlockEntity {
    class_2338 getCenter();
    void setCenter(class_2338 pos);

    /**
     * True once the whole placing logic runs (to prevent updateShape from breaking it early)
     * */
    boolean isPlaced();
    void setPlaced(boolean placed);

    PreviewMode getPreviewMode();
    void setPreviewMode(PreviewMode mode);

    static void setPlaced(class_4538 level, class_2338 blockPos) {
        if(level.method_8321(blockPos) instanceof IMultiBlockEntity entity) entity.setPlaced(true);
    }

    default boolean isCenter(){
        return getBlockEntity().method_11016().equals(getCenter());
    }

    default class_2586 getBlockEntity(){
        if (this instanceof class_2586 entity){
            return entity;
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a BlockEntity");
        }
    }
}
