package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.*;
import net.nikdo53.tinymultiblocklib.Constants;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.IBlockPosOffsetEnum;

import javax.annotation.Nullable;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public interface IMultiBlock {

    /** Returns a BlockPos Stream of every block in this multiblock. */
    Stream<class_2338> fullBlockShape(@Nullable class_2350 direction, class_2338 center);

    /**
     * Returns the multiblocks DirectionProperty.
     * <p>
     * Only used for multiblocks that can be rotated, otherwise returns null
     * */

    default @Nullable class_2753 getDirectionProperty(){
        return null; // null if block doesn't have directions
    }

    default @Nullable class_2350 getDirection(class_2680 state){
        if (getDirectionProperty() != null){
            return state.method_11654(getDirectionProperty());
        }
        return null;
    }

    default class_2248 getBlock(){
        if (this instanceof class_2248 block){
            return block;
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
        }
    }

    default Stream<class_2338> fullBlockShape(class_2338 center, @Nullable class_2680 state){
        if (getDirectionProperty() == null || state == null)
            return fullBlockShape(null, center);

        return fullBlockShape(state.method_11654(getDirectionProperty()), center);
    }

    static Stream<class_2338> getFullShape(class_1937 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity multiBlockEntity
                && level.method_8320(pos).method_26204() instanceof IMultiBlock multiBlock){

            return multiBlock.fullBlockShape(multiBlockEntity.getCenter(), level.method_8320(pos));
        }
        else return Stream.of(pos);
    }

    /**
     * Changes the BlockState for each Block based on its offset from center
     * <p>
     * Code Example:
     * <p>
     * ((state, pos) -> state.setValue(yourStateProperty, IBlockPosOffsetEnum.fromOffset(params)))
     * @see IBlockPosOffsetEnum#fromOffset(Class, class_2338, class_2350, Enum)
     * */
    default @Nullable BiFunction<class_2680, class_2338, class_2680> getStateFromOffset() {
        return null;
    };

    /**
     * Places the multiblock, sets its BlockStates and BlockEntity center
     * */
    default void place(class_1937 level, class_2338 posOriginal, class_2680 stateOriginal){
        fullBlockShape(posOriginal, stateOriginal).forEach(posNew -> {
            int flags = level.field_9236 ? 0 : 3;

            class_2680 stateNew = stateOriginal.method_11657(AbstractMultiBlock.CENTER, posOriginal.equals(posNew));
            if (getStateFromOffset() != null) stateNew = getStateFromOffset().apply(stateNew, posNew.method_10059(posOriginal));

            level.method_8652(posNew, stateNew, flags);
            if(level.method_8321(posNew) instanceof IMultiBlockEntity entity) {
                entity.setCenter(posOriginal);
                entity.getBlockEntity().method_5431();
            }
        });
    }

    default class_2680 getStateForPlacementHelper(class_1750 context) {
        return getStateForPlacementHelper(context, context.method_8042());
    }

    /**
     * Helper for {@link class_2248#method_9605(class_1750)}
     * @param direction The direction the block will have when placed, ignored when {@link #getDirectionProperty()} is null
     * */
    default class_2680 getStateForPlacementHelper(class_1750 context, class_2350 direction) {
        class_4538 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = getBlock().method_9564().method_11657(AbstractMultiBlock.CENTER, true);

        if (getDirectionProperty() != null){
            state = state.method_11657(getDirectionProperty(), direction);
        }

        return canPlace(level, pos, state) ? state : null;
    }

    default boolean canPlace(class_4538 level, class_2338 center, class_2680 state) {
        return fullBlockShape(center, state).allMatch(blockPos -> level.method_8320(blockPos).method_45474() && extraSurviveRequirements(level, blockPos, state));
    }

    default void destroy(class_2338 center, class_1937 level, class_2680 state){
        if (level.method_8608()) return;
        fullBlockShape(center, state).forEach(pos ->{
            class_2680 blockState = level.method_8320(pos);
            class_2248 block = state.method_26204();
            if (blockState.method_27852(block)) {
                level.method_22352(pos, true);
            }
        });
    }

    default boolean allBlocksPresent(class_4538 level, class_2338 pos, class_2680 state){
        if (level.method_8608()) return true;
        class_2338 center = getCenter(level, pos);

        boolean ret = fullBlockShape(center, state).allMatch(blockPos -> level.method_8320(blockPos).method_27852(getBlock()));

        if (ret && level.method_8321(pos) instanceof IMultiBlockEntity entity && !entity.isPlaced()) {
            fullBlockShape(center, state).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos));
        }

        return ret;
    }

    /**
     * Helper for {@link class_2248#method_9559(class_2680, class_2350, class_2680, class_1936, class_2338, class_2338)}
     * <p>
     * Destroys the multiblock if canSurvive returns false
     * */
    default class_2680 updateShapeHelper(class_2680 state, class_1936 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity){
            boolean canSurvive = state.method_26184(level, pos);
            if (!canSurvive){
                destroy(entity.getCenter(), (class_1937) level, state);
                return class_2246.field_10124.method_9564();
            }
        }else {
            level.method_22352(pos, true);
            return class_2246.field_10124.method_9564();
        }

        return state;
    }

    /**
     * Helper for {@link class_2248#method_9558(class_2680, class_4538, class_2338)}
     * */
    default boolean canSurviveHelper(class_2680 state, class_4538 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity){
            //survive logic
            boolean extraSurvive = fullBlockShape(entity.getCenter(), state).allMatch(blockPos -> extraSurviveRequirements(level, blockPos, state));
            return (allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        } else {
            //placement logic
            return canPlace(level, pos, state);
        }
    }

    /**
     * Extra requirements for the block to survive or be placed, runs for every single block in the multiblock
     * */
    default boolean extraSurviveRequirements(class_4538 level, class_2338 pos, class_2680 state){
        return true;
    }

    /**
     * Should be added into {@link class_2248#method_9556(class_1937, class_1657, class_2338, class_2680, class_2586, class_1799)}
     * */
    default void preventCreativeDrops(class_1657 player, class_1937 level, class_2338 pos){
        if (player.method_7337() && level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            level.method_22352(entity.getCenter(), false);
        }
    }


    /**
     * Prevents desyncs and ghost blocks when multiblocks are used in structures
     * */
    default void fixInStructures(class_2680 state, class_5425 level, class_2338 pos){
        if (isCenter(state)) {
            level.method_39279(pos, state.method_26204(), 3);
        }
    }

    /**
     * Tries to fix the multiblock, called after {@link #fixInStructures(class_2680, class_5425, class_2338)}
     * */
    default void fixTick(class_2680 state, class_1937 level, class_2338 pos){
        if (isCenter(state)){

            fullBlockShape(pos, state).forEach(posNew -> {
                if (level.method_8321(posNew) instanceof IMultiBlockEntity entity) {
                    entity.setCenter(pos);

                    entity.getBlockEntity().method_5431();
                    level.method_8413(posNew, state, state, 2);
                }
            });
        }
    }

    /**
     * Checks if the multiblock needs fixing by  {@link #fixTick(class_2680, class_1937, class_2338)}
     * */
    default boolean isBroken(class_4538 level, class_2338 pos, class_2680 state){
        if (!isCenter(state)) return false;

        return fullBlockShape(pos, state).anyMatch(blockPos -> {
            if (level.method_8321(blockPos) instanceof IMultiBlockEntity entity){
                return !(entity.getCenter().equals(pos) && !isCenter(level.method_8320(blockPos)));
            }
            return true;
        });
    }

    /**
     * Returns the center BlockPos of the multiblock
     * */
    static class_2338 getCenter(class_1922 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity){
            return entity.getCenter();
        }
        return pos;
    }

    static boolean isCenter(class_4538 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            return entity.getCenter().equals(pos);
        }
        return false;
    }

    static boolean isCenter(class_2680 state){
        return state.method_11654(AbstractMultiBlock.CENTER);
    }

    static boolean isMultiblock(class_2680 state){
        return state.method_26204() instanceof IMultiBlock;
    }

    static boolean isMultiblock(class_1922 level, class_2338 pos){
        return isMultiblock(level.method_8320(pos));
    }

    static int getXOffset(class_1922 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            return pos.method_10263() - entity.getCenter().method_10263();
        }
        return 0;
    }

    static int getYOffset(class_1922 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            return pos.method_10264() - entity.getCenter().method_10264();
        }
        return 0;
    }

    static int getZOffset(class_1922 level, class_2338 pos){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            return pos.method_10260() - entity.getCenter().method_10260();
        }
        return 0;
    }

    default class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape){
        return voxelShapeHelper(state,level,pos,shape, 0, 0, 0);
    }

    default class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset){
        return voxelShapeHelper(state,level,pos,shape, xOffset, yOffset, zOffset, false);
    }

    /**
     * Offsets each Blocks VoxelShape to the center, allowing for VoxelShapes larger than 1 block
     * @param hasDirectionOffsets Larger directional multiblocks may have their center in a different point for every rotation, this offsets the VoxelShapes accordingly
     * */
    default class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets){
        if (level.method_8321(pos) instanceof IMultiBlockEntity entity) {
            var x = entity.getCenter().method_10263() - pos.method_10263() + xOffset;
            var y = entity.getCenter().method_10264() - pos.method_10264() + yOffset;
            var z = entity.getCenter().method_10260() - pos.method_10260() + zOffset;

            if (getDirectionProperty() != null && hasDirectionOffsets) {
                switch (state.method_11654(getDirectionProperty())) {
                    case field_11034 -> x += 1;
                    case field_11043 -> {
                        x += 1;
                        z -= 1;
                    }
                    case field_11039 -> z -= 1;
                }
            }
            return shape.method_1096(x,y,z);
        }
        return shape;
    }

    /**
     * Increases age in each block at the same time
     * <p>
     * If used in the randomTick method, don't forget to check {@link #isCenter(class_2680)} first,
     * otherwise the block will grow significantly faster (each block tick separately)
     * */
    default void growHelper(class_1937 level, class_2338 blockPos, class_2758 ageProperty){
        class_2248 block = getBlock();
        if(level.method_8321(blockPos) instanceof IMultiBlockEntity entity) {
            fullBlockShape(entity.getCenter(), level.method_8320(blockPos)).forEach(pos -> {
                if(level.method_8320(pos).method_27852(block)) {

                    class_2680 blockState = level.method_8320(pos);
                    int age = blockState.method_11654(ageProperty);
                    if (blockState.method_11654(ageProperty) >= getMaxAge(ageProperty)) return;

                    level.method_8652(pos, blockState.method_11657(ageProperty,age + 1), 2);

                }else {
                    level.method_22352(pos, false);
                }
            });
        } else level.method_22352(blockPos, true);
    }

    default int getMaxAge(class_2758 ageProperty) {
        return ageProperty.method_11898().stream().toList().get(ageProperty.method_11898().size() - 1);
    }
}
