package net.nikdo53.tinymultiblocklib.components;

import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;

public interface IBlockPosOffsetEnum {
    class_2338 getOffset();

    /**
     * Returns an enum value of type E based on its BlockPos offset
     * @param enumClass The .class of the enum this is implemented on
     * @param fallback Default value for when the offset doesn't match any other value
     * @param <E> Your enum, probably used in a BlockState
     * */
    static <E extends Enum<E> & IBlockPosOffsetEnum> E fromOffset(Class<E> enumClass, class_2338 offset, @Nullable class_2350 direction, E fallback) {
        for (E part : enumClass.getEnumConstants()) {
            class_2338 testOffset = part.getOffset();
            if (direction != null) {
                testOffset = testOffset.method_10070(rotationFromDirection(direction));
            }
            if (testOffset.equals(offset)) {
                return part;
            }
        }
        return fallback;
    }

    /**
     * Rotates a BlockPos
     * */
    static class_2470 rotationFromDirection(class_2350 direction){
        return switch (direction){
            case field_11033, field_11043, field_11036 -> class_2470.field_11467;
            case field_11035 -> class_2470.field_11464;
            case field_11039 -> class_2470.field_11465;
            case field_11034 -> class_2470.field_11463;
        };
    }

}
