/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock {
    public Stream<class_2338> fullBlockShape(@Nullable class_2350 var1, class_2338 var2);

    @Nullable
    default public class_2753 getDirectionProperty() {
        return null;
    }

    @Nullable
    default public class_2350 getDirection(class_2680 state) {
        if (this.getDirectionProperty() != null) {
            return (class_2350)state.method_11654((class_2769)this.getDirectionProperty());
        }
        return null;
    }

    default public class_2248 getBlock() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof class_2248) {
            class_2248 block = (class_2248)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }

    default public Stream<class_2338> fullBlockShape(class_2338 center, @Nullable class_2680 state) {
        if (this.getDirectionProperty() == null || state == null) {
            return this.fullBlockShape(null, center);
        }
        return this.fullBlockShape((class_2350)state.method_11654((class_2769)this.getDirectionProperty()), center);
    }

    public static Stream<class_2338> getFullShape(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity multiBlockEntity = (IMultiBlockEntity)class_25862;
            class_25862 = level.method_8320(pos).method_26204();
            if (class_25862 instanceof IMultiBlock) {
                IMultiBlock multiBlock = (IMultiBlock)class_25862;
                return multiBlock.fullBlockShape(multiBlockEntity.getCenter(), level.method_8320(pos));
            }
        }
        return Stream.of(pos);
    }

    @Nullable
    default public BiFunction<class_2680, class_2338, class_2680> getStateFromOffset() {
        return null;
    }

    default public void place(class_1937 level, class_2338 posOriginal, class_2680 stateOriginal) {
        this.fullBlockShape(posOriginal, stateOriginal).forEach(posNew -> {
            int flags = level.field_9236 ? 0 : 3;
            class_2680 stateNew = (class_2680)stateOriginal.method_11657((class_2769)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(posOriginal.equals(posNew)));
            if (this.getStateFromOffset() != null) {
                stateNew = this.getStateFromOffset().apply(stateNew, posNew.method_10059((class_2382)posOriginal));
            }
            level.method_8652(posNew, stateNew, flags);
            class_2586 patt3730$temp = level.method_8321(posNew);
            if (patt3730$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt3730$temp;
                entity.setCenter(posOriginal);
                entity.getBlockEntity().method_5431();
            }
        });
    }

    default public class_2680 getStateForPlacementHelper(class_1750 context) {
        return this.getStateForPlacementHelper(context, context.method_8042());
    }

    default public class_2680 getStateForPlacementHelper(class_1750 context, class_2350 direction) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = (class_2680)this.getBlock().method_9564().method_11657((class_2769)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (class_2680)state.method_11657((class_2769)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((class_4538)level, pos, state) ? state : null;
    }

    default public boolean canPlace(class_4538 level, class_2338 center, class_2680 state) {
        return this.fullBlockShape(center, state).allMatch(blockPos -> level.method_8320(blockPos).method_45474() && this.extraSurviveRequirements(level, (class_2338)blockPos, state));
    }

    default public void destroy(class_2338 center, class_1937 level, class_2680 state) {
        if (level.method_8608()) {
            return;
        }
        this.fullBlockShape(center, state).forEach(pos -> {
            class_2248 block;
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_27852(block = state.method_26204())) {
                level.method_22352(pos, true);
            }
        });
    }

    default public boolean allBlocksPresent(class_4538 level, class_2338 pos, class_2680 state) {
        IMultiBlockEntity entity;
        class_2586 class_25862;
        if (level.method_8608()) {
            return true;
        }
        class_2338 center = IMultiBlock.getCenter((class_1922)level, pos);
        boolean ret = this.fullBlockShape(center, state).allMatch(blockPos -> level.method_8320(blockPos).method_27852(this.getBlock()));
        if (ret && (class_25862 = level.method_8321(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)class_25862).isPlaced()) {
            this.fullBlockShape(center, state).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos));
        }
        return ret;
    }

    default public class_2680 updateShapeHelper(class_2680 state, class_1936 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            boolean canSurvive = state.method_26184((class_4538)level, pos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (class_1937)level, state);
                return class_2246.field_10124.method_9564();
            }
        } else {
            level.method_22352(pos, true);
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    default public boolean canSurviveHelper(class_2680 state, class_4538 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            boolean extraSurvive = this.fullBlockShape(entity.getCenter(), state).allMatch(blockPos -> this.extraSurviveRequirements(level, (class_2338)blockPos, state));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state);
    }

    default public boolean extraSurviveRequirements(class_4538 level, class_2338 pos, class_2680 state) {
        return true;
    }

    default public void preventCreativeDrops(class_1657 player, class_1937 level, class_2338 pos) {
        class_2586 class_25862;
        if (player.method_7337() && (class_25862 = level.method_8321(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            level.method_22352(entity.getCenter(), false);
        }
    }

    default public void fixInStructures(class_2680 state, class_5425 level, class_2338 pos) {
        if (IMultiBlock.isCenter(state)) {
            level.method_39279(pos, state.method_26204(), 3);
        }
    }

    default public void fixTick(class_2680 state, class_1937 level, class_2338 pos) {
        if (IMultiBlock.isCenter(state)) {
            this.fullBlockShape(pos, state).forEach(posNew -> {
                class_2586 patt8804$temp = level.method_8321(posNew);
                if (patt8804$temp instanceof IMultiBlockEntity) {
                    IMultiBlockEntity entity = (IMultiBlockEntity)patt8804$temp;
                    entity.setCenter(pos);
                    entity.getBlockEntity().method_5431();
                    level.method_8413(posNew, state, state, 2);
                }
            });
        }
    }

    default public boolean isBroken(class_4538 level, class_2338 pos, class_2680 state) {
        if (!IMultiBlock.isCenter(state)) {
            return false;
        }
        return this.fullBlockShape(pos, state).anyMatch(blockPos -> {
            class_2586 patt9433$temp = level.method_8321(blockPos);
            if (patt9433$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt9433$temp;
                return !entity.getCenter().equals((Object)pos) || IMultiBlock.isCenter(level.method_8320(blockPos));
            }
            return true;
        });
    }

    public static class_2338 getCenter(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return entity.getCenter();
        }
        return pos;
    }

    public static boolean isCenter(class_4538 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return entity.getCenter().equals((Object)pos);
        }
        return false;
    }

    public static boolean isCenter(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)AbstractMultiBlock.CENTER);
    }

    public static boolean isMultiblock(class_2680 state) {
        return state.method_26204() instanceof IMultiBlock;
    }

    public static boolean isMultiblock(class_1922 level, class_2338 pos) {
        return IMultiBlock.isMultiblock(level.method_8320(pos));
    }

    public static int getXOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10263() - entity.getCenter().method_10263();
        }
        return 0;
    }

    public static int getYOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10264() - entity.getCenter().method_10264();
        }
        return 0;
    }

    public static int getZOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10260() - entity.getCenter().method_10260();
        }
        return 0;
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            float x = (float)(entity.getCenter().method_10263() - pos.method_10263()) + xOffset;
            float y = (float)(entity.getCenter().method_10264() - pos.method_10264()) + yOffset;
            float z = (float)(entity.getCenter().method_10260() - pos.method_10260()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((class_2350)state.method_11654((class_2769)this.getDirectionProperty())) {
                    case field_11034: {
                        x += 1.0f;
                        break;
                    }
                    case field_11043: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case field_11039: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.method_1096((double)x, (double)y, (double)z);
        }
        return shape;
    }

    default public void growHelper(class_1937 level, class_2338 blockPos, class_2758 ageProperty) {
        class_2248 block = this.getBlock();
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            this.fullBlockShape(entity.getCenter(), level.method_8320(blockPos)).forEach(pos -> {
                if (level.method_8320(pos).method_27852(block)) {
                    class_2680 blockState = level.method_8320(pos);
                    int age = (Integer)blockState.method_11654((class_2769)ageProperty);
                    if ((Integer)blockState.method_11654((class_2769)ageProperty) >= this.getMaxAge(ageProperty)) {
                        return;
                    }
                    level.method_8652(pos, (class_2680)blockState.method_11657((class_2769)ageProperty, (Comparable)Integer.valueOf(age + 1)), 2);
                } else {
                    level.method_22352(pos, false);
                }
            });
        } else {
            level.method_22352(blockPos, true);
        }
    }

    default public int getMaxAge(class_2758 ageProperty) {
        return (Integer)ageProperty.method_11898().stream().toList().get(ageProperty.method_11898().size() - 1);
    }
}

