package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public interface IPreviewableMultiblock extends IMultiBlock {
    /**
     * May save performance and fix translucency glitches if your preview only uses a block entity renderer.
     * Usually it's easier to override {@link class_4970#method_9604(class_2680)} instead
     * */
    default boolean skipJsonRendering() {
        return false;
    }

    /**
     * Returns the default BlockState that will be used for previews
     * */
    default class_2680 getDefaultStateForPreviews(class_2350 direction) {
        class_2680 blockState = self().method_9564().method_11657(AbstractMultiBlock.CENTER, true);

        if (getDirectionProperty() == null) return blockState;
        return blockState.method_47968(getDirectionProperty(), direction);
    };

    /**
     * Allows changing the blocks block entity before it gets rendered as a preview.
     * This block entity matches the one your {@link net.minecraft.class_2343#method_10123(class_2338, class_2680)} returns,
     * so feel free to cast it.
     * */
    default class_2586 getBlockEntityForPreviews(class_2586 entity, class_1937 level, class_2338 blockPos) {
        return entity;
    }

    private class_2248 self(){
        if (this instanceof class_2248 block){
            return block;
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
        }
    }
}
