package net.nikdo53.tinymultiblocklib.client;

import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;

import java.util.function.Function;

/**
 * A helper interface for making previewable multiblock entities.
 * */
public interface IMultiblockRenderHelper {

    /**
     * Returns a translucent RenderType for when rendered as a preview. Use instead of specifying the RenderType directly.
     * */
    default Function<class_2960, class_1921> getRenderTypeFunction(PreviewMode previewMode) {
       return getRenderTypeFunction(previewMode, class_1921::method_23689);
    }

    default Function<class_2960, class_1921> getRenderTypeFunction(PreviewMode previewMode, Function<class_2960, class_1921> defaultRenderType) {
        return previewMode.equals(PreviewMode.PLACED) ? class_1921::method_23576 : defaultRenderType;
    }

    default class_1921 getRenderType(PreviewMode previewMode, class_2960 texture) {
        return getRenderType(previewMode, texture, class_1921.method_23689(texture));
    }

    default class_1921 getRenderType(PreviewMode previewMode, class_2960 texture, class_1921 defaultRenderType) {
        return previewMode.equals(PreviewMode.PLACED) ? class_1921.method_23576(texture) : defaultRenderType;
    }


    /**
     * For when you use the same BER for 2 different blocks and just swap out the textures.
     * <p>
     * It's necessary to make multiple VertexConsumers instead of just 1, otherwise the RenderTypes won't apply correctly
     * */
    default class_4588 getConsumer(class_4597 buffer, IMultiBlockEntity blockEntity, class_4730 materialBase, class_4730 materialSecondary, class_2248 blockSecondary) {
        PreviewMode previewMode = blockEntity.getPreviewMode();

        class_1921 renderTypeBase = getRenderType(previewMode, materialBase.method_24144());
        class_1921 renderTypeCorrupted = getRenderType(previewMode, materialSecondary.method_24144());

        class_4588 baseConsumer = materialBase.method_24148().method_24108(buffer.getBuffer(renderTypeBase));
        class_4588 corruptedConsumer = materialSecondary.method_24148().method_24108(buffer.getBuffer(renderTypeCorrupted));

        return blockEntity.getBlockEntity().method_11010().method_27852(blockSecondary) ? corruptedConsumer : baseConsumer;
    }


    /**
     * A somewhat cleaner way to get the level
     * */
    default class_1937 level(){
        class_638 level = class_310.method_1551().field_1687;
        if (level == null){
            throw new IllegalStateException("BlockEntityRenderer Level is null");
        }
        return level;
    }

    /**
     * Should be used instead of {@link class_630#method_22698(class_4587, class_4588, int, int)}
     * <p>
     * Applies the correct color + alpha according to the supplied PreviewMode
     * */
    default void render(class_630 modelPart, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, PreviewMode previewMode) {
        float r = 1f;
        float g = 1f;
        float b = 1f;
        float alpha = 1f;

        render(modelPart, poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, alpha, previewMode);
    }

    /**
     * Should be used instead of {@link class_630#method_22698(class_4587, class_4588, int, int)}
     * <p>
     * Applies the correct color + alpha according to the supplied PreviewMode
     * */
    default void render(class_630 modelPart, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, float r, float g, float b, float alpha, PreviewMode previewMode) {
        float[] rgba = previewMode.applyColorsFloat(r, g, b, alpha);

        modelPart.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, rgba[0], rgba[1], rgba[2], rgba[3]);
    }
}
