package net.nikdo53.tinymultiblocklib.client;

import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1841;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_827;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.compat.carryon.CarryOnPreviewHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import net.nikdo53.tinymultiblocklib.mixin.ItemAccessor;
import net.nikdo53.tinymultiblocklib.platform.services.IPlatformHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

public class MultiblockPreviewRenderer {

    public static void renderMultiblockPreviews(float partialTick, class_310 minecraft, class_1937 level, class_4184 camera, class_4587 poseStack, IPlatformHelper platformHelper) {
        class_746 player = minecraft.field_1724;
        assert player != null;
        class_1799 stack = player.method_6047();
        class_1792 item = stack.method_7909();

        if (platformHelper.isModLoaded("carryon") && CarryOnPreviewHelper.isValidMultiblock(player)) {
            item = CarryOnPreviewHelper.getMultiblockItem(player);
        }

        if (item instanceof class_1747 blockItem && blockItem.method_7711() instanceof IPreviewableMultiblock multiBlock && blockItem.method_7711() instanceof class_2343 block) {
            class_239 hitResult = minecraft.field_1765;

            if (hitResult instanceof class_3965 blockHitResult){
                boolean placeOnWater = false;

                if (blockItem instanceof class_1841) {
                    blockHitResult = ItemAccessor.getPlayerPOVHitResult(level, player, class_3959.class_242.field_1345);
                    placeOnWater = level.method_22351(blockHitResult.method_17777());
                };

                class_2350 hitDirection = blockHitResult.method_17780();
                class_2338 hitPos = blockHitResult.method_17777();
                class_2338 pos =  hitPos.method_10093(hitDirection);

                class_2680 state = multiBlock.getDefaultStateForPreviews(player.method_5735());
                class_2586 entity = block.method_10123(pos, state);

                boolean shouldShowPreview = level.method_8320(pos).method_45474() && (!level.method_8320(hitPos).method_26215() || placeOnWater);
                if (entity instanceof IMultiBlockEntity multiBlockEntity && shouldShowPreview) {
                    entity.method_31662(level);
                    entity = multiBlock.getBlockEntityForPreviews(entity, level, pos);

                    boolean multiBlockCanPlace = multiBlock.canPlace(level, pos, state, player, true);
                    boolean entityUnobstructed = multiBlock.entityUnobstructed(level, pos, state, player);

                    PreviewMode previewMode = multiBlockCanPlace ? (entityUnobstructed ? PreviewMode.PREVIEW : PreviewMode.ENTITY_BLOCKED) : PreviewMode.INVALID;
                    multiBlockEntity.setPreviewMode(previewMode);

                    if (level.method_8320(hitPos).method_45474() && !placeOnWater) pos = pos.method_10093(hitDirection.method_10153());

                    poseStack.method_22903();

                    double camX = camera.method_19326().field_1352;
                    double camY = camera.method_19326().field_1351;
                    double camZ = camera.method_19326().field_1350;
                    poseStack.method_22904(pos.method_10263() - camX,pos.method_10264() - camY,pos.method_10260() - camZ);


                    class_4597.class_4598 buffer = minecraft.method_22940().method_23000();
                    class_827<class_2586> entityRender = minecraft.method_31975().method_3550(entity);

                    if (entityRender != null) entityRender.method_3569(entity, partialTick, poseStack, buffer, 0xFFFFFF, class_4608.field_21444);

                    if (!multiBlock.skipJsonRendering()) renderJsonModels(minecraft, level, poseStack, multiBlock, pos, state, buffer, previewMode);

                    poseStack.method_22909();

                }
            }
        }
    }

    private static void renderJsonModels(class_310 minecraft, class_1937 level, class_4587 poseStack, IPreviewableMultiblock multiBlock, class_2338 originalPos, class_2680 stateOriginal, class_4597.class_4598 buffer, PreviewMode previewMode) {
        class_776 blockRenderer = minecraft.method_1541();
        poseStack.method_22904(0.0001,0.0001,0.0001);

        multiBlock.prepareForPlace(level, originalPos, stateOriginal).forEach(pair -> {

            class_2680 state = pair.getSecond();
            class_2338 pos = pair.getFirst().method_10062();

            if (!state.method_26217().equals(class_2464.field_11458)) return;

            class_2338 offset = pos.method_10059(originalPos).method_10062();
            poseStack.method_46416(offset.method_10263(),  offset.method_10264(), offset.method_10260());

            VertexConsumerWrapper tintedConsumer = new VertexConsumerWrapper(buffer.getBuffer(class_1921.method_23583())) {
                @Override
                public void method_22920(class_4587.class_4665 pose, class_777 quad, float[] colorMuls, float red, float green, float blue, int[] combinedLights, int combinedOverlay, boolean mulColor) {
                    super.method_22920(pose, quad, colorMuls, red, green, blue, combinedLights, combinedOverlay, mulColor);
                }

                @Override
                public class_4588 method_22915(float red, float green, float blue, float alpha) {
                    return super.method_22915(red * previewMode.red, green * previewMode.green, blue * previewMode.blue, alpha * previewMode.alpha);
                }
            };

            blockRenderer.method_3355(state, pos, level, poseStack, tintedConsumer, false, minecraft.field_1687.method_8409());

            buffer.method_37104();

            poseStack.method_46416(-offset.method_10263(),  -offset.method_10264(), -offset.method_10260());
        });
    }

}
