/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.components.PropertyWrapper;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;

public interface IMBStateSyncer {
    public SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder();

    default public List<PropertyWrapper<?>> getSyncedStateProperties() {
        SyncedStatePropertiesBuilder syncedStatePropertiesBuilder = this.getSyncedStatePropertiesBuilder();
        if (!syncedStatePropertiesBuilder.isInitialized()) {
            this.createSyncedBlockStates(syncedStatePropertiesBuilder);
            syncedStatePropertiesBuilder.setInitialized();
        }
        return syncedStatePropertiesBuilder.getProperties();
    }

    default public void createSyncedBlockStates(SyncedStatePropertiesBuilder builder) {
        class_2753 directionProperty = this.getMultiBlock().getDirectionProperty();
        if (directionProperty != null) {
            builder.add(directionProperty);
        }
    }

    public static <T extends Comparable<T>> void setBlockStates(class_1937 level, class_2338 pos, List<PropertyWrapper<?>> stateValuePairs) {
        IMBStateSyncer.setBlockStates(level, pos, 3, stateValuePairs);
    }

    public static <T extends Comparable<T>> void setBlockState(class_1937 level, class_2338 pos, class_2769<T> property, T value) {
        IMBStateSyncer.setBlockStates(level, pos, 3, List.of(new PropertyWrapper<T>(property, value)));
    }

    public static <T extends Comparable<T>> void setBlockStates(class_1937 level, class_2338 pos, int flags, List<PropertyWrapper<?>> properties) {
        IMultiBlock.getFullShape(level, pos).forEach(pos1 -> {
            class_2680 state = level.method_8320(pos1);
            for (PropertyWrapper propertyWrapper : properties) {
                state = propertyWrapper.applyTo(state);
            }
            level.method_8652(pos1, state, flags);
        });
    }

    default public void syncBlockStates(class_1937 level, class_2338 pos, class_2680 state) {
        ArrayList list = new ArrayList(this.getSyncedStateProperties());
        class_2338 centerPos = IMultiBlock.getCenter((class_1922)level, pos);
        class_2680 centerState = level.method_8320(centerPos);
        boolean isCenter = IMultiBlock.isCenter(state);
        for (PropertyWrapper propertyWrapper : list) {
            propertyWrapper.captureValue(state);
            if (isCenter) continue;
            centerState = propertyWrapper.applyTo(centerState);
        }
        if (!isCenter) {
            level.method_8652(centerPos, centerState, 2);
            return;
        }
        IMBStateSyncer.setBlockStates(level, pos, list);
    }

    private IMultiBlock getMultiBlock() {
        IMBStateSyncer iMBStateSyncer = this;
        if (iMBStateSyncer instanceof IMultiBlock) {
            IMultiBlock block = (IMultiBlock)iMBStateSyncer;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on an IMultiBlock");
    }
}

