package net.nikdo53.tinymultiblocklib.block;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.nikdo53.tinymultiblocklib.components.PropertyWrapper;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

import static net.nikdo53.tinymultiblocklib.block.IMultiBlock.*;

public interface IMBStateSyncer {

    SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder();

    default List<PropertyWrapper<?>> getSyncedStateProperties(){
        SyncedStatePropertiesBuilder syncedStatePropertiesBuilder = getSyncedStatePropertiesBuilder();

        if (!syncedStatePropertiesBuilder.isInitialized()){
            createSyncedBlockStates(syncedStatePropertiesBuilder);

            syncedStatePropertiesBuilder.setInitialized();
        }

        return syncedStatePropertiesBuilder.getProperties();
    };

    /**
     * Registers BlockStates to be automatically synced across the whole multiblock
     * */
    default void createSyncedBlockStates(SyncedStatePropertiesBuilder builder){
        class_2753 directionProperty = getMultiBlock().getDirectionProperty();
        if (directionProperty != null){
            builder.add(directionProperty);
        }
    }

    /**
     * Updates the provided BlockStateProperties for each block in the multiblock
     * */
    static <T extends Comparable<T>> void setBlockStates(class_1937 level, class_2338 pos, List<PropertyWrapper<?>> stateValuePairs){
        setBlockStates(level, pos, 3, stateValuePairs);
    }

    /**
     * Updates the provided BlockStateProperty for each block in the multiblock
     * */
    static <T extends Comparable<T>> void setBlockState(class_1937 level, class_2338 pos, class_2769<T> property, T value){
        setBlockStates(level, pos, 3, List.of(new PropertyWrapper<>(property, value)));
    }

    /**
     * Updates the provided BlockStateProperties for each block in the multiblock
     * */
    static <T extends Comparable<T>> void setBlockStates(class_1937 level, class_2338 pos, int flags, List<PropertyWrapper<?>> properties){

        getFullShape(level, pos).forEach(pos1 -> {
            class_2680 state = level.method_8320(pos1);

            for (PropertyWrapper<?> propertyWrapper : properties) {
                state = propertyWrapper.applyTo(state);
            }

            level.method_8652(pos1, state, flags);
        });
    }

    default void syncBlockStates(class_1937 level, class_2338 pos, class_2680 state){
        List<PropertyWrapper<?>> list = new ArrayList<>(getSyncedStateProperties());

        class_2338 centerPos = getCenter(level, pos);
        class_2680 centerState = level.method_8320(centerPos);
        boolean isCenter = isCenter(state);

        for (PropertyWrapper<?> propertyWrapper : list) {
            propertyWrapper.captureValue(state);

            if (!isCenter) {
                centerState = propertyWrapper.applyTo(centerState);
            }
        }


        if (!isCenter){
            level.method_8652(centerPos, centerState, 2);
            return;
        }


        setBlockStates(level, pos, list);
    }

    private IMultiBlock getMultiBlock(){
        if (this instanceof IMultiBlock block){
            return block;
        } else {
            throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on an IMultiBlock");
        }
    }
}
