package net.nikdo53.tinymultiblocklib.block;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.BlockLike;

import java.util.ArrayList;
import java.util.List;

public interface IMovableMultiblock extends IExpandingMultiblock {

    default void moveMultiblock(class_1937 level, class_2338 pos, class_2680 state, class_2350 direction){
        class_2338 center = IMultiBlock.getCenter(level, pos);
        class_2338 centerMoved = center.method_10093(direction);

        List<class_2338> fullBlockShape = getFullBlockShape(center, state, level);
        fullBlockShape.forEach(pos1 -> IMultiBlockEntity.setPlaced(level, pos1, false));

        List<BlockLike> originalBlocks = gatherStates(level, center, state);

        fullBlockShape.forEach(pos1 -> level.method_8652(pos1, class_2246.field_10124.method_9564(), 66));

        originalBlocks.forEach(blockLike -> {
            class_2338 posMoved = blockLike.pos.method_10093(direction);
            class_2586 blockEntity = blockLike.blockEntity;


            level.method_8652(posMoved, blockLike.state, 66);

            if (blockEntity instanceof IMultiBlockEntity multiBlockEntity)
                multiBlockEntity.setCenter(centerMoved);

           if (blockEntity != null) level.method_8438(blockLike.blockEntity);
        });


        getFullBlockShape(centerMoved, state, level).forEach(pos1 -> IMultiBlockEntity.setPlaced(level, pos1, true));
    }

    default List<BlockLike> gatherStates(class_1937 level, class_2338 center, class_2680 state){
        List<BlockLike> list = new ArrayList<>();

        getFullBlockShape(center, state, level).forEach(pos -> list.add(new BlockLike(pos, level.method_8320(pos), level.method_8321(pos))));

        return list;
    }

}
