/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.nikdo53.tinymultiblocklib.Constants;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMBStateSyncer;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock
extends IMBStateSyncer {
    public List<class_2338> makeFullBlockShape(@Nullable class_2350 var1, class_2338 var2, class_2680 var3);

    public static List<class_2338> posStreamToList(Stream<class_2338> posStream) {
        return new ArrayList<class_2338>(posStream.map(class_2338::method_10062).toList());
    }

    @Nullable
    default public class_2753 getDirectionProperty() {
        return null;
    }

    @Nullable
    default public class_2350 getDirection(class_2680 state) {
        if (this.getDirectionProperty() != null) {
            return (class_2350)state.method_11654((class_2769)this.getDirectionProperty());
        }
        return null;
    }

    default public List<class_2338> getFullBlockShapeNoCache(class_2338 center, class_2680 state) {
        List<class_2338> list = this.getDirectionProperty() == null ? this.makeFullBlockShape(null, center, state) : this.makeFullBlockShape((class_2350)state.method_11654((class_2769)this.getDirectionProperty()), center, state);
        HashSet<class_2338> set = new HashSet<class_2338>(list);
        if (set.size() < list.size()) {
            Constants.LOGGER.error("Multiblock {} at {} has overlapping blocks in it's shape, this is likely caused by the BlockPos being mutable. Either map them to BlockPos::immutable or use IMultiBlock.posStreamToList()", (Object)state.toString(), (Object)center);
        }
        return list;
    }

    default public List<class_2338> getFullBlockShape(class_2338 pos, class_2680 state, class_1922 level) {
        class_2338 center = IMultiBlock.getCenter(level, pos);
        class_2586 class_25862 = level.method_8321(center);
        if (!(class_25862 instanceof IMultiBlockEntity)) {
            return this.getFullBlockShapeNoCache(center, state);
        }
        IMultiBlockEntity blockEntity = (IMultiBlockEntity)class_25862;
        if (blockEntity.getFullBlockShapeCache().isEmpty()) {
            List<class_2338> blockPosList = this.getFullBlockShapeNoCache(center, state);
            blockPosList.forEach(class_2338::method_10062);
            blockEntity.setFullBlockShapeCache(blockPosList);
            return blockPosList;
        }
        return blockEntity.getFullBlockShapeCache();
    }

    public static List<class_2338> getFullShape(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)class_22482;
            return multiBlock.getFullBlockShape(pos, state, (class_1922)level);
        }
        return List.of(pos);
    }

    public static void invalidateCaches(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(IMultiBlock.getCenter(level, pos));
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity blockEntity = (IMultiBlockEntity)class_25862;
            blockEntity.invalidateCaches();
        }
    }

    default public class_2680 getStateFromOffset(class_2680 state, class_2338 offset) {
        return state;
    }

    default public void onPlaceHelper(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState) {
        boolean isPlaced = IMultiBlockEntity.isPlaced((class_4538)level, pos);
        if (isPlaced) {
            this.syncBlockStates(level, pos, state);
        }
        if (IMultiBlock.isCenter(state) && !isPlaced) {
            this.place(level, pos, state);
        }
    }

    default public void place(class_1937 level, class_2338 centerPos, class_2680 stateOriginal) {
        this.prepareForPlace(level, centerPos, stateOriginal).forEach(pair -> {
            IMultiBlockEntity entity;
            class_2586 patt5551$temp;
            int flags = 66;
            class_2680 stateNew = (class_2680)pair.getSecond();
            class_2338 posNew = (class_2338)pair.getFirst();
            if (!level.method_8320(posNew).equals(stateNew)) {
                level.method_8652(posNew, stateNew, flags);
            }
            if ((patt5551$temp = level.method_8321(posNew)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)patt5551$temp).getCenter().equals((Object)centerPos)) {
                entity.setCenter(centerPos);
                entity.getBlockEntity().method_5431();
            }
        });
    }

    default public List<Pair<class_2338, class_2680>> prepareForPlace(class_1937 level, class_2338 centerPos, class_2680 stateOriginal) {
        ArrayList<Pair<class_2338, class_2680>> list = new ArrayList<Pair<class_2338, class_2680>>();
        this.getFullBlockShape(centerPos, stateOriginal, (class_1922)level).forEach(posNew -> {
            posNew = posNew.method_10062();
            class_2680 stateNew = (class_2680)stateOriginal.method_11657((class_2769)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(centerPos.equals(posNew)));
            stateNew = this.getStateFromOffset(stateNew, posNew.method_10059((class_2382)centerPos));
            list.add(new Pair(posNew, (Object)stateNew));
        });
        return list;
    }

    default public class_2680 getStateForPlacementHelper(class_1750 context) {
        return this.getStateForPlacementHelper(context, context.method_8042());
    }

    default public class_2680 getStateForPlacementHelper(class_1750 context, class_2350 direction) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = (class_2680)this.self().method_9564().method_11657((class_2769)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (class_2680)state.method_11657((class_2769)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((class_4538)level, pos, state, (class_1297)context.method_8036(), false) ? state : null;
    }

    default public boolean canPlace(class_4538 level, class_2338 center, class_2680 state, @Nullable class_1297 player, boolean ignoreEntities) {
        return this.getFullBlockShape(center, state, (class_1922)level).stream().allMatch(blockPos -> level.method_8320(blockPos).method_45474() && this.extraSurviveRequirements(level, (class_2338)blockPos, state) && (this.entityUnobstructed((class_1941)level, (class_2338)blockPos, state, player) || ignoreEntities));
    }

    default public boolean entityUnobstructed(class_1941 level, class_2338 pos, class_2680 state, @Nullable class_1297 player) {
        class_3726 context = player == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)player);
        return this.getFullBlockShape(pos, state, (class_1922)level).stream().allMatch(blockPos -> level.method_8628(state, blockPos, context));
    }

    default public void destroy(class_2338 center, class_1937 level, class_2680 state, boolean dropBlock) {
        if (level.method_8608()) {
            return;
        }
        List<class_2338> blocks = this.getFullBlockShape(center, state, (class_1922)level);
        level.method_22352(center, false);
        blocks.forEach(pos -> {
            class_2248 block;
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_27852(block = state.method_26204())) {
                level.method_22352(pos, dropBlock);
            }
        });
    }

    default public boolean allBlocksPresent(class_4538 level, class_2338 pos, class_2680 state) {
        IMultiBlockEntity entity;
        class_2586 class_25862;
        if (level.method_8608()) {
            return true;
        }
        class_2338 center = IMultiBlock.getCenter((class_1922)level, pos);
        boolean ret = this.getFullBlockShape(center, state, (class_1922)level).stream().allMatch(blockPos -> level.method_8320(blockPos).method_27852(this.self()));
        boolean isMultiblock = IMultiBlock.isMultiblock((class_1922)level, pos);
        if (ret && (class_25862 = level.method_8321(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)class_25862).isPlaced() && isMultiblock) {
            this.getFullBlockShape(center, state, (class_1922)level).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos, true));
        }
        return ret;
    }

    default public class_2680 updateShapeHelper(class_2680 state, class_1936 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            class_2338 centerPos = IMultiBlock.getCenter((class_1922)level, pos);
            boolean canSurvive = state.method_26184((class_4538)level, centerPos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (class_1937)level, state, true);
                return class_2246.field_10124.method_9564();
            }
        } else {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    default public boolean canSurviveHelper(class_2680 state, class_4538 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            boolean extraSurvive = this.getFullBlockShape(pos, state, (class_1922)level).stream().allMatch(blockPos -> this.extraSurviveRequirements(level, (class_2338)blockPos, state));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state, null, false);
    }

    default public boolean extraSurviveRequirements(class_4538 level, class_2338 pos, class_2680 state) {
        return true;
    }

    default public void preventCreativeDrops(class_1657 player, class_1937 level, class_2338 pos) {
        if (player.method_7337() && level.method_8321(pos) instanceof IMultiBlockEntity) {
            class_2338 center = IMultiBlock.getCenter((class_1922)level, pos);
            this.destroy(center, level, level.method_8320(pos), false);
        }
    }

    default public void fixInStructures(class_2680 state, class_5425 level, class_2338 pos) {
        if (IMultiBlock.isCenter(state)) {
            level.method_39279(pos, state.method_26204(), 3);
        }
    }

    default public void fixTick(class_2680 state, class_1937 level, class_2338 pos) {
        if (IMultiBlock.isCenter(state)) {
            this.getFullBlockShape(pos, state, (class_1922)level).forEach(posNew -> {
                class_2586 patt11992$temp = level.method_8321(posNew);
                if (patt11992$temp instanceof IMultiBlockEntity) {
                    IMultiBlockEntity entity = (IMultiBlockEntity)patt11992$temp;
                    entity.setCenter(pos);
                    entity.getBlockEntity().method_5431();
                    level.method_8413(posNew, state, state, 2);
                }
            });
        }
    }

    default public boolean isBroken(class_4538 level, class_2338 pos, class_2680 state) {
        if (!IMultiBlock.isCenter(state)) {
            return false;
        }
        return this.getFullBlockShape(pos, state, (class_1922)level).stream().anyMatch(blockPos -> {
            class_2586 patt12623$temp = level.method_8321(blockPos);
            if (patt12623$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt12623$temp;
                return !entity.getCenter().equals((Object)pos) || IMultiBlock.isCenter(level.method_8320(blockPos));
            }
            return true;
        });
    }

    public static class_2338 getCenter(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return entity.getCenter();
        }
        return pos;
    }

    public static boolean isCenter(class_4538 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return entity.getCenter().equals((Object)pos);
        }
        return false;
    }

    public static boolean isCenter(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)AbstractMultiBlock.CENTER);
    }

    public static boolean isMultiblock(class_2680 state) {
        return state.method_26204() instanceof IMultiBlock;
    }

    public static boolean isMultiblock(class_1922 level, class_2338 pos) {
        return IMultiBlock.isMultiblock(level.method_8320(pos));
    }

    public static int getXOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10263() - entity.getCenter().method_10263();
        }
        return 0;
    }

    public static int getYOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10264() - entity.getCenter().method_10264();
        }
        return 0;
    }

    public static int getZOffset(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            return pos.method_10260() - entity.getCenter().method_10260();
        }
        return 0;
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public class_265 voxelShapeHelper(class_2680 state, class_1922 level, class_2338 pos, class_265 shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)class_25862;
            float x = (float)(entity.getCenter().method_10263() - pos.method_10263()) + xOffset;
            float y = (float)(entity.getCenter().method_10264() - pos.method_10264()) + yOffset;
            float z = (float)(entity.getCenter().method_10260() - pos.method_10260()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((class_2350)state.method_11654((class_2769)this.getDirectionProperty())) {
                    case field_11034: {
                        x += 1.0f;
                        break;
                    }
                    case field_11043: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case field_11039: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.method_1096((double)x, (double)y, (double)z);
        }
        return shape;
    }

    @Deprecated
    default public void growHelper(class_1937 level, class_2338 blockPos, class_2758 ageProperty) {
        class_2248 block = this.self();
        this.getFullBlockShape(blockPos, level.method_8320(blockPos), (class_1922)level).forEach(pos -> {
            if (level.method_8320(pos).method_27852(block)) {
                class_2680 blockState = level.method_8320(pos);
                int age = (Integer)blockState.method_11654((class_2769)ageProperty);
                if ((Integer)blockState.method_11654((class_2769)ageProperty) >= this.getMaxAge(ageProperty)) {
                    return;
                }
                level.method_8652(pos, (class_2680)blockState.method_11657((class_2769)ageProperty, (Comparable)Integer.valueOf(age + 1)), 2);
            } else {
                level.method_22352(pos, false);
            }
        });
    }

    default public int getMaxAge(class_2758 ageProperty) {
        return (Integer)ageProperty.method_11898().stream().toList().get(ageProperty.method_11898().size() - 1);
    }

    public static boolean isSameMultiblock(class_1937 level, class_2680 state1, class_2680 state2, class_2338 center, class_2338 posNew) {
        IMultiBlockEntity entity;
        class_2586 class_25862;
        return state1.method_26204().equals(state2.method_26204()) && (class_25862 = level.method_8321(posNew)) instanceof IMultiBlockEntity && (entity = (IMultiBlockEntity)class_25862).getCenter().equals((Object)center);
    }

    private class_2248 self() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof class_2248) {
            class_2248 block = (class_2248)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }
}

