/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.block;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.Constants;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface IMultiBlock {
    public Stream<BlockPos> fullBlockShape(@Nullable Direction var1, BlockPos var2);

    @Nullable
    default public DirectionProperty getDirectionProperty() {
        return null;
    }

    @Nullable
    default public Direction getDirection(BlockState state) {
        if (this.getDirectionProperty() != null) {
            return (Direction)state.m_61143_((Property)this.getDirectionProperty());
        }
        return null;
    }

    default public Block getBlock() {
        IMultiBlock iMultiBlock = this;
        if (iMultiBlock instanceof Block) {
            Block block = (Block)iMultiBlock;
            return block;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + " is not implemented on a Block");
    }

    default public Stream<BlockPos> fullBlockShape(BlockPos center, @Nullable BlockState state) {
        if (this.getDirectionProperty() == null || state == null) {
            return this.fullBlockShape(null, center);
        }
        return this.fullBlockShape((Direction)state.m_61143_((Property)this.getDirectionProperty()), center);
    }

    public static Stream<BlockPos> getFullShape(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity multiBlockEntity = (IMultiBlockEntity)blockEntity;
            blockEntity = level.m_8055_(pos).m_60734_();
            if (blockEntity instanceof IMultiBlock) {
                IMultiBlock multiBlock = (IMultiBlock)blockEntity;
                return multiBlock.fullBlockShape(multiBlockEntity.getCenter(), level.m_8055_(pos));
            }
        }
        return Stream.of(pos);
    }

    @Nullable
    default public BiFunction<BlockState, BlockPos, BlockState> getStateFromOffset() {
        return null;
    }

    default public void place(Level level, BlockPos posOriginal, BlockState stateOriginal) {
        this.fullBlockShape(posOriginal, stateOriginal).forEach(posNew -> {
            int flags = level.f_46443_ ? 0 : 3;
            BlockState stateNew = (BlockState)stateOriginal.m_61124_((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(posOriginal.equals(posNew)));
            if (this.getStateFromOffset() != null) {
                stateNew = this.getStateFromOffset().apply(stateNew, posNew.m_121996_((Vec3i)posOriginal));
            }
            level.m_7731_(posNew, stateNew, flags);
            BlockEntity patt3730$temp = level.m_7702_(posNew);
            if (patt3730$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt3730$temp;
                entity.setCenter(posOriginal);
                entity.getBlockEntity().m_6596_();
            }
        });
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context, context.m_8125_());
    }

    default public BlockState getStateForPlacementHelper(BlockPlaceContext context, Direction direction) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.getBlock().m_49966_().m_61124_((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(true));
        if (this.getDirectionProperty() != null) {
            state = (BlockState)state.m_61124_((Property)this.getDirectionProperty(), (Comparable)direction);
        }
        return this.canPlace((LevelReader)level, pos, state) ? state : null;
    }

    default public boolean canPlace(LevelReader level, BlockPos center, BlockState state) {
        return this.fullBlockShape(center, state).allMatch(blockPos -> level.m_8055_(blockPos).m_247087_() && this.extraSurviveRequirements(level, (BlockPos)blockPos, state));
    }

    default public void destroy(BlockPos center, Level level, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        this.fullBlockShape(center, state).forEach(pos -> {
            Block block;
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60713_(block = state.m_60734_())) {
                level.m_46961_(pos, true);
            }
        });
    }

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return true;
        }
        BlockPos center = this.getCenter((BlockGetter)level, pos);
        boolean ret = this.fullBlockShape(center, state).allMatch(blockPos -> level.m_8055_(blockPos).m_60713_(this.getBlock()));
        if (ret && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced()) {
            this.fullBlockShape(center, state).forEach(blockPos -> IMultiBlockEntity.setPlaced(level, blockPos));
        }
        return ret;
    }

    default public BlockState updateShapeHelper(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean canSurvive = state.m_60710_((LevelReader)level, pos);
            if (!canSurvive) {
                this.destroy(entity.getCenter(), (Level)level, state);
                return Blocks.f_50016_.m_49966_();
            }
        } else {
            level.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    default public boolean canSurviveHelper(BlockState state, LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            boolean extraSurvive = this.fullBlockShape(entity.getCenter(), state).allMatch(blockPos -> this.extraSurviveRequirements(level, (BlockPos)blockPos, state));
            return (this.allBlocksPresent(level, pos, state) || !entity.isPlaced()) && extraSurvive;
        }
        return this.canPlace(level, pos, state);
    }

    default public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    default public void preventCreativeDrops(Player player, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            level.m_46961_(entity.getCenter(), false);
        }
    }

    default public void fixInStructures(BlockState state, ServerLevelAccessor level, BlockPos pos) {
        if (this.isCenter(state)) {
            level.m_186460_(pos, state.m_60734_(), 3);
        }
    }

    default public void fixTick(BlockState state, Level level, BlockPos pos) {
        if (this.isCenter(state)) {
            this.fullBlockShape(pos, state).forEach(posNew -> {
                BlockEntity patt8804$temp = level.m_7702_(posNew);
                if (patt8804$temp instanceof IMultiBlockEntity) {
                    IMultiBlockEntity entity = (IMultiBlockEntity)patt8804$temp;
                    entity.setCenter(pos);
                    entity.getBlockEntity().m_6596_();
                    level.m_7260_(posNew, state, state, 2);
                }
            });
        }
    }

    default public boolean isBroken(LevelReader level, BlockPos pos, BlockState state) {
        if (!this.isCenter(state)) {
            return false;
        }
        return this.fullBlockShape(pos, state).anyMatch(blockPos -> {
            BlockEntity patt9433$temp = level.m_7702_(blockPos);
            if (patt9433$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt9433$temp;
                return !entity.getCenter().equals((Object)pos) || this.isCenter(level.m_8055_(blockPos));
            }
            return true;
        });
    }

    default public BlockPos getCenter(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter();
        }
        Constants.LOG.error("Couldn't get center for multi block");
        return pos;
    }

    default public boolean isCenter(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return entity.getCenter().equals((Object)pos);
        }
        return false;
    }

    default public boolean isCenter(BlockState state) {
        return (Boolean)state.m_61143_((Property)AbstractMultiBlock.CENTER);
    }

    default public int getXOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.m_123341_() - entity.getCenter().m_123341_();
        }
        return 0;
    }

    default public int getYOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.m_123342_() - entity.getCenter().m_123342_();
        }
        return 0;
    }

    default public int getZOffset(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            return pos.m_123343_() - entity.getCenter().m_123343_();
        }
        return 0;
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape) {
        return this.voxelShapeHelper(state, level, pos, shape, 0.0f, 0.0f, 0.0f);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset) {
        return this.voxelShapeHelper(state, level, pos, shape, xOffset, yOffset, zOffset, false);
    }

    default public VoxelShape voxelShapeHelper(BlockState state, BlockGetter level, BlockPos pos, VoxelShape shape, float xOffset, float yOffset, float zOffset, boolean hasDirectionOffsets) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            float x = (float)(entity.getCenter().m_123341_() - pos.m_123341_()) + xOffset;
            float y = (float)(entity.getCenter().m_123342_() - pos.m_123342_()) + yOffset;
            float z = (float)(entity.getCenter().m_123343_() - pos.m_123343_()) + zOffset;
            if (this.getDirectionProperty() != null && hasDirectionOffsets) {
                switch ((Direction)state.m_61143_((Property)this.getDirectionProperty())) {
                    case EAST: {
                        x += 1.0f;
                        break;
                    }
                    case NORTH: {
                        x += 1.0f;
                        z -= 1.0f;
                        break;
                    }
                    case WEST: {
                        z -= 1.0f;
                    }
                }
            }
            return shape.m_83216_((double)x, (double)y, (double)z);
        }
        return shape;
    }

    default public void growHelper(Level level, BlockPos blockPos, IntegerProperty ageProperty) {
        Block block = this.getBlock();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            this.fullBlockShape(entity.getCenter(), level.m_8055_(blockPos)).forEach(pos -> {
                if (level.m_8055_(pos).m_60713_(block)) {
                    BlockState blockState = level.m_8055_(pos);
                    int age = (Integer)blockState.m_61143_((Property)ageProperty);
                    if ((Integer)blockState.m_61143_((Property)ageProperty) >= this.getMaxAge(ageProperty)) {
                        return;
                    }
                    level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age + 1)), 2);
                } else {
                    level.m_46961_(pos, false);
                }
            });
        } else {
            level.m_46961_(blockPos, true);
        }
    }

    default public int getMaxAge(IntegerProperty ageProperty) {
        return (Integer)ageProperty.m_6908_().stream().toList().get(ageProperty.m_6908_().size() - 1);
    }
}

