/*
 * Decompiled with CFR 0.152.
 */
package net.nikdo53.tinymultiblocklib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.client.VertexConsumerWrapper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import net.nikdo53.tinymultiblocklib.mixin.ItemAccessor;

public class MultiblockPreviewRenderer {
    public static void renderMultiblockPreviews(float partialTick, Minecraft minecraft, Level level, Camera camera, PoseStack poseStack) {
        BlockItem blockItem;
        LocalPlayer player = minecraft.f_91074_;
        assert (player != null);
        Item item = player.m_21205_().m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof IPreviewableMultiblock) {
            IPreviewableMultiblock multiBlock = (IPreviewableMultiblock)item;
            item = blockItem.m_40614_();
            if (item instanceof EntityBlock) {
                EntityBlock block = (EntityBlock)item;
                HitResult hitResult = minecraft.f_91077_;
                if (hitResult instanceof BlockHitResult) {
                    boolean shouldShowPreview;
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    boolean placeOnWater = false;
                    if (blockItem instanceof PlaceOnWaterBlockItem) {
                        blockHitResult = ItemAccessor.getPlayerPOVHitResult(level, (Player)player, ClipContext.Fluid.SOURCE_ONLY);
                        placeOnWater = level.m_46801_(blockHitResult.m_82425_());
                    }
                    Direction hitDirection = blockHitResult.m_82434_();
                    BlockPos hitPos = blockHitResult.m_82425_();
                    BlockPos pos = hitPos.m_121945_(hitDirection);
                    BlockState state = multiBlock.getDefaultStateForPreviews(player.m_6350_());
                    BlockEntity entity = block.m_142194_(pos, state);
                    boolean bl = shouldShowPreview = level.m_8055_(pos).m_247087_() && (!level.m_8055_(hitPos).m_60795_() || placeOnWater);
                    if (entity instanceof IMultiBlockEntity) {
                        IMultiBlockEntity multiBlockEntity = (IMultiBlockEntity)entity;
                        if (shouldShowPreview) {
                            entity.m_142339_(level);
                            PreviewMode previewMode = multiBlock.canPlace((LevelReader)level, pos, state) ? PreviewMode.PREVIEW : PreviewMode.INVALID;
                            multiBlockEntity.setPreviewMode(previewMode);
                            if (level.m_8055_(hitPos).m_247087_() && !placeOnWater) {
                                pos = pos.m_121945_(hitDirection.m_122424_());
                            }
                            poseStack.m_85836_();
                            double camX = camera.m_90583_().f_82479_;
                            double camY = camera.m_90583_().f_82480_;
                            double camZ = camera.m_90583_().f_82481_;
                            poseStack.m_85837_((double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ);
                            MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
                            BlockEntityRenderer entityRender = minecraft.m_167982_().m_112265_(entity);
                            if (entityRender != null) {
                                entityRender.m_6922_(entity, partialTick, poseStack, (MultiBufferSource)buffer, 0xFFFFFF, OverlayTexture.f_118083_);
                            }
                            if (!multiBlock.skipJsonRendering()) {
                                MultiblockPreviewRenderer.renderJsonModels(minecraft, level, poseStack, multiBlock, pos, state, buffer, previewMode);
                            }
                            poseStack.m_85849_();
                        }
                    }
                }
            }
        }
    }

    private static void renderJsonModels(Minecraft minecraft, Level level, PoseStack poseStack, IPreviewableMultiblock multiBlock, BlockPos originalPos, BlockState stateOriginal, MultiBufferSource.BufferSource buffer, final PreviewMode previewMode) {
        BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
        poseStack.m_85837_(1.0E-4, 1.0E-4, 1.0E-4);
        multiBlock.getPreviewStates(originalPos, stateOriginal).forEach(pair -> {
            BlockState state = (BlockState)pair.getB();
            BlockPos pos = ((BlockPos)pair.getA()).m_7949_();
            if (!state.m_60799_().equals((Object)RenderShape.MODEL)) {
                return;
            }
            BlockPos offset = pos.m_121996_((Vec3i)originalPos).m_7949_();
            poseStack.m_252880_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_());
            VertexConsumerWrapper tintedConsumer = new VertexConsumerWrapper(buffer.m_6299_(RenderType.m_110466_())){

                public void m_85995_(PoseStack.Pose pose, BakedQuad quad, float[] colorMuls, float red, float green, float blue, int[] combinedLights, int combinedOverlay, boolean mulColor) {
                    super.m_85995_(pose, quad, colorMuls, red, green, blue, combinedLights, combinedOverlay, mulColor);
                }

                public VertexConsumer m_85950_(float red, float green, float blue, float alpha) {
                    return super.m_85950_(red * previewMode.red, green * previewMode.green, blue * previewMode.blue, alpha * previewMode.alpha);
                }
            };
            blockRenderer.m_234355_(state, pos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)tintedConsumer, false, minecraft.f_91073_.m_213780_());
            buffer.m_173043_();
            poseStack.m_252880_((float)(-offset.m_123341_()), (float)(-offset.m_123342_()), (float)(-offset.m_123343_()));
        });
    }
}

