/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hex_ars_link.env.hex;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CallbackStorage
extends SavedData {
    static final String SAVENAME = "hex_ars_link.callbacks";
    static final String NBT_K = "keys";
    static final String NBT_V = "values";
    static final String NBT_N = "n";
    private final Map<UUID, Tag> pool = new HashMap<UUID, Tag>();

    public static CallbackStorage getInstance(ServerLevel level) {
        level = level.m_7654_().m_129783_();
        DimensionDataStorage ds = level.m_8895_();
        return (CallbackStorage)ds.m_164861_(CallbackStorage::new, CallbackStorage::new, SAVENAME);
    }

    public static void Put(ServerPlayer player, SpellList callback) {
        CallbackStorage.getInstance(player.m_284548_()).put(player, callback);
    }

    public static List<Iota> Get(ServerPlayer player) {
        return CallbackStorage.getInstance(player.m_284548_()).get(player);
    }

    public void put(ServerPlayer player, SpellList callback) {
        UUID uuid = player.m_20148_();
        ListIota boxed = new ListIota(callback);
        this.pool.put(uuid, boxed.serialize());
        this.m_77762_();
    }

    public List<Iota> get(ServerPlayer player) {
        Tag raw = this.pool.get(player.m_20148_());
        if (raw == null) {
            return List.of();
        }
        ArrayList<Iota> ret = new ArrayList<Iota>();
        ListIota boxed = (ListIota)ListIota.TYPE.deserialize(raw, player.m_284548_());
        boxed.getList().forEach(ret::add);
        return ret;
    }

    public CallbackStorage() {
    }

    public CallbackStorage(CompoundTag toLoad) {
        this();
        try {
            int n = toLoad.m_128451_(NBT_N);
            if (n <= 0) {
                return;
            }
            ListTag keys = toLoad.m_128437_(NBT_K, 11);
            ListTag values = toLoad.m_128437_(NBT_V, 9);
            for (int i = 0; i < n; ++i) {
                UUID uuid = NbtUtils.m_129233_((Tag)keys.get(i));
                Tag list = values.get(i);
                this.pool.put(uuid, list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CompoundTag m_7176_(CompoundTag toDump) {
        toDump.m_128405_(NBT_N, this.pool.size());
        ListTag keys = new ListTag();
        ListTag values = new ListTag();
        for (Map.Entry<UUID, Tag> pair : this.pool.entrySet()) {
            keys.add((Object)NbtUtils.m_129226_((UUID)pair.getKey()));
            values.add((Object)pair.getValue());
        }
        toDump.m_128365_(NBT_K, (Tag)keys);
        toDump.m_128365_(NBT_V, (Tag)values);
        return toDump;
    }
}

