/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hex_ars_link.glyph;

import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import io.yukkuric.hex_ars_link.env.hex.CallbackStorage;
import io.yukkuric.hex_ars_link.env.hex.GlyphCallbackCastEnv;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HexCallbackSpellPart
extends AbstractEffect {
    public static final ResourceLocation ID = new ResourceLocation("hex_ars_link", "hex_callback");
    public static final String DESCRIP = "HexCallback";
    public static final HexCallbackSpellPart INSTANCE = new HexCallbackSpellPart();

    private HexCallbackSpellPart() {
        super(ID, DESCRIP);
    }

    public String getName() {
        return this.getLocaleName();
    }

    protected int getDefaultManaCost() {
        return 15;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return Set.of();
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(shooter instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)shooter;
        Entity target = rayTraceResult.m_82443_();
        this.onCastWithInitStack(resolver, (Iota)new EntityIota(target), player, target.m_20182_());
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(shooter instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)shooter;
        Vec3 pos = rayTraceResult.m_82425_().m_252807_();
        this.onCastWithInitStack(resolver, (Iota)new Vec3Iota(pos), player, pos);
    }

    public void onCastWithInitStack(SpellResolver resolver, Iota init, ServerPlayer player, Vec3 pos) {
        List<Iota> spell = CallbackStorage.Get(player);
        if (spell == null) {
            return;
        }
        GlyphCallbackCastEnv env = new GlyphCallbackCastEnv(player, pos, resolver);
        CastingVM vm = env.getVM(init);
        vm.queueExecuteAndWrapIotas(spell, env.getWorld());
    }
}

