/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hex_ars_link.items;

import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import io.yukkuric.hex_ars_link.items.OwnerBinder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemLinker
extends ItemMediaHolder
implements OwnerBinder {
    double _convertRatio = -1.0;
    Supplier<Double> _convertRatioGetter;

    public ItemLinker(Supplier<Double> convertRatioGetter, Item.Properties pProperties) {
        super(pProperties);
        this._convertRatioGetter = convertRatioGetter;
    }

    public double getConvertRatio() {
        if (this._convertRatio < 0.0) {
            this._convertRatio = this._convertRatioGetter.get();
        }
        return this._convertRatio;
    }

    public boolean canProvideMedia(ItemStack itemStack) {
        return true;
    }

    public boolean canRecharge(ItemStack itemStack) {
        return false;
    }

    long getMediaRaw(Player player) {
        if (player == null) {
            return 0L;
        }
        return (long)(ManaUtil.getCurrentMana((LivingEntity)player) * this.getConvertRatio());
    }

    long getMaxMediaRaw(Player player) {
        if (player == null) {
            return 0L;
        }
        return (long)((double)ManaUtil.getMaxMana((Player)player) * this.getConvertRatio());
    }

    public void setMedia(ItemStack stack, long i) {
        Player player = this.getOwner(stack);
        CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> mana.setMana((double)i / this.getConvertRatio()));
        super.setMedia(stack, i);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return OwnerBinder.super.m_7203_(world, player, hand);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_) {
            return;
        }
        Player owner = this.getOwner(stack);
        long rawMedia = this.getMediaRaw(owner);
        long rawCap = this.getMaxMediaRaw(owner);
        if (rawMedia != super.getMedia(stack)) {
            super.setMedia(stack, rawMedia);
        }
        if (rawCap != super.getMaxMedia(stack)) {
            NBTHelper.putLong((ItemStack)stack, (String)"hexcasting:start_media", (long)rawCap);
        }
        if (owner != null) {
            NBTHelper.putString((ItemStack)stack, (String)"name", (String)owner.m_7755_().getString());
        } else {
            NBTHelper.remove((ItemStack)stack, (String)"name");
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.hex_ars_link.linker.ratio", (Object[])new Object[]{this.getConvertRatio()}).m_130940_(ChatFormatting.GRAY));
        this.appendOwnerTooltip(pStack, pTooltipComponents);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public int getConsumptionPriority(ItemStack stack) {
        return super.getConsumptionPriority(stack) + 1;
    }
}

