/*
 * Decompiled with CFR 0.152.
 */
package studio.robotmonkey.sha1runtime.Commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import studio.robotmonkey.sha1runtime.SHA1Runtime;
import studio.robotmonkey.sha1runtime.Util.Util;

public class Commands {
    public static void RegisterAllCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        if (env.field_25423) {
            CheckHash.register(dispatcher);
            UpdateHash.register(dispatcher);
            Reload.register(dispatcher);
            FetchHash.register(dispatcher);
            FetchHashReload.register(dispatcher);
            UpdateURL.register(dispatcher);
        }
    }

    public static class CheckHash {
        private static final String command = "checkhash";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)command).executes(CheckHash::execute));
        }

        public static int execute(CommandContext<class_2168> context) {
            if (((class_2168)context.getSource()).method_9211().method_43659().isPresent()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Hash in server.properties: " + ((MinecraftServer.class_7460)((class_2168)context.getSource()).method_9211().method_43659().get()).comp_785())));
                File hashFile = new File("config/ResourcePackHash.txt");
                try {
                    Scanner fileReader = new Scanner(hashFile);
                    if (fileReader.hasNextLine()) {
                        String hash = fileReader.nextLine();
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Hash in config file: " + hash)));
                    } else {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No Hash in config file: Please open config folder and add your hash."));
                    }
                    fileReader.close();
                }
                catch (FileNotFoundException e) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Config file is missing. Generating a new one now...."));
                    SHA1Runtime.LOGGER.warn("Missing Hash File! Generating Now...");
                    try {
                        boolean created = hashFile.createNewFile();
                        if (created) {
                            FileWriter writer = new FileWriter(hashFile);
                            writer.write(((MinecraftServer.class_7460)((class_2168)context.getSource()).method_9211().method_43659().get()).comp_785());
                            writer.close();
                            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Config file generated. Update with your new hash when needed or use /fetchhash to automatically set it."));
                        } else {
                            SHA1Runtime.LOGGER.error("Could not create config file!");
                        }
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No Hash Present in server.properties make sure you assign one even if it is outdated."));
            }
            return 1;
        }
    }

    public static class UpdateHash {
        private static final String command = "updatehash";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"hash", (ArgumentType)StringArgumentType.greedyString()).executes(UpdateHash::execute)));
        }

        public static int execute(CommandContext<class_2168> context) {
            if (((class_2168)context.getSource()).method_9211().method_3816()) {
                String hash = StringArgumentType.getString(context, (String)"hash");
                File config = Util.GetOrCreateConfig();
                try {
                    FileWriter writer = new FileWriter(config);
                    writer.write(hash);
                    writer.close();
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Updated config to: " + hash)));
                    SHA1Runtime.LOGGER.info("Updated config with new hash: " + hash);
                }
                catch (IOException e) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Failed to update hash!"));
                    SHA1Runtime.LOGGER.error("Failed to write new hash!");
                }
            }
            return 1;
        }
    }

    public static class Reload {
        private static final String command = "reload";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(source -> source.method_9259(4))).executes(Reload::execute));
        }

        public static int execute(CommandContext<class_2168> context) {
            Optional props;
            if (((class_2168)context.getSource()).method_9211().method_3816() && (props = ((class_2168)context.getSource()).method_9211().method_43659()).isPresent()) {
                String url = ((MinecraftServer.class_7460)props.get()).comp_784();
                if (Util.IsOverrideSet()) {
                    url = Util.GetURLFromConfig();
                }
                class_2561 prompt = class_2561.method_30163((String)"Reloading resource pack!");
                for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                    player.field_13987.method_14364((class_2596)new class_2720(((MinecraftServer.class_7460)props.get()).comp_2156(), url, ((MinecraftServer.class_7460)props.get()).comp_785(), true, Optional.of(prompt)));
                }
            }
            return 1;
        }
    }

    public static class FetchHash {
        private static final String command = "fetchhash";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(source -> source.method_9259(4))).executes(FetchHash::execute));
        }

        public static int run(CommandContext<class_2168> context, boolean reload) {
            Thread fetchPackThread = new Thread(() -> {
                try {
                    MinecraftServer.class_7460 props = (MinecraftServer.class_7460)((class_2168)context.getSource()).method_9211().method_43659().orElseThrow();
                    String url = props.comp_784();
                    if (Util.IsOverrideSet()) {
                        SHA1Runtime.LOGGER.info("URL Override Set in Config.");
                        url = Util.GetURLFromConfig();
                    }
                    SHA1Runtime.LOGGER.info("Fetching resource pack from: " + url);
                    BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
                    MessageDigest digest = MessageDigest.getInstance("SHA-1");
                    DigestInputStream stream = new DigestInputStream(in, digest);
                    while (stream.read() != -1) {
                    }
                    stream.close();
                    SHA1Runtime.LOGGER.info("Resource pack fetch completed. Calculating new hash!");
                    byte[] hash = digest.digest();
                    StringBuilder hexString = new StringBuilder();
                    for (byte b : hash) {
                        hexString.append(String.format("%02x", b));
                    }
                    File config = Util.GetOrCreateConfig();
                    FileWriter writer = new FileWriter(config);
                    writer.write(hexString.toString().toUpperCase());
                    writer.close();
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Updated config to: " + hexString.toString().toUpperCase())));
                    SHA1Runtime.LOGGER.info("Updated config with new hash: " + hexString.toString().toUpperCase());
                }
                catch (NoSuchElementException e) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No resource pack properties found. Make sure hash and url are set."));
                    SHA1Runtime.LOGGER.error("No resource pack properties found. Make sure hash and url are set.");
                }
                catch (IOException e) {
                    SHA1Runtime.LOGGER.error("IOException: " + String.valueOf(e));
                }
                catch (NoSuchAlgorithmException algo) {
                    SHA1Runtime.LOGGER.error("Wrong algorithm!");
                }
                if (reload) {
                    Reload.execute(context);
                }
            });
            fetchPackThread.start();
            return 1;
        }

        public static int execute(CommandContext<class_2168> context) {
            if (((class_2168)context.getSource()).method_9211().method_3816()) {
                FetchHash.run(context, false);
            }
            return 1;
        }
    }

    public static class FetchHashReload {
        private static final String command = "fetchhash";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(FetchHashReload::execute)));
        }

        public static int execute(CommandContext<class_2168> context) {
            if (((class_2168)context.getSource()).method_9211().method_3816()) {
                FetchHash.run(context, true);
            }
            return 1;
        }
    }

    public static class UpdateURL {
        private static final String command = "setpackurl";

        public static void register(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(UpdateURL::execute)));
        }

        public static int execute(CommandContext<class_2168> context) {
            if (((class_2168)context.getSource()).method_9211().method_3816()) {
                String url = StringArgumentType.getString(context, (String)"url");
                File config = Util.GetOrCreateUrlOverride();
                try {
                    FileWriter writer = new FileWriter(config);
                    writer.write(url);
                    writer.close();
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Updated URL config to: " + url)));
                    SHA1Runtime.LOGGER.info("Updated config with new url: " + url);
                }
                catch (IOException e) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Failed to update URL!"));
                    SHA1Runtime.LOGGER.error("Failed to write new URL!");
                    SHA1Runtime.LOGGER.error(e.toString());
                }
            }
            return 1;
        }
    }
}

