/*
 * Decompiled with CFR 0.152.
 */
package studio.robotmonkey.sha1runtime.mixin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import net.minecraft.class_2720;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import studio.robotmonkey.sha1runtime.SHA1Runtime;
import studio.robotmonkey.sha1runtime.Util.Util;

@Mixin(value={class_2720.class})
public class ResourcePackMixin {
    @Inject(at={@At(value="HEAD")}, method={"hash()Ljava/lang/String;"}, cancellable=true)
    public void getHash(CallbackInfoReturnable ci) {
        File hashFile = new File("config/ResourcePackHash.txt");
        try {
            Scanner fileReader = new Scanner(hashFile);
            if (fileReader.hasNextLine()) {
                String hashInFile = fileReader.nextLine();
                SHA1Runtime.LOGGER.info("Hash Found: " + hashInFile);
                ci.setReturnValue((Object)hashInFile);
            } else {
                SHA1Runtime.LOGGER.warn("No Hash in file: Please open config folder and add your hash.");
            }
            fileReader.close();
        }
        catch (FileNotFoundException e) {
            SHA1Runtime.LOGGER.error("Missing Hash File! Generating Now...");
            try {
                hashFile.createNewFile();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/network/packet/s2c/common/ResourcePackSendS2CPacket;url()Ljava/lang/String;"}, cancellable=true)
    public void getURL(CallbackInfoReturnable ci) {
        if (Util.IsOverrideSet()) {
            SHA1Runtime.LOGGER.info("URL Override is set. Gathering from config!");
            File urlFile = Util.GetOrCreateUrlOverride();
            try {
                Scanner fileReader = new Scanner(urlFile);
                if (fileReader.hasNextLine()) {
                    String urlInFile = fileReader.nextLine();
                    SHA1Runtime.LOGGER.info("Url Found: " + urlInFile);
                    ci.setReturnValue((Object)urlInFile);
                } else {
                    SHA1Runtime.LOGGER.warn("No URL in file: Please open config folder and add your url or run /setpackurl.");
                }
                fileReader.close();
            }
            catch (FileNotFoundException e) {
                SHA1Runtime.LOGGER.error("Missing Url File! Generating Now...");
                try {
                    urlFile.createNewFile();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }
}

