/*
 * Decompiled with CFR 0.152.
 */
package net.polished.laserplace;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;

@Environment(value=EnvType.CLIENT)
public class main
implements ClientModInitializer {
    private class_304 laserToggleKey;
    private class_304 rayCastKey;
    private class_304 cardinalToggleKey;
    private class_304 undoKey;
    private boolean laserEnabled = false;
    private boolean cardinalMode = true;
    private final Deque<List<class_2338>> placementHistory = new ArrayDeque<List<class_2338>>();
    private static final int MAX_UNDO_ACTIONS = 10;
    private static final class_304.class_11900 CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"laserplace", (String)"controls"));

    public void onInitializeClient() {
        this.laserToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.laserplace.toggle", class_3675.class_307.field_1668, 66, CATEGORY));
        this.rayCastKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.laserplace.place", class_3675.class_307.field_1668, 86, CATEGORY));
        this.cardinalToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.laserplace.cardinaltoggle", class_3675.class_307.field_1668, 78, CATEGORY));
        this.undoKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.laserplace.undo", class_3675.class_307.field_1668, 90, CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.laserToggleKey.method_1436()) {
                boolean bl = this.laserEnabled = !this.laserEnabled;
                if (this.laserEnabled) {
                    this.runCommand(client, "/attribute " + client.field_1724.method_5477().getString() + " minecraft:block_interaction_range base set 128");
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aLaserPlace ENABLED"), true);
                    continue;
                }
                this.runCommand(client, "/attribute " + client.field_1724.method_5477().getString() + " minecraft:block_interaction_range base reset");
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cLaserPlace DISABLED"), true);
            }
            while (this.cardinalToggleKey.method_1436()) {
                boolean bl = this.cardinalMode = !this.cardinalMode;
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)(this.cardinalMode ? "\u00a7bCardinal Mode: \u00a7aON" : "\u00a7bCardinal Mode: \u00a7cOFF")), true);
            }
            while (this.rayCastKey.method_1436() && this.laserEnabled) {
                ArrayList<class_2338> placedBlocksInAction = new ArrayList<class_2338>();
                this.fillLineFromRaycast(client, placedBlocksInAction);
                if (placedBlocksInAction.isEmpty()) continue;
                this.placementHistory.addLast(placedBlocksInAction);
                if (this.placementHistory.size() <= 10) continue;
                this.placementHistory.removeFirst();
            }
            while (this.undoKey.method_1436()) {
                this.undoLastAction(client);
            }
        });
    }

    private void undoLastAction(class_310 client) {
        if (this.placementHistory.isEmpty()) {
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eNothing to undo."), true);
            }
            return;
        }
        List<class_2338> lastAction = this.placementHistory.removeLast();
        for (class_2338 pos : lastAction) {
            String command = String.format("/setblock %d %d %d minecraft:air", pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.runCommand(client, command);
        }
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aLast action undone."), true);
        }
    }

    private void runCommand(class_310 client, String command) {
        if (client.field_1724 != null) {
            client.field_1724.field_3944.method_45730(command.substring(1));
        }
    }

    private void fillLineFromRaycast(class_310 client, List<class_2338> actionLog) {
        block9: {
            class_2338 targetBlockPos;
            block10: {
                if (client.field_1724 == null || client.field_1687 == null) {
                    return;
                }
                double reach = 128.0;
                class_239 hit = client.field_1724.method_5745(reach, 1.0f, false);
                if (hit.method_17783() != class_239.class_240.field_1332) break block9;
                class_3965 blockHit = (class_3965)hit;
                targetBlockPos = blockHit.method_17777();
                class_2338 playerPos = client.field_1724.method_24515();
                if (!this.cardinalMode) break block10;
                class_2350 side = blockHit.method_17780();
                switch (side.method_10166()) {
                    case field_11052: {
                        for (int y = Math.min(playerPos.method_10264(), targetBlockPos.method_10264()); y <= Math.max(playerPos.method_10264(), targetBlockPos.method_10264()); ++y) {
                            this.placeBlock(new class_2338(targetBlockPos.method_10263(), y, targetBlockPos.method_10260()), actionLog);
                        }
                        break block9;
                    }
                    case field_11048: {
                        for (int x = Math.min(playerPos.method_10263(), targetBlockPos.method_10263()); x <= Math.max(playerPos.method_10263(), targetBlockPos.method_10263()); ++x) {
                            this.placeBlock(new class_2338(x, targetBlockPos.method_10264(), targetBlockPos.method_10260()), actionLog);
                        }
                        break block9;
                    }
                    case field_11051: {
                        for (int z = Math.min(playerPos.method_10260(), targetBlockPos.method_10260()); z <= Math.max(playerPos.method_10260(), targetBlockPos.method_10260()); ++z) {
                            this.placeBlock(new class_2338(targetBlockPos.method_10263(), targetBlockPos.method_10264(), z), actionLog);
                        }
                        break;
                    }
                }
                break block9;
            }
            class_243 playerEyes = client.field_1724.method_5836(1.0f);
            class_2338 playersPos = new class_2338((int)Math.floor(playerEyes.field_1352), (int)Math.floor(playerEyes.field_1351), (int)Math.floor(playerEyes.field_1350));
            this.drawLineBetweenBlocks(playersPos, targetBlockPos, actionLog);
        }
    }

    private void drawLineBetweenBlocks(class_2338 start, class_2338 end, List<class_2338> actionLog) {
        int zs;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        int x1 = start.method_10263();
        int y1 = start.method_10264();
        int z1 = start.method_10260();
        int x2 = end.method_10263();
        int y2 = end.method_10264();
        int z2 = end.method_10260();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x1 < x2 ? 1 : -1;
        int ys = y1 < y2 ? 1 : -1;
        int n = zs = z1 < z2 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                this.placeBlock(new class_2338(x1, y1 + 1, z1), actionLog);
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                this.placeBlock(new class_2338(x1, y1 + 1, z1), actionLog);
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                this.placeBlock(new class_2338(x1, y1 + 1, z1), actionLog);
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
            }
        }
        this.placeBlock(new class_2338(x2, y2 + 1, z2), actionLog);
    }

    private void placeBlock(class_2338 posToPlace, List<class_2338> actionLog) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null || client.field_1687 == null) {
            return;
        }
        if (!client.field_1687.method_8320(posToPlace).method_26215()) {
            return;
        }
        class_243 playerEyes = client.field_1724.method_5836(1.0f);
        class_243 targetCenter = class_243.method_24953((class_2382)posToPlace);
        class_243 direction = targetCenter.method_1020(playerEyes).method_1029();
        class_2350 face = class_2350.method_10142((double)direction.field_1352, (double)direction.field_1351, (double)direction.field_1350).method_10153();
        class_3965 hitResult = new class_3965(targetCenter.method_1020(direction.method_1021(0.5)), face, posToPlace, false);
        client.field_1761.method_2896(client.field_1724, class_1268.field_5808, hitResult);
        client.field_1724.method_6104(class_1268.field_5808);
        actionLog.add(posToPlace);
    }
}

