/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.graceplugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GracePlugin
extends JavaPlugin
implements Listener,
CommandExecutor {
    private boolean graceActive = false;
    private long graceEndTime = 0L;
    private long graceDurationSeconds = 300L;
    private long autoStartDurationSeconds = 120L;
    private BukkitRunnable graceTimer;
    private FileConfiguration config;
    private FileConfiguration graceYml;
    private File graceYmlFile;
    private String graceEndTitle;
    private String graceEndSubtitle;
    private String graceEndMessage;
    private String pvpDisabledMessage;
    private String noPermissionMessage;
    private String graceStartedMessage;
    private String configReloadedMessage;
    private String graceActiveAlreadyMessage;
    private final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private BossBar bossBar;
    private final ItemStack woodenPickaxe = GracePlugin.createTool(Material.WOODEN_PICKAXE, String.valueOf(ChatColor.GREEN) + "Grace Region Selector - Corner 1");
    private final ItemStack woodenShovel = GracePlugin.createTool(Material.WOODEN_SHOVEL, String.valueOf(ChatColor.GREEN) + "Grace Region Selector - Corner 2");
    private final Map<UUID, Location[]> regionSelections = new HashMap<UUID, Location[]>();
    private static final List<String> FLAG_NAMES = List.of("block-breaking", "block-placing", "mob-damage", "mob-spawning", "invincible-players");

    public void onEnable() {
        this.loadConfig();
        this.loadGraceYml();
        this.registerEventsAndCommands();
        this.initializeMessages();
        this.graceEndTime = this.config.getLong("grace-end-time", 0L);
        this.graceActive = this.config.getBoolean("grace-active", false);
        this.graceDurationSeconds = this.config.getLong("grace-duration-seconds", 300L);
        this.autoStartDurationSeconds = this.config.getLong("auto-start-duration-seconds", 120L);
        if (this.graceActive && this.graceEndTime > System.currentTimeMillis()) {
            this.startGraceTimer();
        } else if (this.graceActive) {
            this.graceActive = false;
            this.graceEndTime = 0L;
            this.config.set("grace-active", (Object)false);
            this.config.set("grace-end-time", (Object)0);
            this.saveConfig();
        }
        if (!this.graceActive && this.config.getBoolean("auto-start", false)) {
            for (String worldName : this.config.getConfigurationSection("worlds").getKeys(false)) {
                if (!this.isGraceEnabledForWorld(worldName)) continue;
                this.graceDurationSeconds = this.autoStartDurationSeconds;
                this.startGracePeriod((CommandSender)Bukkit.getConsoleSender(), Bukkit.getWorld((String)worldName));
            }
        }
        this.getLogger().info("GracePlugin has been enabled!");
    }

    public void onDisable() {
        this.cancelGraceTimer();
        this.config.set("grace-end-time", (Object)(this.graceActive ? this.graceEndTime : 0L));
        this.config.set("grace-active", (Object)this.graceActive);
        this.saveConfig();
        this.getLogger().info("GracePlugin has been disabled!");
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.graceDurationSeconds = this.config.getLong("grace-duration-seconds", 300L);
        this.autoStartDurationSeconds = this.config.getLong("auto-start-duration-seconds", 120L);
    }

    private void loadGraceYml() {
        this.graceYmlFile = new File(this.getDataFolder(), "grace.yml");
        if (!this.graceYmlFile.exists()) {
            this.saveResource("grace.yml", false);
        }
        this.graceYml = YamlConfiguration.loadConfiguration((File)this.graceYmlFile);
    }

    private void saveGraceYml() {
        try {
            this.graceYml.save(this.graceYmlFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save grace.yml!");
            e.printStackTrace();
        }
    }

    private void registerEventsAndCommands() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("grace").setExecutor((CommandExecutor)this);
    }

    private void initializeMessages() {
        this.graceEndTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.grace-end-title", "&4Grace Period Ended!"));
        this.graceEndSubtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.grace-end-subtitle", "&ePVP is now enabled!"));
        this.graceEndMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.grace-end-message", "&cGrace period has ended! PVP is now enabled."));
        this.pvpDisabledMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.pvp-disabled-message", "&cPVP is disabled during grace period!"));
        this.graceActiveAlreadyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.grace-active-already", "&cGrace period is already active!"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.no-permission", "&cYou don't have permission to use this command!"));
        this.graceStartedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.grace-started", "&aGrace period started for %time%!"));
        this.configReloadedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.config-reloaded", "&aGrace plugin config reloaded!"));
    }

    private boolean isGraceEnabledForWorld(String worldName) {
        if (!this.config.contains("worlds." + worldName + ".grace-enabled")) {
            return false;
        }
        return this.config.getBoolean("worlds." + worldName + ".grace-enabled", false);
    }

    private long getGraceDurationForWorld(String worldName) {
        if (this.config.contains("worlds." + worldName + ".duration")) {
            return this.config.getLong("worlds." + worldName + ".duration", this.graceDurationSeconds);
        }
        return this.graceDurationSeconds;
    }

    private boolean isGraceActiveForWorld(World world) {
        if (!this.graceActive) {
            return false;
        }
        if (System.currentTimeMillis() > this.graceEndTime) {
            return false;
        }
        return this.isGraceEnabledForWorld(world.getName());
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        AnimalTamer animalTamer;
        Wolf wolf;
        if (!this.graceActive) {
            return;
        }
        Entity damagerEntity = event.getDamager();
        Entity damagedEntity = event.getEntity();
        World world = damagedEntity.getWorld();
        if (!this.isGraceActiveForWorld(world)) {
            return;
        }
        Player damager = null;
        if (damagerEntity instanceof Player) {
            Player p;
            damager = p = (Player)damagerEntity;
        } else if (damagerEntity instanceof Wolf && (wolf = (Wolf)damagerEntity).isTamed() && (animalTamer = wolf.getOwner()) instanceof Player) {
            Player owner;
            damager = owner = (Player)animalTamer;
        }
        if (damager == null) {
            return;
        }
        if (this.isInSafeZoneWithFlag(damagedEntity.getLocation(), "mob-damage")) {
            event.setCancelled(true);
            this.sendCooldownMessage(damager, this.pvpDisabledMessage);
            return;
        }
        if (damagerEntity instanceof Player && damagedEntity instanceof Player) {
            event.setCancelled(true);
            this.sendCooldownMessage(damager, this.pvpDisabledMessage);
            return;
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.graceActive) {
            return;
        }
        Entity entity = event.getEntity();
        World world = entity.getWorld();
        if (!this.isGraceActiveForWorld(world)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isInSafeZoneWithFlag(player.getLocation(), "invincible-players")) {
                event.setCancelled(true);
                return;
            }
        } else if (entity instanceof Monster && this.isInSafeZoneWithFlag(entity.getLocation(), "mob-damage")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.graceActive) {
            return;
        }
        World world = event.getEntity().getWorld();
        if (!this.isGraceActiveForWorld(world)) {
            return;
        }
        if (this.isInSafeZoneWithFlag(event.getLocation(), "mob-spawning")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.graceActive) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.isGraceActiveForWorld(world)) {
            return;
        }
        if (this.isInSafeZoneWithFlag(event.getBlock().getLocation(), "block-breaking")) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Block breaking is disabled in this safe zone during grace.");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.graceActive) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.isGraceActiveForWorld(world)) {
            return;
        }
        if (this.isInSafeZoneWithFlag(event.getBlock().getLocation(), "block-placing")) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Block placing is disabled in this safe zone during grace.");
        }
    }

    private void sendCooldownMessage(Player player, String message) {
        long currentTime = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        if (!this.lastMessageTime.containsKey(uuid) || currentTime - this.lastMessageTime.get(uuid) > 5000L) {
            player.sendMessage(message);
            this.lastMessageTime.put(uuid, currentTime);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        long remaining;
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (this.graceActive && this.isGraceActiveForWorld(world) && (remaining = (this.graceEndTime - System.currentTimeMillis()) / 1000L) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Grace period is active! Time remaining: " + this.formatTime(remaining));
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.GOLD) + "Time remaining: " + this.formatTime(remaining)));
            if (this.bossBar != null) {
                this.bossBar.addPlayer(player);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.bossBar != null) {
            this.bossBar.removePlayer(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("grace.tools")) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!this.isPluginTool(item)) {
            return;
        }
        if (event.getAction().toString().contains("RIGHT_CLICK_BLOCK")) {
            Location clickedLoc = event.getClickedBlock().getLocation();
            UUID uuid = player.getUniqueId();
            Location[] corners = this.regionSelections.getOrDefault(uuid, new Location[2]);
            if (item.isSimilar(this.woodenPickaxe)) {
                corners[0] = clickedLoc;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Selected corner 1 at " + this.formatLocation(clickedLoc));
            } else if (item.isSimilar(this.woodenShovel)) {
                corners[1] = clickedLoc;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Selected corner 2 at " + this.formatLocation(clickedLoc));
            }
            this.regionSelections.put(uuid, corners);
            event.setCancelled(true);
        }
    }

    private boolean isPluginTool(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType() == Material.WOODEN_PICKAXE && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            return meta.hasDisplayName() && meta.getDisplayName().equals(this.woodenPickaxe.getItemMeta().getDisplayName());
        }
        if (item.getType() == Material.WOODEN_SHOVEL && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            return meta.hasDisplayName() && meta.getDisplayName().equals(this.woodenShovel.getItemMeta().getDisplayName());
        }
        return false;
    }

    private String formatLocation(Location loc) {
        return String.format("X:%d Y:%d Z:%d", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "start": {
                this.handleStartCommand(sender);
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReloadCommand(sender);
                break;
            }
            case "status": {
                this.handleStatusCommand(sender);
                break;
            }
            case "tools": {
                this.handleToolsCommand(sender);
                break;
            }
            case "claim": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /grace claim <name>");
                    return true;
                }
                this.handleClaimCommand(sender, args[1]);
                break;
            }
            default: {
                if (args.length == 3) {
                    this.handleFlagCommand(sender, args[0], args[1], args[2]);
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /grace help for assistance.");
            }
        }
        return true;
    }

    private void handleStartCommand(CommandSender sender) {
        if (!sender.hasPermission("grace.start")) {
            sender.sendMessage(this.noPermissionMessage);
            return;
        }
        if (this.graceActive) {
            sender.sendMessage(this.graceActiveAlreadyMessage);
            return;
        }
        for (String worldName : this.config.getConfigurationSection("worlds").getKeys(false)) {
            if (!this.isGraceEnabledForWorld(worldName)) continue;
            long duration = this.getGraceDurationForWorld(worldName);
            this.startGracePeriod(sender, Bukkit.getWorld((String)worldName), duration);
        }
    }

    private void startGracePeriod(CommandSender sender, World world) {
        long duration = this.getGraceDurationForWorld(world.getName());
        this.startGracePeriod(sender, world, duration);
    }

    private void startGracePeriod(CommandSender sender, World world, long durationSeconds) {
        this.graceActive = true;
        this.graceDurationSeconds = durationSeconds;
        this.graceEndTime = System.currentTimeMillis() + this.graceDurationSeconds * 1000L;
        this.startGraceTimer();
        String formattedTime = this.formatTime(this.graceDurationSeconds);
        String broadcastMessage = this.graceStartedMessage.replace("%time%", formattedTime);
        Bukkit.broadcastMessage((String)broadcastMessage);
        if (sender instanceof Player || sender instanceof ConsoleCommandSender) {
            sender.sendMessage(broadcastMessage);
        }
        this.config.set("grace-end-time", (Object)this.graceEndTime);
        this.config.set("grace-active", (Object)this.graceActive);
        this.saveConfig();
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
        this.bossBar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.RED) + "Grace Period Ends In: " + formattedTime), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.bossBar.addPlayer(player);
        }
        this.bossBar.setProgress(1.0);
    }

    private void startGraceTimer() {
        this.cancelGraceTimer();
        this.graceTimer = new BukkitRunnable(){

            public void run() {
                long timeLeft = (GracePlugin.this.graceEndTime - System.currentTimeMillis()) / 1000L;
                if (timeLeft <= 0L) {
                    GracePlugin.this.endGracePeriod();
                    this.cancel();
                } else {
                    if (timeLeft <= 10L && timeLeft > 0L) {
                        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.RED) + "Grace ends in " + timeLeft + " second(s)!"));
                    }
                    if (GracePlugin.this.bossBar != null) {
                        GracePlugin.this.bossBar.setProgress(Math.max(0.0, (double)timeLeft / (double)GracePlugin.this.graceDurationSeconds));
                        GracePlugin.this.bossBar.setTitle(String.valueOf(ChatColor.RED) + "Grace Period Ends In: " + GracePlugin.this.formatTime(timeLeft));
                    }
                }
            }
        };
        this.graceTimer.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void cancelGraceTimer() {
        if (this.graceTimer != null) {
            this.graceTimer.cancel();
            this.graceTimer = null;
        }
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar = null;
        }
    }

    private void endGracePeriod() {
        this.graceActive = false;
        this.graceEndTime = 0L;
        this.cancelGraceTimer();
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(this.graceEndTitle, this.graceEndSubtitle, 10, 70, 20);
            player.sendMessage(String.valueOf(ChatColor.RED) + "GRACE IS OVER! PVP IS ENABLED!");
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        }
        Bukkit.broadcastMessage((String)this.graceEndMessage);
        this.config.set("grace-active", (Object)false);
        this.config.set("grace-end-time", (Object)0);
        this.saveConfig();
    }

    private void handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("grace.reload")) {
            sender.sendMessage(this.noPermissionMessage);
            return;
        }
        this.reloadConfig();
        this.config = this.getConfig();
        this.graceDurationSeconds = this.config.getLong("grace-duration-seconds", 300L);
        this.autoStartDurationSeconds = this.config.getLong("auto-start-duration-seconds", 120L);
        this.initializeMessages();
        sender.sendMessage(this.configReloadedMessage);
    }

    private void handleStatusCommand(CommandSender sender) {
        if (!sender.hasPermission("grace.status")) {
            sender.sendMessage(this.noPermissionMessage);
            return;
        }
        if (this.graceActive) {
            long remaining = (this.graceEndTime - System.currentTimeMillis()) / 1000L;
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Grace period is active! Time remaining: " + this.formatTime(remaining));
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No active grace period.");
        }
    }

    private void handleToolsCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("grace.tools")) {
            player.sendMessage(this.noPermissionMessage);
            return;
        }
        player.getInventory().addItem(new ItemStack[]{this.woodenPickaxe.clone()});
        player.getInventory().addItem(new ItemStack[]{this.woodenShovel.clone()});
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been given the Grace region selection tools.");
    }

    private void handleClaimCommand(CommandSender sender, String regionName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can claim regions.");
            return;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("grace.claim")) {
            player.sendMessage(this.noPermissionMessage);
            return;
        }
        UUID uuid = player.getUniqueId();
        Location[] corners = this.regionSelections.get(uuid);
        if (corners == null || corners[0] == null || corners[1] == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must select two corners first using the tools.");
            return;
        }
        Location min = this.getMinimumLocation(corners[0], corners[1]);
        Location max = this.getMaximumLocation(corners[0], corners[1]);
        String path = "regions." + regionName;
        this.graceYml.set(path + ".world", (Object)min.getWorld().getName());
        this.graceYml.set(path + ".min.x", (Object)min.getBlockX());
        this.graceYml.set(path + ".min.y", (Object)min.getBlockY());
        this.graceYml.set(path + ".min.z", (Object)min.getBlockZ());
        this.graceYml.set(path + ".max.x", (Object)max.getBlockX());
        this.graceYml.set(path + ".max.y", (Object)max.getBlockY());
        this.graceYml.set(path + ".max.z", (Object)max.getBlockZ());
        for (String flag : FLAG_NAMES) {
            this.graceYml.set(path + ".flags." + flag, (Object)false);
        }
        this.saveGraceYml();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Region '" + regionName + "' claimed successfully with all flags disabled by default.");
        this.regionSelections.remove(uuid);
    }

    private Location getMinimumLocation(Location loc1, Location loc2) {
        World world = loc1.getWorld();
        int x = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private Location getMaximumLocation(Location loc1, Location loc2) {
        World world = loc1.getWorld();
        int x = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private void handleFlagCommand(CommandSender sender, String regionName, String flag, String value) {
        boolean boolValue;
        if (!sender.hasPermission("grace.flags")) {
            sender.sendMessage(this.noPermissionMessage);
            return;
        }
        if (!FLAG_NAMES.contains(flag.toLowerCase())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid flag name. Valid flags: " + String.join((CharSequence)", ", FLAG_NAMES));
            return;
        }
        if (!this.graceYml.contains("regions." + regionName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Region '" + regionName + "' does not exist.");
            return;
        }
        if (value.equalsIgnoreCase("true")) {
            boolValue = true;
        } else if (value.equalsIgnoreCase("false")) {
            boolValue = false;
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Flag value must be true or false.");
            return;
        }
        this.graceYml.set("regions." + regionName + ".flags." + flag.toLowerCase(), (Object)boolValue);
        this.saveGraceYml();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Flag '" + flag + "' for region '" + regionName + "' set to " + boolValue + ".");
    }

    private boolean isInSafeZoneWithFlag(Location loc, String flag) {
        if (this.graceYml == null) {
            return false;
        }
        if (!this.graceYml.contains("regions")) {
            return false;
        }
        for (String regionName : this.graceYml.getConfigurationSection("regions").getKeys(false)) {
            String basePath = "regions." + regionName;
            if (!this.graceYml.contains(basePath + ".world")) continue;
            String worldName = this.graceYml.getString(basePath + ".world");
            if (!loc.getWorld().getName().equals(worldName)) continue;
            int minX = this.graceYml.getInt(basePath + ".min.x");
            int minY = this.graceYml.getInt(basePath + ".min.y");
            int minZ = this.graceYml.getInt(basePath + ".min.z");
            int maxX = this.graceYml.getInt(basePath + ".max.x");
            int maxY = this.graceYml.getInt(basePath + ".max.y");
            int maxZ = this.graceYml.getInt(basePath + ".max.z");
            if (loc.getBlockX() < minX || loc.getBlockX() > maxX || loc.getBlockY() < minY || loc.getBlockY() > maxY || loc.getBlockZ() < minZ || loc.getBlockZ() > maxZ || !this.graceYml.contains(basePath + ".flags." + flag)) continue;
            return this.graceYml.getBoolean(basePath + ".flags." + flag);
        }
        return false;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Grace Plugin Commands ===");
        if (sender.hasPermission("grace.start")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace start - Starts the grace period");
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace help - Shows this help menu");
        if (sender.hasPermission("grace.status")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace status - Shows current grace status");
        }
        if (sender.hasPermission("grace.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace reload - Reloads the config file");
        }
        if (sender.hasPermission("grace.tools")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace tools - Get region selection tools");
        }
        if (sender.hasPermission("grace.claim")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace claim <name> - Claim a safe zone region");
        }
        if (sender.hasPermission("grace.flags")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grace <regionName> <flag> <true|false> - Set flags for a region");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Flags: block-breaking, block-placing, mob-damage, mob-spawning, invincible-players");
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "============================");
    }

    private String formatTime(long seconds) {
        if (seconds < 0L) {
            seconds = 0L;
        }
        long minutes = TimeUnit.SECONDS.toMinutes(seconds);
        long remainingSeconds = seconds - TimeUnit.MINUTES.toSeconds(minutes);
        return String.format("%d minute(s) and %d second(s)", minutes, remainingSeconds);
    }

    private static ItemStack createTool(Material material, String displayName) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            item.setItemMeta(meta);
        }
        return item;
    }
}

