/*
 * Decompiled with CFR 0.152.
 */
package me.translator.chattranslator;

import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ChatTranslator
extends JavaPlugin
implements Listener,
CommandExecutor {
    private Translate googleTranslate;
    private Map<UUID, String> playerLanguages;
    private Map<UUID, Boolean> translationEnabled;
    private Map<String, Map<String, String>> translationCache;
    private FileConfiguration config;
    private String googleApiKey;
    private String libreTranslateUrl;
    private String inventoryTitle;
    private int inventorySize;
    private Material fillMaterial;
    private String translationService;
    private int cacheSize;
    private boolean useOllama;
    private String ollamaUrl;
    private String ollamaModel;
    private final Pattern CHAT_FORMAT_PATTERN = Pattern.compile("(\u00a7[0-9a-fk-or])|(&[0-9a-fk-or])");

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.playerLanguages = new HashMap<UUID, String>();
        this.translationEnabled = new HashMap<UUID, Boolean>();
        this.translationCache = new ConcurrentHashMap<String, Map<String, String>>();
        this.googleApiKey = this.config.getString("google-api-key", "YOUR_API_KEY");
        this.libreTranslateUrl = this.config.getString("libre-translate-url", "https://libretranslate.de/translate");
        this.inventoryTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.title", "&bSelect Language"));
        this.inventorySize = this.config.getInt("gui.size", 54);
        this.fillMaterial = Material.valueOf((String)this.config.getString("gui.fill-material", "GRAY_STAINED_GLASS_PANE"));
        this.translationService = this.config.getString("translation-service", "libre").toLowerCase();
        this.cacheSize = this.config.getInt("cache-size", 1000);
        this.useOllama = this.config.getBoolean("use-ollama", false);
        this.ollamaUrl = this.config.getString("ollama-url", "http://localhost:11434/api/generate");
        this.ollamaModel = this.config.getString("ollama-model", "llama2");
        this.initializeTranslationService();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("translate").setExecutor((CommandExecutor)this);
        this.getLogger().info("ChatTranslator has been enabled!");
        this.getLogger().info("Using translation service: " + this.translationService);
    }

    private void initializeTranslationService() {
        int responseCode;
        HttpURLConnection conn;
        URL url;
        if (this.translationService.equals("google") && !this.googleApiKey.equals("YOUR_API_KEY")) {
            try {
                this.googleTranslate = (Translate)TranslateOptions.newBuilder().setApiKey(this.googleApiKey).build().getService();
                this.getLogger().info("Successfully connected to Google Translate API!");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to connect to Google Translate API: " + e.getMessage());
                this.getLogger().severe("Falling back to LibreTranslate...");
                this.translationService = "libre";
            }
        } else if (this.translationService.equals("google")) {
            this.getLogger().warning("Google API key not set. Falling back to LibreTranslate...");
            this.translationService = "libre";
        }
        if (this.translationService.equals("libre")) {
            this.getLogger().info("Using LibreTranslate for translations");
            try {
                url = new URL(this.libreTranslateUrl);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    this.getLogger().warning("LibreTranslate might not be available. Status code: " + responseCode);
                    this.getLogger().warning("Plugin will still try to use it for translations.");
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Could not connect to LibreTranslate: " + e.getMessage());
                this.getLogger().warning("Plugin will still try to use it for translations when needed.");
            }
        }
        if (this.useOllama) {
            this.getLogger().info("Ollama integration enabled. Using model: " + this.ollamaModel);
            try {
                url = new URL(this.ollamaUrl.replace("/api/generate", "/api/tags"));
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    this.getLogger().warning("Ollama might not be available. Status code: " + responseCode);
                    this.getLogger().warning("Make sure Ollama is running and accessible.");
                    this.useOllama = false;
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Could not connect to Ollama: " + e.getMessage());
                this.getLogger().warning("Make sure Ollama is running and accessible.");
                this.useOllama = false;
            }
        }
    }

    public void onDisable() {
        this.playerLanguages.clear();
        this.translationEnabled.clear();
        this.translationCache.clear();
        this.getLogger().info("ChatTranslator has been disabled!");
    }

    private boolean testOllamaConnection() {
        try {
            URL url = new URL(this.ollamaUrl.replace("/api/generate", "/api/tags"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.getLogger().warning("Ollama server returned status code: " + responseCode);
                return false;
            }
            URL modelUrl = new URL(this.ollamaUrl.replace("/api/generate", "/api/show"));
            HttpURLConnection modelConn = (HttpURLConnection)modelUrl.openConnection();
            modelConn.setRequestMethod("POST");
            modelConn.setRequestProperty("Content-Type", "application/json");
            modelConn.setDoOutput(true);
            JSONObject requestBody = new JSONObject();
            requestBody.put((Object)"name", (Object)this.ollamaModel);
            try (OutputStream os = modelConn.getOutputStream();){
                byte[] input = requestBody.toJSONString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int modelResponseCode = modelConn.getResponseCode();
            if (modelResponseCode != 200) {
                this.getLogger().warning("Model '" + this.ollamaModel + "' may not be available. Status code: " + modelResponseCode);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().warning("Error testing Ollama connection: " + e.getMessage());
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be executed by players!");
            return true;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("translate")) {
            if (args.length == 0) {
                this.openLanguageSelector(player);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("toggle")) {
                    this.toggleTranslation(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("status")) {
                    this.showStatus(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("service")) {
                    this.showServiceInfo(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("clearcache")) {
                    if (player.hasPermission("chattranslator.admin")) {
                        this.translationCache.clear();
                        player.sendMessage(ChatColor.GREEN + "Translation cache cleared!");
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have permission to clear the cache!");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("testollama")) {
                    if (!player.hasPermission("chattranslator.admin")) {
                        player.sendMessage(ChatColor.RED + "You don't have permission to test Ollama!");
                        return true;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Testing Ollama connection...");
                    String testMessage = "Hello, world!";
                    String targetLang = "es";
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                        try {
                            player.sendMessage(ChatColor.GOLD + "Test message: " + ChatColor.WHITE + testMessage);
                            player.sendMessage(ChatColor.GOLD + "Target language: " + ChatColor.WHITE + targetLang + " (" + this.getLanguageName(targetLang) + ")");
                            boolean connectionOk = this.testOllamaConnection();
                            if (!connectionOk) {
                                player.sendMessage(ChatColor.RED + "Failed to connect to Ollama at " + ChatColor.YELLOW + this.ollamaUrl);
                                player.sendMessage(ChatColor.RED + "Make sure Ollama is running and the URL is correct in the config.");
                                return;
                            }
                            player.sendMessage(ChatColor.GREEN + "Connection to Ollama successful!");
                            String translated = this.translateWithOllama(testMessage, targetLang);
                            if (translated != null) {
                                player.sendMessage(ChatColor.GREEN + "Translation successful!");
                                player.sendMessage(ChatColor.GOLD + "Translated text: " + ChatColor.WHITE + translated);
                            } else {
                                player.sendMessage(ChatColor.RED + "Translation failed. Check console for errors.");
                            }
                        }
                        catch (Exception e) {
                            player.sendMessage(ChatColor.RED + "Error while testing Ollama: " + e.getMessage());
                            this.getLogger().severe("Error while testing Ollama: " + e.getMessage());
                            e.printStackTrace();
                        }
                    });
                    return true;
                }
            }
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("service") && player.hasPermission("chattranslator.admin")) {
                    String service = args[1].toLowerCase();
                    if (service.equals("google") || service.equals("libre") || service.equals("ollama")) {
                        this.config.set("translation-service", (Object)service);
                        this.saveConfig();
                        this.translationService = service;
                        this.initializeTranslationService();
                        player.sendMessage(ChatColor.GREEN + "Translation service changed to " + service);
                    } else {
                        player.sendMessage(ChatColor.RED + "Invalid service. Use 'google', 'libre', or 'ollama'");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("testollama")) {
                    if (!player.hasPermission("chattranslator.admin")) {
                        player.sendMessage(ChatColor.RED + "You don't have permission to test Ollama!");
                        return true;
                    }
                    player.sendMessage(ChatColor.YELLOW + "Testing Ollama connection...");
                    String testMessage = "Hello, world!";
                    String targetLang = args[1].toLowerCase();
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                        try {
                            player.sendMessage(ChatColor.GOLD + "Test message: " + ChatColor.WHITE + testMessage);
                            player.sendMessage(ChatColor.GOLD + "Target language: " + ChatColor.WHITE + targetLang + " (" + this.getLanguageName(targetLang) + ")");
                            boolean connectionOk = this.testOllamaConnection();
                            if (!connectionOk) {
                                player.sendMessage(ChatColor.RED + "Failed to connect to Ollama at " + ChatColor.YELLOW + this.ollamaUrl);
                                player.sendMessage(ChatColor.RED + "Make sure Ollama is running and the URL is correct in the config.");
                                return;
                            }
                            player.sendMessage(ChatColor.GREEN + "Connection to Ollama successful!");
                            String translated = this.translateWithOllama(testMessage, targetLang);
                            if (translated != null) {
                                player.sendMessage(ChatColor.GREEN + "Translation successful!");
                                player.sendMessage(ChatColor.GOLD + "Translated text: " + ChatColor.WHITE + translated);
                            } else {
                                player.sendMessage(ChatColor.RED + "Translation failed. Check console for errors.");
                            }
                        }
                        catch (Exception e) {
                            player.sendMessage(ChatColor.RED + "Error while testing Ollama: " + e.getMessage());
                            this.getLogger().severe("Error while testing Ollama: " + e.getMessage());
                            e.printStackTrace();
                        }
                    });
                    return true;
                }
            }
            if (args.length >= 3 && args[0].equalsIgnoreCase("testollama")) {
                if (!player.hasPermission("chattranslator.admin")) {
                    player.sendMessage(ChatColor.RED + "You don't have permission to test Ollama!");
                    return true;
                }
                player.sendMessage(ChatColor.YELLOW + "Testing Ollama connection...");
                String targetLang = args[1].toLowerCase();
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    sb.append(args[i]).append(" ");
                }
                String testMessage = sb.toString().trim();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    try {
                        player.sendMessage(ChatColor.GOLD + "Test message: " + ChatColor.WHITE + testMessage);
                        player.sendMessage(ChatColor.GOLD + "Target language: " + ChatColor.WHITE + targetLang + " (" + this.getLanguageName(targetLang) + ")");
                        boolean connectionOk = this.testOllamaConnection();
                        if (!connectionOk) {
                            player.sendMessage(ChatColor.RED + "Failed to connect to Ollama at " + ChatColor.YELLOW + this.ollamaUrl);
                            player.sendMessage(ChatColor.RED + "Make sure Ollama is running and the URL is correct in the config.");
                            return;
                        }
                        player.sendMessage(ChatColor.GREEN + "Connection to Ollama successful!");
                        String translated = this.translateWithOllama(testMessage, targetLang);
                        if (translated != null) {
                            player.sendMessage(ChatColor.GREEN + "Translation successful!");
                            player.sendMessage(ChatColor.GOLD + "Translated text: " + ChatColor.WHITE + translated);
                        } else {
                            player.sendMessage(ChatColor.RED + "Translation failed. Check console for errors.");
                        }
                    }
                    catch (Exception e) {
                        player.sendMessage(ChatColor.RED + "Error while testing Ollama: " + e.getMessage());
                        this.getLogger().severe("Error while testing Ollama: " + e.getMessage());
                        e.printStackTrace();
                    }
                });
                return true;
            }
            player.sendMessage(ChatColor.GOLD + "ChatTranslator Commands:");
            player.sendMessage(ChatColor.YELLOW + "/translate - " + ChatColor.WHITE + "Open language selection GUI");
            player.sendMessage(ChatColor.YELLOW + "/translate toggle - " + ChatColor.WHITE + "Toggle translation on/off");
            player.sendMessage(ChatColor.YELLOW + "/translate status - " + ChatColor.WHITE + "Show your current translation settings");
            player.sendMessage(ChatColor.YELLOW + "/translate service - " + ChatColor.WHITE + "Show current translation service");
            if (player.hasPermission("chattranslator.admin")) {
                player.sendMessage(ChatColor.YELLOW + "/translate service <google|libre|ollama> - " + ChatColor.WHITE + "Change translation service");
                player.sendMessage(ChatColor.YELLOW + "/translate clearcache - " + ChatColor.WHITE + "Clear translation cache");
                player.sendMessage(ChatColor.YELLOW + "/translate testollama [lang] [text] - " + ChatColor.WHITE + "Test Ollama connection and translation");
            }
            return true;
        }
        return false;
    }

    private void showServiceInfo(Player player) {
        player.sendMessage(ChatColor.GOLD + "=== ChatTranslator Service Info ===");
        player.sendMessage(ChatColor.YELLOW + "Current service: " + ChatColor.WHITE + this.translationService);
        player.sendMessage(ChatColor.YELLOW + "Cache size: " + ChatColor.WHITE + this.translationCache.size() + "/" + this.cacheSize);
        if (player.hasPermission("chattranslator.admin")) {
            player.sendMessage(ChatColor.YELLOW + "Available services:");
            player.sendMessage(ChatColor.WHITE + "- google (Requires API key)");
            player.sendMessage(ChatColor.WHITE + "- libre (Free, no API key needed)");
            player.sendMessage(ChatColor.WHITE + "- ollama (Requires local Ollama installation)");
        }
    }

    private void toggleTranslation(Player player) {
        UUID playerUUID;
        boolean currentState = this.translationEnabled.getOrDefault(playerUUID = player.getUniqueId(), true);
        this.translationEnabled.put(playerUUID, !currentState);
        if (currentState) {
            player.sendMessage(ChatColor.RED + "Chat translation has been disabled!");
        } else {
            player.sendMessage(ChatColor.GREEN + "Chat translation has been enabled!");
        }
    }

    private void showStatus(Player player) {
        UUID playerUUID = player.getUniqueId();
        String language = this.playerLanguages.getOrDefault(playerUUID, "Not set");
        boolean enabled = this.translationEnabled.getOrDefault(playerUUID, true);
        player.sendMessage(ChatColor.GOLD + "=== ChatTranslator Status ===");
        player.sendMessage(ChatColor.YELLOW + "Language: " + ChatColor.WHITE + language);
        player.sendMessage(ChatColor.YELLOW + "Translation: " + (enabled ? ChatColor.GREEN + "Enabled" : ChatColor.RED + "Disabled"));
        player.sendMessage(ChatColor.YELLOW + "Service: " + ChatColor.WHITE + this.translationService);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.playerLanguages.containsKey(player.getUniqueId())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.openLanguageSelector(player), 20L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String originalMessage = event.getMessage();
        Player sender = event.getPlayer();
        ArrayList originalRecipients = new ArrayList(event.getRecipients());
        for (Player recipient : originalRecipients) {
            UUID recipientUUID = recipient.getUniqueId();
            if (!this.translationEnabled.getOrDefault(recipientUUID, true).booleanValue() || !this.playerLanguages.containsKey(recipientUUID)) continue;
            String targetLanguage = this.playerLanguages.get(recipientUUID);
            if (this.playerLanguages.getOrDefault(sender.getUniqueId(), "").equals(targetLanguage)) continue;
            String messageToTranslate = this.stripFormatting(originalMessage);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                try {
                    String translatedMessage = this.getFromCache(messageToTranslate, targetLanguage);
                    if (translatedMessage == null) {
                        translatedMessage = this.translateText(messageToTranslate, targetLanguage);
                        if (translatedMessage != null) {
                            this.addToCache(messageToTranslate, targetLanguage, translatedMessage);
                        } else {
                            translatedMessage = messageToTranslate;
                        }
                    }
                    String formattedTranslation = this.formatTranslation(originalMessage, translatedMessage);
                    String format = event.getFormat();
                    String finalMessage = String.format(format, sender.getDisplayName(), formattedTranslation);
                    Bukkit.getScheduler().runTask((Plugin)this, () -> recipient.sendMessage(finalMessage));
                }
                catch (Exception e) {
                    this.getLogger().warning("Error translating message: " + e.getMessage());
                }
            });
            event.getRecipients().remove(recipient);
        }
    }

    private String translateText(String text, String targetLanguage) {
        switch (this.translationService) {
            case "google": {
                return this.translateWithGoogle(text, targetLanguage);
            }
            case "libre": {
                return this.translateWithLibre(text, targetLanguage);
            }
            case "ollama": {
                return this.translateWithOllama(text, targetLanguage);
            }
        }
        return this.translateWithLibre(text, targetLanguage);
    }

    private String translateWithGoogle(String text, String targetLanguage) {
        try {
            Translation translation = this.googleTranslate.translate(text, new Translate.TranslateOption[]{Translate.TranslateOption.targetLanguage((String)targetLanguage)});
            return translation.getTranslatedText();
        }
        catch (Exception e) {
            this.getLogger().warning("Google Translate error: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateWithLibre(String text, String targetLanguage) {
        try {
            BufferedReader br;
            URL url = new URL(this.libreTranslateUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            JSONObject requestBody = new JSONObject();
            requestBody.put((Object)"q", (Object)text);
            requestBody.put((Object)"source", (Object)"auto");
            requestBody.put((Object)"target", (Object)targetLanguage);
            requestBody.put((Object)"format", (Object)"text");
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = requestBody.toJSONString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    this.getLogger().info("LibreTranslate raw response: " + response.toString());
                    JSONParser parser = new JSONParser();
                    JSONObject jsonResponse = (JSONObject)parser.parse(response.toString());
                    String translated = (String)jsonResponse.get((Object)"translatedText");
                    if (translated == null) {
                        this.getLogger().warning("LibreTranslate response missing 'translatedText' field: " + response.toString());
                        String string = null;
                        return string;
                    }
                    String string = translated;
                    return string;
                }
                finally {
                    br.close();
                }
            }
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
            try {
                String responseLine;
                StringBuilder errorResponse = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    errorResponse.append(responseLine.trim());
                }
                this.getLogger().warning("LibreTranslate API error (" + responseCode + "): " + errorResponse.toString());
                return null;
            }
            finally {
                br.close();
            }
        }
        catch (IOException | ParseException e) {
            this.getLogger().warning("LibreTranslate API error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateWithOllama(String text, String targetLanguage) {
        try {
            URL url = new URL(this.ollamaUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            String prompt = "Translate the following text into " + this.getLanguageName(targetLanguage) + ". Provide ONLY the translation without any explanation or additional text:\n\n" + text;
            JSONObject requestBody = new JSONObject();
            requestBody.put((Object)"model", (Object)this.ollamaModel);
            requestBody.put((Object)"prompt", (Object)prompt);
            requestBody.put((Object)"stream", (Object)false);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = requestBody.toJSONString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.getLogger().warning("Ollama API error: " + responseCode);
                return null;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                JSONParser parser = new JSONParser();
                JSONObject jsonResponse = (JSONObject)parser.parse(response.toString());
                String string = (String)jsonResponse.get((Object)"response");
                return string;
            }
            catch (ParseException e) {
                this.getLogger().warning("Failed to parse Ollama response: " + e.getMessage());
                return null;
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Ollama API error: " + e.getMessage());
            return null;
        }
    }

    private String getLanguageName(String langCode) {
        HashMap<String, String> langNames = new HashMap<String, String>();
        langNames.put("en", "English");
        langNames.put("es", "Spanish");
        langNames.put("fr", "French");
        langNames.put("de", "German");
        langNames.put("it", "Italian");
        langNames.put("ja", "Japanese");
        langNames.put("ko", "Korean");
        langNames.put("zh", "Chinese");
        langNames.put("ru", "Russian");
        langNames.put("ar", "Arabic");
        langNames.put("pt", "Portuguese");
        langNames.put("hi", "Hindi");
        langNames.put("tr", "Turkish");
        langNames.put("sv", "Swedish");
        langNames.put("nl", "Dutch");
        return langNames.getOrDefault(langCode, langCode);
    }

    private String getFromCache(String text, String targetLanguage) {
        Map<String, String> langCache = this.translationCache.get(text);
        if (langCache != null) {
            return langCache.get(targetLanguage);
        }
        return null;
    }

    private void addToCache(String text, String targetLanguage, String translation) {
        if (this.translationCache.size() >= this.cacheSize) {
            String keyToRemove = this.translationCache.keySet().iterator().next();
            this.translationCache.remove(keyToRemove);
        }
        this.translationCache.computeIfAbsent(text, k -> new HashMap()).put(targetLanguage, translation);
    }

    private String stripFormatting(String input) {
        return this.CHAT_FORMAT_PATTERN.matcher(input).replaceAll("");
    }

    private String formatTranslation(String originalMessage, String translatedMessage) {
        ArrayList<FormatCode> formatCodes = new ArrayList<FormatCode>();
        Matcher matcher = this.CHAT_FORMAT_PATTERN.matcher(originalMessage);
        while (matcher.find()) {
            formatCodes.add(new FormatCode(matcher.group(), matcher.start()));
        }
        if (formatCodes.isEmpty()) {
            return translatedMessage;
        }
        StringBuilder sb = new StringBuilder();
        for (FormatCode code : formatCodes) {
            sb.append(code.code);
        }
        sb.append(translatedMessage);
        return sb.toString();
    }

    private void openLanguageSelector(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryTitle);
        ItemStack fillItem = new ItemStack(this.fillMaterial);
        ItemMeta fillMeta = fillItem.getItemMeta();
        fillMeta.setDisplayName(" ");
        fillItem.setItemMeta(fillMeta);
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, fillItem);
        }
        List<LanguageOption> languages = this.getLanguageOptions();
        for (int i = 0; i < languages.size() && i < this.inventorySize - 9; ++i) {
            LanguageOption language = languages.get(i);
            ItemStack item = new ItemStack(language.material);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)language.displayName));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + "Language Code: " + language.code);
            lore.add("");
            lore.add(ChatColor.YELLOW + "Click to select this language");
            meta.setLore(lore);
            item.setItemMeta(meta);
            inventory.setItem(language.slot, item);
        }
        boolean isEnabled = this.translationEnabled.getOrDefault(player.getUniqueId(), true);
        ItemStack toggleItem = new ItemStack(isEnabled ? Material.LIME_DYE : Material.RED_DYE);
        ItemMeta toggleMeta = toggleItem.getItemMeta();
        toggleMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)(isEnabled ? "&aTranslation: &lENABLED" : "&cTranslation: &lDISABLED")));
        ArrayList<String> toggleLore = new ArrayList<String>();
        toggleLore.add("");
        toggleLore.add(ChatColor.YELLOW + "Click to " + (isEnabled ? "disable" : "enable") + " translation");
        toggleMeta.setLore(toggleLore);
        toggleItem.setItemMeta(toggleMeta);
        inventory.setItem(this.inventorySize - 5, toggleItem);
        ItemStack serviceItem = new ItemStack(Material.BOOK);
        ItemMeta serviceMeta = serviceItem.getItemMeta();
        serviceMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Translation Service"));
        ArrayList<String> serviceLore = new ArrayList<String>();
        serviceLore.add(ChatColor.GRAY + "Current service: " + this.translationService);
        serviceLore.add("");
        if (player.hasPermission("chattranslator.admin")) {
            serviceLore.add(ChatColor.YELLOW + "Use /translate service <name>");
            serviceLore.add(ChatColor.YELLOW + "to change the service");
        }
        serviceMeta.setLore(serviceLore);
        serviceItem.setItemMeta(serviceMeta);
        inventory.setItem(this.inventorySize - 9, serviceItem);
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTitle().equals(this.inventoryTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (event.getSlot() == this.inventorySize - 5 && (clickedItem.getType() == Material.LIME_DYE || clickedItem.getType() == Material.RED_DYE)) {
            this.toggleTranslation(player);
            player.closeInventory();
            this.openLanguageSelector(player);
            return;
        }
        List<LanguageOption> languages = this.getLanguageOptions();
        for (LanguageOption language : languages) {
            if (event.getSlot() != language.slot || clickedItem.getType() != language.material) continue;
            this.playerLanguages.put(player.getUniqueId(), language.code);
            player.sendMessage(ChatColor.GREEN + "You selected " + language.displayName + ChatColor.GREEN + " as your translation language!");
            player.closeInventory();
            return;
        }
    }

    private List<LanguageOption> getLanguageOptions() {
        ArrayList<LanguageOption> languages = new ArrayList<LanguageOption>();
        if (this.config.contains("languages")) {
            for (String key : this.config.getConfigurationSection("languages").getKeys(false)) {
                String path = "languages." + key;
                String code = this.config.getString(path + ".code");
                String displayName = this.config.getString(path + ".display-name");
                Material material = Material.valueOf((String)this.config.getString(path + ".material"));
                int slot = this.config.getInt(path + ".slot");
                languages.add(new LanguageOption(code, displayName, material, slot));
            }
        } else {
            languages.add(new LanguageOption("en", "&b&lEnglish", Material.LIGHT_BLUE_WOOL, 10));
            languages.add(new LanguageOption("es", "&6&lSpanish", Material.YELLOW_WOOL, 11));
            languages.add(new LanguageOption("fr", "&9&lFrench", Material.BLUE_WOOL, 12));
            languages.add(new LanguageOption("de", "&8&lGerman", Material.BLACK_WOOL, 13));
            languages.add(new LanguageOption("it", "&a&lItalian", Material.GREEN_WOOL, 14));
            languages.add(new LanguageOption("ja", "&d&lJapanese", Material.PINK_WOOL, 19));
            languages.add(new LanguageOption("ko", "&f&lKorean", Material.WHITE_WOOL, 20));
            languages.add(new LanguageOption("zh", "&c&lChinese", Material.RED_WOOL, 21));
            languages.add(new LanguageOption("ru", "&7&lRussian", Material.LIGHT_GRAY_WOOL, 22));
            languages.add(new LanguageOption("ar", "&e&lArabic", Material.ORANGE_WOOL, 23));
            languages.add(new LanguageOption("pt", "&3&lPortuguese", Material.CYAN_WOOL, 28));
            languages.add(new LanguageOption("hi", "&5&lHindi", Material.PURPLE_WOOL, 29));
            languages.add(new LanguageOption("tr", "&c&lTurkish", Material.RED_CONCRETE, 30));
            languages.add(new LanguageOption("sv", "&b&lSwedish", Material.LIGHT_BLUE_CONCRETE, 31));
            languages.add(new LanguageOption("nl", "&6&lDutch", Material.ORANGE_CONCRETE, 32));
        }
        return languages;
    }

    private static class FormatCode {
        String code;
        int position;

        FormatCode(String code, int position) {
            this.code = code;
            this.position = position;
        }
    }

    private static class LanguageOption {
        String code;
        String displayName;
        Material material;
        int slot;

        LanguageOption(String code, String displayName, Material material, int slot) {
            this.code = code;
            this.displayName = displayName;
            this.material = material;
            this.slot = slot;
        }
    }
}

