/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.maglev.datagen;

import archives.tater.maglev.init.MaglevBlocks;
import archives.tater.maglev.init.MaglevItems;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class LangGenerator
extends FabricLanguageProvider {
    public LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        LangGenerator.add(translationBuilder, MaglevBlocks.MAGLEV_RAIL, "Maglev Rail");
        LangGenerator.add(translationBuilder, MaglevBlocks.POWERED_MAGLEV_RAIL, "Powered Maglev Rail");
        LangGenerator.add(translationBuilder, MaglevBlocks.VARIABLE_MAGLEV_RAIL, "Variable Maglev Rail");
        translationBuilder.add("itemGroup.maglev.maglev", "Maglev");
        translationBuilder.add(MaglevItems.MAGLEV_RAILS, "Maglev Rails");
        translationBuilder.add(MaglevItems.POWERED_MAGLEV_RAILS, "Powered Maglev Rails");
        translationBuilder.add(MaglevItems.VARIABLE_MAGLEV_RAILS, "Variable Maglev Rails");
        translationBuilder.add(MaglevItems.HOVERABLE_RAILS, "Hoverable Rails");
        translationBuilder.add(MaglevItems.OXIDIZERS, "Oxidizers");
        LangGenerator.addDescription(translationBuilder, MaglevBlocks.MAGLEV_RAIL, "allows minecarts to hover up to 15 blocks above it");
        LangGenerator.addDescription(translationBuilder, MaglevBlocks.POWERED_MAGLEV_RAIL, "accelerates minecarts hovering above it");
        LangGenerator.addDescription(translationBuilder, MaglevBlocks.VARIABLE_MAGLEV_RAIL, "sets minecarts' hover speed to its redstone power level");
    }

    private static void addDescription(FabricLanguageProvider.TranslationBuilder translationBuilder, class_6862<?> tagKey, String description) {
        translationBuilder.add(class_156.method_646((String)"tag", (class_2960)tagKey.comp_327()) + ".description", description);
    }

    private static void addDescription(FabricLanguageProvider.TranslationBuilder translationBuilder, class_2248 block, String description) {
        translationBuilder.add(class_156.method_646((String)"lore", (class_2960)class_7923.field_41175.method_10221((Object)block)), description);
    }

    private static void add(FabricLanguageProvider.TranslationBuilder translationBuilder, MaglevBlocks.CopperBlockSet blockSet, String name) {
        translationBuilder.add(blockSet.unaffected(), name);
        translationBuilder.add(blockSet.exposed(), "Exposed " + name);
        translationBuilder.add(blockSet.weathered(), "Weathered " + name);
        translationBuilder.add(blockSet.oxidized(), "Oxidized " + name);
        translationBuilder.add(blockSet.waxed(), "Waxed " + name);
        translationBuilder.add(blockSet.waxedExposed(), "Waxed Exposed " + name);
        translationBuilder.add(blockSet.waxedWeathered(), "Waxed Weathered " + name);
        translationBuilder.add(blockSet.waxedOxidized(), "Waxed Oxidized " + name);
    }

    private static String createRailDescription(String behavior, String speed) {
        return "A rail block that " + behavior + ". Friction is removed and minecart travel at a " + speed + " max speed.";
    }

    private static void addDescription(FabricLanguageProvider.TranslationBuilder translationBuilder, MaglevBlocks.CopperBlockSet blockSet, String behavior) {
        LangGenerator.addDescription(translationBuilder, blockSet.unaffected(), LangGenerator.createRailDescription(behavior, "very high"));
        LangGenerator.addDescription(translationBuilder, blockSet.exposed(), LangGenerator.createRailDescription(behavior, "high"));
        LangGenerator.addDescription(translationBuilder, blockSet.weathered(), LangGenerator.createRailDescription(behavior, "normal"));
        LangGenerator.addDescription(translationBuilder, blockSet.oxidized(), LangGenerator.createRailDescription(behavior, "low"));
        LangGenerator.addDescription(translationBuilder, blockSet.waxed(), LangGenerator.createRailDescription(behavior, "very high"));
        LangGenerator.addDescription(translationBuilder, blockSet.waxedExposed(), LangGenerator.createRailDescription(behavior, "high"));
        LangGenerator.addDescription(translationBuilder, blockSet.waxedWeathered(), LangGenerator.createRailDescription(behavior, "normal"));
        LangGenerator.addDescription(translationBuilder, blockSet.waxedOxidized(), LangGenerator.createRailDescription(behavior, "low"));
    }
}

