/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.maglev.init;

import archives.tater.maglev.Maglev;
import archives.tater.maglev.block.OxidizablePoweredRailBlock;
import archives.tater.maglev.block.OxidizableRailBlock;
import archives.tater.maglev.block.OxidizableVariableRailBlock;
import archives.tater.maglev.block.WaxedPoweredRailBlock;
import archives.tater.maglev.block.WaxedRailBlock;
import archives.tater.maglev.block.WaxedVariableRailBlock;
import archives.tater.maglev.init.MaglevItems;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class MaglevBlocks {
    public static final OxidizableBlockSet MAGLEV_RAIL = MaglevBlocks.registerOxidizableRails("maglev_rail", WaxedRailBlock::new, OxidizableRailBlock::new);
    public static final OxidizableBlockSet POWERED_MAGLEV_RAIL = MaglevBlocks.registerOxidizableRails("powered_maglev_rail", WaxedPoweredRailBlock::new, OxidizablePoweredRailBlock::new);
    public static final OxidizableBlockSet VARIABLE_MAGLEV_RAIL = MaglevBlocks.registerOxidizableRails("variable_maglev_rail", WaxedVariableRailBlock::new, OxidizableVariableRailBlock::new);
    public static final class_6862<class_2248> MAGLEV_RAILS = MaglevBlocks.tagOf("maglev_rails");
    public static final class_6862<class_2248> POWERED_MAGLEV_RAILS = MaglevBlocks.tagOf("powered_maglev_rails");
    public static final class_6862<class_2248> VARIABLE_MAGLEV_RAILS = MaglevBlocks.tagOf("variable_maglev_rails");
    public static final class_6862<class_2248> HOVERABLE_RAILS = MaglevBlocks.tagOf("hoverable_rails");
    public static final class_6862<class_2248> MANUALLY_OXIDIZABLE = MaglevBlocks.tagOf("manually_oxidizable");

    private static class_2248 register(String path, Function<class_4970.class_2251, class_2248> constructor, class_4970.class_2251 settings) {
        return class_2246.method_63053((class_5321)class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)Maglev.id(path)), constructor, (class_4970.class_2251)settings);
    }

    private static class_6862<class_2248> tagOf(String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Maglev.id(path));
    }

    private static String getOxidizedName(String name, class_5955.class_5811 oxidationLevel) {
        return oxidationLevel == class_5955.class_5811.field_28704 ? name : oxidationLevel.method_15434() + "_" + name;
    }

    private static class_2248 registerOxidizableRail(String name, class_5955.class_5811 oxidationLevel, BiFunction<class_5955.class_5811, class_4970.class_2251, class_2248> constructor) {
        return MaglevBlocks.register(MaglevBlocks.getOxidizedName(name, oxidationLevel), settings -> (class_2248)constructor.apply(oxidationLevel, (class_4970.class_2251)settings), class_4970.class_2251.method_9630((class_4970)class_2246.field_10167));
    }

    private static class_2248 registerWaxedRail(String name, class_5955.class_5811 oxidationLevel, BiFunction<class_5955.class_5811, class_4970.class_2251, class_2248> constructor) {
        return MaglevBlocks.register("waxed_" + MaglevBlocks.getOxidizedName(name, oxidationLevel), settings -> (class_2248)constructor.apply(oxidationLevel, (class_4970.class_2251)settings), class_4970.class_2251.method_9630((class_4970)class_2246.field_10167));
    }

    private static OxidizableBlockSet registerOxidizableRails(String name, BiFunction<class_5955.class_5811, class_4970.class_2251, class_2248> waxedConstructor, BiFunction<class_5955.class_5811, class_4970.class_2251, class_2248> oxidizableConstructor) {
        return new OxidizableBlockSet(MaglevBlocks.registerOxidizableRail(name, class_5955.class_5811.field_28704, oxidizableConstructor), MaglevBlocks.registerOxidizableRail(name, class_5955.class_5811.field_28705, oxidizableConstructor), MaglevBlocks.registerOxidizableRail(name, class_5955.class_5811.field_28706, oxidizableConstructor), MaglevBlocks.registerOxidizableRail(name, class_5955.class_5811.field_28707, oxidizableConstructor), MaglevBlocks.registerWaxedRail(name, class_5955.class_5811.field_28704, waxedConstructor), MaglevBlocks.registerWaxedRail(name, class_5955.class_5811.field_28705, waxedConstructor), MaglevBlocks.registerWaxedRail(name, class_5955.class_5811.field_28706, waxedConstructor), MaglevBlocks.registerWaxedRail(name, class_5955.class_5811.field_28707, waxedConstructor));
    }

    public static void init() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!player.method_5998(hand).method_31573(MaglevItems.OXIDIZERS)) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            if (!state.method_26164(MANUALLY_OXIDIZABLE)) {
                return class_1269.field_5811;
            }
            class_2248 oxidizedBlock = class_5955.method_34737((class_2248)state.method_26204()).orElse(null);
            if (oxidizedBlock == null) {
                return class_1269.field_5814;
            }
            world.method_8501(pos, oxidizedBlock.method_34725(state));
            world.method_45447((class_1297)player, pos, class_3417.field_14826, player.method_5634());
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_243 particlePos = pos.method_61082();
                serverWorld.method_65096((class_2394)class_2398.field_11202, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 8, 0.25, 0.0, 0.25, 0.0);
            }
            return class_1269.field_5812;
        });
    }

    public record OxidizableBlockSet(class_2248 base, class_2248 exposed, class_2248 weathered, class_2248 oxidized, class_2248 waxedBase, class_2248 waxedExposed, class_2248 waxedWeathered, class_2248 waxedOxidized) implements Iterable<class_2248>
    {
        public OxidizableBlockSet {
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)base, (class_2248)exposed);
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)exposed, (class_2248)weathered);
            OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)weathered, (class_2248)oxidized);
            OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)base, (class_2248)waxedBase);
            OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)exposed, (class_2248)waxedExposed);
            OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)weathered, (class_2248)waxedWeathered);
            OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)oxidized, (class_2248)waxedOxidized);
        }

        public Stream<class_2248> stream() {
            return Stream.of(this.base, this.exposed, this.weathered, this.oxidized, this.waxedBase, this.waxedExposed, this.waxedWeathered, this.waxedOxidized);
        }

        @Override
        @NotNull
        public Iterator<class_2248> iterator() {
            return this.stream().iterator();
        }

        public class_2248[] toArray() {
            return new class_2248[]{this.base, this.exposed, this.weathered, this.oxidized, this.waxedBase, this.waxedExposed, this.waxedWeathered, this.waxedOxidized};
        }

        public boolean contains(class_2248 block) {
            return block == this.base || block == this.exposed || block == this.weathered || block == this.oxidized || block == this.waxedBase || block == this.waxedExposed || block == this.waxedWeathered || block == this.waxedOxidized;
        }

        public static Stream<Function<OxidizableBlockSet, class_2248>> fields() {
            return Stream.of(OxidizableBlockSet::base, OxidizableBlockSet::exposed, OxidizableBlockSet::weathered, OxidizableBlockSet::oxidized, OxidizableBlockSet::waxedBase, OxidizableBlockSet::waxedExposed, OxidizableBlockSet::waxedWeathered, OxidizableBlockSet::waxedOxidized);
        }
    }
}

