/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld;

import com.luckyblockworld.LuckyBlockWorld;
import com.luckyblockworld.block.LuckyBlockManager;
import com.luckyblockworld.config.LuckyBlockConfig;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.PersistentState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.WorldChunk;

public class ModWorldGen {
    private static final String DATA_KEY = "luckyblockworld_processed_chunks";
    private static final Queue<ChunkTask> pendingChunks = new ConcurrentLinkedQueue<ChunkTask>();
    private static int chunksPerTick = 1;

    public static void register() {
        LuckyBlockWorld.LOGGER.info("Registering world generation features for luckyblockworld");
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            ChunkPos chunkPos;
            ProcessedChunks processed = ProcessedChunks.getOrCreate(world);
            if (!processed.isProcessed(chunkPos = chunk.getPos())) {
                pendingChunks.offer(new ChunkTask(world, chunk, chunkPos));
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            for (int i = 0; i < chunksPerTick && !pendingChunks.isEmpty(); ++i) {
                ChunkTask task = pendingChunks.poll();
                if (task == null || task.world != world) continue;
                ModWorldGen.processChunkTask(task);
            }
        });
        LuckyBlockWorld.LOGGER.info("World generation features registered (async processing)");
    }

    private static void processChunkTask(ChunkTask task) {
        try {
            ProcessedChunks processed = ProcessedChunks.getOrCreate(task.world);
            if (!processed.isProcessed(task.chunkPos)) {
                int generated = ModWorldGen.generateLuckyBlocksInChunk(task.world, task.chunk, task.chunkPos.x, task.chunkPos.z);
                processed.markProcessed(task.chunkPos);
                if (generated > 0) {
                    String dimension = task.world.getRegistryKey().getValue().toString();
                    LuckyBlockWorld.LOGGER.debug("Generated {} lucky blocks in chunk [{}, {}] in {}", new Object[]{generated, task.chunkPos.x, task.chunkPos.z, dimension});
                }
            }
        }
        catch (Exception e) {
            LuckyBlockWorld.LOGGER.error("Error processing chunk {}: {}", (Object)task.chunkPos, (Object)e.getMessage());
        }
    }

    public static int generateLuckyBlocksInChunk(ServerWorld world, WorldChunk chunk, int chunkX, int chunkZ) {
        LuckyBlockConfig config = LuckyBlockConfig.getInstance();
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int blocksTagged = 0;
        int targetCount = (int)((double)(256 * (world.getTopY() - world.getBottomY())) * config.overallSpawnChance);
        int attempts = targetCount * 10;
        int surfaceBlocks = 0;
        int undergroundBlocks = 0;
        int structureBlocks = 0;
        for (int i = 0; i < attempts && blocksTagged < targetCount * 2; ++i) {
            BlockState state;
            int x = startX + world.getRandom().nextInt(16);
            int z = startZ + world.getRandom().nextInt(16);
            double sample = world.getRandom().nextDouble();
            int y = sample < 0.4 ? world.getTopY() - 200 + world.getRandom().nextInt(200) : (sample < 0.7 ? world.getBottomY() + (world.getTopY() - world.getBottomY()) / 2 + world.getRandom().nextInt((world.getTopY() - world.getBottomY()) / 2) : world.getBottomY() + world.getRandom().nextInt((world.getTopY() - world.getBottomY()) / 2));
            y = Math.max(world.getBottomY(), Math.min(world.getTopY() - 1, y));
            BlockPos pos = new BlockPos(x, y, z);
            if (LuckyBlockManager.isLuckyBlock((World)world, pos) || !ModWorldGen.shouldBlockBeEligible(state = world.getBlockState(pos))) continue;
            String tier = config.selectRandomTier(world.getRandom());
            LuckyBlockManager.markAsLuckyBlock((World)world, pos, tier);
            ++blocksTagged;
            String blockName = state.getBlock().toString().toLowerCase();
            if (blockName.contains("log") || blockName.contains("leaves") || blockName.contains("planks") || blockName.contains("chest") || blockName.contains("furnace") || blockName.contains("barrel") || blockName.contains("stair") || blockName.contains("slab") || blockName.contains("fence") || blockName.contains("crafting") || blockName.contains("glass") || blockName.contains("wool") || blockName.contains("brick") || blockName.contains("stripped")) {
                ++structureBlocks;
                continue;
            }
            if (y > 60) {
                ++surfaceBlocks;
                continue;
            }
            ++undergroundBlocks;
        }
        if (blocksTagged > 0) {
            LuckyBlockWorld.LOGGER.debug("Tagged {} lucky blocks in chunk [{}, {}] - Surface: {}, Underground: {}, Structures: {}", new Object[]{blocksTagged, chunkX, chunkZ, surfaceBlocks, undergroundBlocks, structureBlocks});
        }
        return blocksTagged;
    }

    public static boolean isBlockEligibleForLucky(BlockState state) {
        return ModWorldGen.shouldBlockBeEligible(state);
    }

    private static boolean shouldBlockBeEligible(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        if (state.getHardness(null, null) < 0.0f) {
            return false;
        }
        String blockId = state.getBlock().toString().toLowerCase();
        return !blockId.contains("portal") && !blockId.contains("fire");
    }

    private static class ChunkTask {
        final ServerWorld world;
        final WorldChunk chunk;
        final ChunkPos chunkPos;

        ChunkTask(ServerWorld world, WorldChunk chunk, ChunkPos chunkPos) {
            this.world = world;
            this.chunk = chunk;
            this.chunkPos = chunkPos;
        }
    }

    private static class ProcessedChunks
    extends PersistentState {
        private final Set<ChunkPos> processedChunks = new HashSet<ChunkPos>();

        public static ProcessedChunks getOrCreate(ServerWorld world) {
            return (ProcessedChunks)world.getPersistentStateManager().getOrCreate(new PersistentState.Type(ProcessedChunks::new, ProcessedChunks::fromNbt, null), ModWorldGen.DATA_KEY);
        }

        public static ProcessedChunks fromNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registryLookup) {
            ProcessedChunks state = new ProcessedChunks();
            int[] xCoords = nbt.getIntArray("ChunkX");
            int[] zCoords = nbt.getIntArray("ChunkZ");
            for (int i = 0; i < Math.min(xCoords.length, zCoords.length); ++i) {
                state.processedChunks.add(new ChunkPos(xCoords[i], zCoords[i]));
            }
            return state;
        }

        public NbtCompound writeNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registryLookup) {
            int[] xCoords = new int[this.processedChunks.size()];
            int[] zCoords = new int[this.processedChunks.size()];
            int i = 0;
            for (ChunkPos pos : this.processedChunks) {
                xCoords[i] = pos.x;
                zCoords[i] = pos.z;
                ++i;
            }
            nbt.putIntArray("ChunkX", xCoords);
            nbt.putIntArray("ChunkZ", zCoords);
            return nbt;
        }

        public boolean isProcessed(ChunkPos pos) {
            return this.processedChunks.contains(pos);
        }

        public void markProcessed(ChunkPos pos) {
            this.processedChunks.add(pos);
            this.markDirty();
        }
    }
}

