/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld.block;

import com.luckyblockworld.LuckyBlockWorld;
import com.luckyblockworld.config.LuckyBlockConfig;
import com.luckyblockworld.event.LuckyEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.PersistentState;
import net.minecraft.world.World;

public class LuckyBlockManager
extends PersistentState {
    private static final String DATA_KEY = "luckyblockworld_data";
    public static final String TIER_VERY_UNLUCKY = "very_unlucky";
    public static final String TIER_UNLUCKY = "unlucky";
    public static final String TIER_NEUTRAL = "neutral";
    public static final String TIER_LUCKY = "lucky";
    public static final String TIER_VERY_LUCKY = "very_lucky";
    private final Map<BlockPos, String> luckyBlocks = new HashMap<BlockPos, String>();

    public static LuckyBlockManager getOrCreate(ServerWorld world) {
        return (LuckyBlockManager)world.getPersistentStateManager().getOrCreate(new PersistentState.Type(LuckyBlockManager::new, LuckyBlockManager::fromNbt, null), DATA_KEY);
    }

    public static LuckyBlockManager fromNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registryLookup) {
        LuckyBlockManager manager = new LuckyBlockManager();
        NbtCompound blocksNbt = nbt.getCompound("LuckyBlocks");
        for (String key : blocksNbt.getKeys()) {
            String[] coords = key.split(",");
            if (coords.length != 3) continue;
            try {
                BlockPos pos = new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
                String tier = blocksNbt.getString(key);
                manager.luckyBlocks.put(pos, tier);
            }
            catch (NumberFormatException e) {
                LuckyBlockWorld.LOGGER.warn("Failed to parse lucky block position: {}", (Object)key);
            }
        }
        return manager;
    }

    public NbtCompound writeNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registryLookup) {
        NbtCompound blocksNbt = new NbtCompound();
        for (Map.Entry<BlockPos, String> entry : this.luckyBlocks.entrySet()) {
            BlockPos pos = entry.getKey();
            String key = pos.getX() + "," + pos.getY() + "," + pos.getZ();
            blocksNbt.putString(key, entry.getValue());
        }
        nbt.put("LuckyBlocks", (NbtElement)blocksNbt);
        return nbt;
    }

    public static boolean isLuckyBlock(World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LuckyBlockManager manager = LuckyBlockManager.getOrCreate(serverWorld);
            return manager.luckyBlocks.containsKey(pos);
        }
        return false;
    }

    public static String getLuckyTier(World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LuckyBlockManager manager = LuckyBlockManager.getOrCreate(serverWorld);
            return manager.luckyBlocks.get(pos);
        }
        return null;
    }

    public static void markAsLuckyBlock(World world, BlockPos pos, String tier) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LuckyBlockManager manager = LuckyBlockManager.getOrCreate(serverWorld);
            manager.luckyBlocks.put(pos.toImmutable(), tier);
            manager.markDirty();
            LuckyBlockWorld.LOGGER.debug("Marked block at {} as lucky block (tier: {})", (Object)pos, (Object)tier);
        }
    }

    public static void markAsLuckyBlockWithEvent(World world, BlockPos pos, String eventName) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LuckyBlockManager manager = LuckyBlockManager.getOrCreate(serverWorld);
            String eventTier = "event:" + eventName;
            manager.luckyBlocks.put(pos.toImmutable(), eventTier);
            manager.markDirty();
            LuckyBlockWorld.LOGGER.debug("Marked block at {} as lucky block with specific event: {}", (Object)pos, (Object)eventName);
        }
    }

    public static void removeLuckyTag(World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LuckyBlockManager manager = LuckyBlockManager.getOrCreate(serverWorld);
            if (manager.luckyBlocks.remove(pos) != null) {
                manager.markDirty();
                LuckyBlockWorld.LOGGER.debug("Removed lucky tag from block at {}", (Object)pos);
            }
        }
    }

    public static void triggerLuckyEvent(ServerWorld world, BlockPos pos, PlayerEntity player, BlockState state) {
        String tier = LuckyBlockManager.getLuckyTier((World)world, pos);
        if (tier == null) {
            return;
        }
        LuckyBlockWorld.LOGGER.info("Lucky block triggered at {} by player {} (tier: {})", new Object[]{pos, player.getName().getString(), tier});
        LuckyBlockManager.removeLuckyTag((World)world, pos);
        LuckyBlockManager.triggerEventForTier(world, pos, player, state, tier);
    }

    public static BlockPos findNearestLuckyBlock(ServerWorld world, BlockPos origin, int radius) {
        LuckyBlockManager manager = LuckyBlockManager.getOrCreate(world);
        BlockPos nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (BlockPos pos : manager.luckyBlocks.keySet()) {
            double distance = pos.getSquaredDistance((Vec3i)origin);
            if (!(distance < nearestDistance) || !(distance <= (double)(radius * radius))) continue;
            nearestDistance = distance;
            nearest = pos;
        }
        return nearest;
    }

    public static List<BlockPos> getLuckyBlocksInRadius(ServerWorld world, BlockPos origin, int radius) {
        LuckyBlockManager manager = LuckyBlockManager.getOrCreate(world);
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        for (BlockPos pos : manager.luckyBlocks.keySet()) {
            if (!(pos.getSquaredDistance((Vec3i)origin) <= (double)(radius * radius))) continue;
            nearby.add(pos);
        }
        return nearby;
    }

    private static void triggerEventForTier(ServerWorld world, BlockPos pos, PlayerEntity player, BlockState state, String tier) {
        String eventName;
        if (tier.startsWith("event:")) {
            eventName = tier.substring(6);
            LuckyBlockWorld.LOGGER.info("Triggering specific event '{}' at {}", (Object)eventName, (Object)pos);
        } else {
            LuckyBlockConfig config = LuckyBlockConfig.getInstance();
            eventName = config.selectRandomEvent(tier, world.getRandom());
            LuckyBlockWorld.LOGGER.info("Triggering {} event '{}' at {}", new Object[]{tier, eventName, pos});
        }
        LuckyEventHandler.executeEvent(eventName, world, pos, player, state);
    }
}

