/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld.command;

import com.luckyblockworld.ModWorldGen;
import com.luckyblockworld.block.LuckyBlockManager;
import com.luckyblockworld.config.LuckyBlockConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandRegistryAccess;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.hit.HitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Position;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.WorldChunk;

public class ModCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register(ModCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<ServerCommandSource> dispatcher, CommandRegistryAccess registryAccess, CommandManager.RegistrationEnvironment environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"luckyblock").requires(source -> ModCommands.hasPermission(source))).then(((LiteralArgumentBuilder)CommandManager.literal((String)"find").executes(context -> ModCommands.findNearestLuckyBlock((CommandContext<ServerCommandSource>)context, 100))).then(CommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(context -> ModCommands.findNearestLuckyBlock((CommandContext<ServerCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(((LiteralArgumentBuilder)CommandManager.literal((String)"list").executes(context -> ModCommands.listNearbyLuckyBlocks((CommandContext<ServerCommandSource>)context, 50))).then(CommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(context -> ModCommands.listNearbyLuckyBlocks((CommandContext<ServerCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(CommandManager.literal((String)"info").executes(ModCommands::infoTargetedBlock))).then(((LiteralArgumentBuilder)CommandManager.literal((String)"mark").executes(ModCommands::markTargetedBlock)).then(CommandManager.argument((String)"event", (ArgumentType)StringArgumentType.greedyString()).executes(ModCommands::markTargetedBlockWithEvent)))).then(((LiteralArgumentBuilder)CommandManager.literal((String)"generate").executes(context -> ModCommands.generateInNearbyChunks((CommandContext<ServerCommandSource>)context, 5))).then(CommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> ModCommands.generateInNearbyChunks((CommandContext<ServerCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(CommandManager.literal((String)"reload").executes(ModCommands::reloadConfig)));
    }

    private static boolean hasPermission(ServerCommandSource source) {
        if (source.hasPermissionLevel(2)) {
            return true;
        }
        try {
            ServerPlayerEntity player = source.getPlayer();
            return player != null && player.isCreative();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int findNearestLuckyBlock(CommandContext<ServerCommandSource> context, int radius) {
        BlockPos playerPos;
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        ServerWorld world = source.getWorld();
        BlockPos nearest = LuckyBlockManager.findNearestLuckyBlock(world, playerPos = BlockPos.ofFloored((Position)source.getPosition()), radius);
        if (nearest != null) {
            String tier = LuckyBlockManager.getLuckyTier((World)world, nearest);
            double distance = Math.sqrt(playerPos.getSquaredDistance((Vec3i)nearest));
            String posStr = String.format("[%d, %d, %d]", nearest.getX(), nearest.getY(), nearest.getZ());
            source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.find.success", (Object[])new Object[]{posStr, distance, tier}).formatted(Formatting.GREEN), false);
            return 1;
        }
        source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.find.none", (Object[])new Object[]{radius}).formatted(Formatting.RED), false);
        return 0;
    }

    private static int listNearbyLuckyBlocks(CommandContext<ServerCommandSource> context, int radius) {
        BlockPos playerPos;
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        ServerWorld world = source.getWorld();
        List<BlockPos> luckyBlocks = LuckyBlockManager.getLuckyBlocksInRadius(world, playerPos = BlockPos.ofFloored((Position)source.getPosition()), radius);
        if (luckyBlocks.isEmpty()) {
            source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.list.none", (Object[])new Object[]{radius}).formatted(Formatting.RED), false);
            return 0;
        }
        source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.list.header", (Object[])new Object[]{luckyBlocks.size(), radius}).formatted(Formatting.GREEN), false);
        for (BlockPos pos : luckyBlocks) {
            String tier = LuckyBlockManager.getLuckyTier((World)world, pos);
            double distance = Math.sqrt(playerPos.getSquaredDistance((Vec3i)pos));
            String posStr = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
            source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.list.entry", (Object[])new Object[]{posStr, distance, tier}).formatted(Formatting.GRAY), false);
        }
        return luckyBlocks.size();
    }

    private static int reloadConfig(CommandContext<ServerCommandSource> context) {
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        LuckyBlockConfig.load();
        source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.reload.success").formatted(Formatting.GREEN), true);
        return 1;
    }

    private static int markTargetedBlock(CommandContext<ServerCommandSource> context) {
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        try {
            ServerWorld world = source.getWorld();
            ServerPlayerEntity player = source.getPlayerOrThrow();
            HitResult hitResult = player.raycast(10.0, 0.0f, false);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                BlockPos pos = blockHit.getBlockPos();
                BlockState state = world.getBlockState(pos);
                if (state.isAir()) {
                    source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.must_look"));
                    return 0;
                }
                LuckyBlockConfig config = LuckyBlockConfig.getInstance();
                String tier = config.selectRandomTier(world.getRandom());
                LuckyBlockManager.markAsLuckyBlock((World)world, pos, tier);
                String posStr = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
                source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.mark.success", (Object[])new Object[]{posStr, tier}).formatted(Formatting.GREEN), true);
                return 1;
            }
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.must_look"));
            return 0;
        }
        catch (Exception e) {
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.error", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int markTargetedBlockWithEvent(CommandContext<ServerCommandSource> context) {
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        try {
            ServerWorld world = source.getWorld();
            ServerPlayerEntity player = source.getPlayerOrThrow();
            HitResult hitResult = player.raycast(10.0, 0.0f, false);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                BlockPos pos = blockHit.getBlockPos();
                BlockState state = world.getBlockState(pos);
                if (state.isAir()) {
                    source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.must_look"));
                    return 0;
                }
                String eventInput = StringArgumentType.getString(context, (String)"event");
                String eventName = ModCommands.normalizeEventName(eventInput);
                LuckyBlockConfig config = LuckyBlockConfig.getInstance();
                if (!config.eventExists(eventName)) {
                    source.sendError((Text)Text.literal((String)("Unknown event: " + eventInput + " (normalized to: " + eventName + ")")).formatted(Formatting.RED));
                    return 0;
                }
                LuckyBlockManager.markAsLuckyBlockWithEvent((World)world, pos, eventName);
                String posStr = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
                source.sendFeedback(() -> Text.literal((String)"Marked block at ").formatted(Formatting.GREEN).append((Text)Text.literal((String)posStr).formatted(Formatting.YELLOW)).append((Text)Text.literal((String)" with event: ").formatted(Formatting.GREEN)).append((Text)Text.literal((String)eventName).formatted(Formatting.GOLD)), true);
                return 1;
            }
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.must_look"));
            return 0;
        }
        catch (Exception e) {
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.mark.error", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static String normalizeEventName(String input) {
        return input.toLowerCase().replace(" ", "_");
    }

    private static int infoTargetedBlock(CommandContext<ServerCommandSource> context) {
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        try {
            ServerWorld world = source.getWorld();
            ServerPlayerEntity player = source.getPlayerOrThrow();
            HitResult hitResult = player.raycast(10.0, 0.0f, false);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                BlockPos pos = blockHit.getBlockPos();
                BlockState state = world.getBlockState(pos);
                if (state.isAir()) {
                    source.sendError((Text)Text.translatable((String)"command.luckyblockworld.info.must_look"));
                    return 0;
                }
                String blockName = state.getBlock().getName().getString();
                String blockId = state.getBlock().toString();
                String posStr = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
                boolean isEligible = ModWorldGen.isBlockEligibleForLucky(state);
                if (LuckyBlockManager.isLuckyBlock((World)world, pos)) {
                    String tier = LuckyBlockManager.getLuckyTier((World)world, pos);
                    source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.info.block", (Object[])new Object[]{blockName}).formatted(Formatting.YELLOW).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.position", (Object[])new Object[]{posStr}).formatted(Formatting.YELLOW)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.is_lucky").formatted(Formatting.GREEN)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.tier", (Object[])new Object[]{tier}).formatted(Formatting.YELLOW)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.eligible", (Object[])new Object[]{String.valueOf(isEligible)}).formatted(Formatting.YELLOW)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.id", (Object[])new Object[]{blockId}).formatted(Formatting.GRAY)), false);
                } else {
                    source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.info.block", (Object[])new Object[]{blockName}).formatted(Formatting.YELLOW).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.position", (Object[])new Object[]{posStr}).formatted(Formatting.YELLOW)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.not_lucky").formatted(Formatting.RED)).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.eligible", (Object[])new Object[]{String.valueOf(isEligible)}).formatted(Formatting.YELLOW)).append((Text)(isEligible ? Text.translatable((String)"command.luckyblockworld.info.eligible_note") : Text.literal((String)""))).append((Text)Text.literal((String)"\n")).append((Text)Text.translatable((String)"command.luckyblockworld.info.id", (Object[])new Object[]{blockId}).formatted(Formatting.GRAY)), false);
                }
                return 1;
            }
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.info.must_look"));
            return 0;
        }
        catch (Exception e) {
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.info.error", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int generateInNearbyChunks(CommandContext<ServerCommandSource> context, int chunkRadius) {
        ServerCommandSource source = (ServerCommandSource)context.getSource();
        try {
            ServerWorld world = source.getWorld();
            BlockPos playerPos = BlockPos.ofFloored((Position)source.getPosition());
            int playerChunkX = playerPos.getX() >> 4;
            int playerChunkZ = playerPos.getZ() >> 4;
            source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.generate.start").formatted(Formatting.YELLOW), false);
            int totalGenerated = 0;
            int chunksProcessed = 0;
            for (int chunkX = playerChunkX - chunkRadius; chunkX <= playerChunkX + chunkRadius; ++chunkX) {
                for (int chunkZ = playerChunkZ - chunkRadius; chunkZ <= playerChunkZ + chunkRadius; ++chunkZ) {
                    if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                    WorldChunk chunk = world.getChunk(chunkX, chunkZ);
                    int generated = ModWorldGen.generateLuckyBlocksInChunk(world, chunk, chunkX, chunkZ);
                    totalGenerated += generated;
                    if (generated <= 0) continue;
                    ++chunksProcessed;
                }
            }
            int finalTotal = totalGenerated;
            int finalChunks = chunksProcessed;
            source.sendFeedback(() -> Text.translatable((String)"command.luckyblockworld.generate.success", (Object[])new Object[]{finalTotal, finalChunks}).formatted(Formatting.GREEN), true);
            return totalGenerated;
        }
        catch (Exception e) {
            source.sendError((Text)Text.translatable((String)"command.luckyblockworld.generate.error", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static Formatting getTierColor(String tier) {
        return switch (tier) {
            case "very_unlucky" -> Formatting.DARK_RED;
            case "unlucky" -> Formatting.RED;
            case "neutral" -> Formatting.GRAY;
            case "lucky" -> Formatting.GREEN;
            case "very_lucky" -> Formatting.GOLD;
            default -> Formatting.WHITE;
        };
    }
}

