/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.luckyblockworld.LuckyBlockWorld;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.random.Random;

public class LuckyBlockConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/luckyblockworld.json";
    public double veryUnluckyChance = 0.1;
    public double unluckyChance = 0.25;
    public double neutralChance = 0.2;
    public double luckyChance = 0.25;
    public double veryLuckyChance = 0.1;
    public double overallSpawnChance = 0.005;
    public Map<String, Integer> veryUnluckyEvents = new HashMap<String, Integer>();
    public Map<String, Integer> unluckyEvents = new HashMap<String, Integer>();
    public Map<String, Integer> neutralEvents = new HashMap<String, Integer>();
    public Map<String, Integer> luckyEvents = new HashMap<String, Integer>();
    public Map<String, Integer> veryLuckyEvents = new HashMap<String, Integer>();
    private static LuckyBlockConfig instance;

    public LuckyBlockConfig() {
        this.initializeDefaultEvents();
    }

    private void initializeDefaultEvents() {
        this.veryUnluckyEvents.put("spawn_wither", 10);
        this.veryUnluckyEvents.put("large_explosion", 15);
        this.veryUnluckyEvents.put("instant_death", 5);
        this.veryUnluckyEvents.put("lava_trap", 10);
        this.veryUnluckyEvents.put("spawn_army", 10);
        this.veryUnluckyEvents.put("random_teleport_far", 10);
        this.veryUnluckyEvents.put("spawn_elder_guardian", 8);
        this.veryUnluckyEvents.put("invert_controls", 12);
        this.veryUnluckyEvents.put("spawn_charged_creepers", 10);
        this.veryUnluckyEvents.put("inventory_shuffle_timer", 12);
        this.veryUnluckyEvents.put("spawn_warden", 8);
        this.veryUnluckyEvents.put("health_cap", 10);
        this.veryUnluckyEvents.put("experience_drain", 15);
        this.veryUnluckyEvents.put("spawn_ravagers", 8);
        this.veryUnluckyEvents.put("nether_portal_trap", 10);
        this.veryUnluckyEvents.put("item_void", 12);
        this.veryUnluckyEvents.put("obsidian_tomb", 10);
        this.veryUnluckyEvents.put("spawn_invisible_creepers", 10);
        this.veryUnluckyEvents.put("equipment_shatter", 12);
        this.veryUnluckyEvents.put("spawn_soul_sand_trap", 10);
        this.veryUnluckyEvents.put("water_breathing_removal", 10);
        this.veryUnluckyEvents.put("spawn_angry_bees", 12);
        this.unluckyEvents.put("small_explosion", 15);
        this.unluckyEvents.put("spawn_creeper", 12);
        this.unluckyEvents.put("lightning_strike", 12);
        this.unluckyEvents.put("drop_anvil", 10);
        this.unluckyEvents.put("random_teleport", 15);
        this.unluckyEvents.put("spawn_zombies", 12);
        this.unluckyEvents.put("poison_cloud", 10);
        this.unluckyEvents.put("item_scatter", 12);
        this.unluckyEvents.put("spawn_silverfish", 10);
        this.unluckyEvents.put("hunger_drain", 12);
        this.unluckyEvents.put("cobweb_trap", 10);
        this.unluckyEvents.put("blindness_effect", 12);
        this.unluckyEvents.put("armor_damage", 10);
        this.unluckyEvents.put("spawn_blazes", 8);
        this.unluckyEvents.put("slow_mining", 12);
        this.unluckyEvents.put("spawn_baby_zombies", 10);
        this.unluckyEvents.put("random_debuff", 15);
        this.unluckyEvents.put("pitfall", 10);
        this.unluckyEvents.put("spawn_witch", 10);
        this.unluckyEvents.put("inventory_lock", 12);
        this.unluckyEvents.put("fire_charge", 10);
        this.unluckyEvents.put("spawn_vex", 8);
        this.unluckyEvents.put("spawn_endermites", 10);
        this.unluckyEvents.put("spawn_magma_cubes", 10);
        this.unluckyEvents.put("spawn_drowned", 10);
        this.unluckyEvents.put("enchantment_steal", 8);
        this.unluckyEvents.put("drop_gravel", 10);
        this.unluckyEvents.put("spawn_skeleton_horse", 8);
        this.unluckyEvents.put("spawn_piglin_brutes", 8);
        this.unluckyEvents.put("levitation_trap", 12);
        this.unluckyEvents.put("spawn_ghasts", 8);
        this.neutralEvents.put("nothing", 15);
        this.neutralEvents.put("spawn_pig", 12);
        this.neutralEvents.put("drop_dirt", 15);
        this.neutralEvents.put("message", 15);
        this.neutralEvents.put("random_block", 12);
        this.neutralEvents.put("swap_items", 10);
        this.neutralEvents.put("spawn_chicken_rain", 10);
        this.neutralEvents.put("spawn_boat", 12);
        this.neutralEvents.put("play_music", 10);
        this.neutralEvents.put("random_dye", 12);
        this.neutralEvents.put("spawn_villager", 12);
        this.neutralEvents.put("item_rename", 10);
        this.neutralEvents.put("spawn_cat", 12);
        this.neutralEvents.put("plant_tree", 12);
        this.neutralEvents.put("spawn_parrot", 10);
        this.neutralEvents.put("spawn_fish", 12);
        this.neutralEvents.put("spawn_snowman", 10);
        this.neutralEvents.put("random_sapling", 12);
        this.neutralEvents.put("spawn_bunny", 12);
        this.neutralEvents.put("spawn_wandering_trader", 8);
        this.neutralEvents.put("drop_flowers", 12);
        this.neutralEvents.put("spawn_bee", 12);
        this.neutralEvents.put("spawn_turtle", 10);
        this.neutralEvents.put("random_sound", 10);
        this.neutralEvents.put("spawn_axolotl", 10);
        this.neutralEvents.put("spawn_frog", 10);
        this.neutralEvents.put("drop_bamboo", 12);
        this.neutralEvents.put("spawn_glow_squid", 10);
        this.neutralEvents.put("spawn_goat", 10);
        this.neutralEvents.put("spawn_slime", 10);
        this.neutralEvents.put("drop_cobblestone", 12);
        this.neutralEvents.put("spawn_mooshroom", 10);
        this.neutralEvents.put("drop_sand", 12);
        this.neutralEvents.put("spawn_strider", 8);
        this.neutralEvents.put("spawn_dolphin", 10);
        this.neutralEvents.put("drop_kelp", 12);
        this.neutralEvents.put("spawn_ocelot", 10);
        this.neutralEvents.put("random_potion", 10);
        this.neutralEvents.put("spawn_fox", 10);
        this.neutralEvents.put("drop_ice", 12);
        this.neutralEvents.put("teleport_surface", 10);
        this.neutralEvents.put("give_wooden_sword", 8);
        this.neutralEvents.put("play_tnt_sound", 10);
        this.neutralEvents.put("play_explosion_sound", 10);
        this.neutralEvents.put("instant_house", 5);
        this.luckyEvents.put("spawn_diamonds", 20);
        this.luckyEvents.put("enchant_gear", 15);
        this.luckyEvents.put("heal_player", 18);
        this.luckyEvents.put("spawn_experience", 18);
        this.luckyEvents.put("give_tools", 15);
        this.luckyEvents.put("spawn_emeralds", 18);
        this.luckyEvents.put("spawn_enchanted_book", 15);
        this.luckyEvents.put("potion_effects", 12);
        this.luckyEvents.put("spawn_iron_blocks", 15);
        this.luckyEvents.put("golden_apple", 15);
        this.luckyEvents.put("spawn_horse", 12);
        this.luckyEvents.put("firework_show", 10);
        this.luckyEvents.put("totem_of_undying", 8);
        this.luckyEvents.put("spawn_golem", 10);
        this.luckyEvents.put("repair_all", 12);
        this.luckyEvents.put("spawn_ancient_debris", 10);
        this.luckyEvents.put("enchanted_golden_apple", 8);
        this.luckyEvents.put("give_shield", 12);
        this.luckyEvents.put("spawn_bookshelves", 15);
        this.luckyEvents.put("lucky_fishing", 12);
        this.luckyEvents.put("spawn_name_tag", 12);
        this.luckyEvents.put("give_saddle", 12);
        this.luckyEvents.put("spawn_honey", 12);
        this.luckyEvents.put("spawn_ender_pearls", 12);
        this.luckyEvents.put("spawn_redstone", 15);
        this.luckyEvents.put("spawn_quartz", 15);
        this.luckyEvents.put("spawn_glowstone", 12);
        this.luckyEvents.put("spawn_gold_blocks", 12);
        this.luckyEvents.put("absorption_hearts", 12);
        this.luckyEvents.put("spawn_lapis", 15);
        this.luckyEvents.put("speed_boost", 15);
        this.luckyEvents.put("night_vision", 15);
        this.luckyEvents.put("water_breathing", 12);
        this.luckyEvents.put("fire_resistance", 12);
        this.luckyEvents.put("spawn_arrows", 15);
        this.luckyEvents.put("spawn_food", 15);
        this.luckyEvents.put("spawn_brewing_stand", 10);
        this.veryLuckyEvents.put("spawn_diamond_blocks", 15);
        this.veryLuckyEvents.put("spawn_treasure", 12);
        this.veryLuckyEvents.put("give_elytra", 8);
        this.veryLuckyEvents.put("spawn_nether_star", 8);
        this.veryLuckyEvents.put("beacon_effect", 10);
        this.veryLuckyEvents.put("spawn_shulker_box", 12);
        this.veryLuckyEvents.put("netherite_upgrade", 12);
        this.veryLuckyEvents.put("grant_levels", 15);
        this.veryLuckyEvents.put("creative_flight", 10);
        this.veryLuckyEvents.put("infinity_bow", 12);
        this.veryLuckyEvents.put("spawn_conduit", 10);
        this.veryLuckyEvents.put("spawn_music_discs", 8);
        this.veryLuckyEvents.put("trident_drop", 10);
        this.veryLuckyEvents.put("spawn_wither_skeleton_skull", 10);
        this.veryLuckyEvents.put("enchanted_book_library", 12);
        this.veryLuckyEvents.put("spawn_lodestone", 10);
        this.veryLuckyEvents.put("recovery_compass", 10);
        this.veryLuckyEvents.put("spawn_ender_chest", 10);
        this.veryLuckyEvents.put("spawn_netherite_block", 8);
        this.veryLuckyEvents.put("spawn_mob_heads", 8);
        this.veryLuckyEvents.put("enchanted_horse", 10);
    }

    public static LuckyBlockConfig getInstance() {
        if (instance == null) {
            instance = LuckyBlockConfig.load();
        }
        return instance;
    }

    public static LuckyBlockConfig load() {
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            LuckyBlockConfig luckyBlockConfig;
            FileReader reader = new FileReader(configFile);
            try {
                LuckyBlockConfig config = (LuckyBlockConfig)GSON.fromJson((Reader)reader, LuckyBlockConfig.class);
                LuckyBlockWorld.LOGGER.info("Loaded configuration from {}", (Object)CONFIG_FILE);
                luckyBlockConfig = config;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LuckyBlockWorld.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                }
            }
            reader.close();
            return luckyBlockConfig;
        }
        LuckyBlockConfig config = new LuckyBlockConfig();
        config.save();
        return config;
    }

    public void save() {
        File configFile = new File(CONFIG_FILE);
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
            LuckyBlockWorld.LOGGER.info("Saved configuration to {}", (Object)CONFIG_FILE);
        }
        catch (IOException e) {
            LuckyBlockWorld.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public String selectRandomTier(Random random) {
        double roll = random.nextDouble();
        double cumulative = 0.0;
        if (roll < (cumulative += this.veryUnluckyChance)) {
            return "very_unlucky";
        }
        if (roll < (cumulative += this.unluckyChance)) {
            return "unlucky";
        }
        if (roll < (cumulative += this.neutralChance)) {
            return "neutral";
        }
        if (roll < (cumulative += this.luckyChance)) {
            return "lucky";
        }
        if (roll < (cumulative += this.veryLuckyChance)) {
            return "very_lucky";
        }
        return "neutral";
    }

    public String selectRandomEvent(String tier, Random random) {
        Map<String, Integer> eventPool;
        switch (tier) {
            case "very_unlucky": {
                Map<String, Integer> map = this.veryUnluckyEvents;
                break;
            }
            case "unlucky": {
                Map<String, Integer> map = this.unluckyEvents;
                break;
            }
            case "neutral": {
                Map<String, Integer> map = this.neutralEvents;
                break;
            }
            case "lucky": {
                Map<String, Integer> map = this.luckyEvents;
                break;
            }
            case "very_lucky": {
                Map<String, Integer> map = this.veryLuckyEvents;
                break;
            }
            default: {
                Map<String, Integer> map = eventPool = this.neutralEvents;
            }
        }
        if (eventPool.isEmpty()) {
            return "no_event";
        }
        int totalWeight = eventPool.values().stream().mapToInt(Integer::intValue).sum();
        int roll = random.nextInt(totalWeight);
        int current = 0;
        for (Map.Entry<String, Integer> entry : eventPool.entrySet()) {
            if (roll >= (current += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return eventPool.keySet().iterator().next();
    }

    public boolean eventExists(String eventName) {
        return this.veryUnluckyEvents.containsKey(eventName) || this.unluckyEvents.containsKey(eventName) || this.neutralEvents.containsKey(eventName) || this.luckyEvents.containsKey(eventName) || this.veryLuckyEvents.containsKey(eventName);
    }
}

