/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld.event;

import com.luckyblockworld.LuckyBlockWorld;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.block.entity.ChestBlockEntity;
import net.minecraft.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.component.DataComponentTypes;
import net.minecraft.component.type.FireworkExplosionComponent;
import net.minecraft.component.type.FireworksComponent;
import net.minecraft.component.type.ItemEnchantmentsComponent;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.FallingBlockEntity;
import net.minecraft.entity.ItemEntity;
import net.minecraft.entity.LightningEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.attribute.EntityAttributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.entity.mob.BlazeEntity;
import net.minecraft.entity.mob.CreeperEntity;
import net.minecraft.entity.mob.DrownedEntity;
import net.minecraft.entity.mob.ElderGuardianEntity;
import net.minecraft.entity.mob.EndermiteEntity;
import net.minecraft.entity.mob.GhastEntity;
import net.minecraft.entity.mob.MagmaCubeEntity;
import net.minecraft.entity.mob.PiglinBruteEntity;
import net.minecraft.entity.mob.RavagerEntity;
import net.minecraft.entity.mob.SilverfishEntity;
import net.minecraft.entity.mob.SkeletonEntity;
import net.minecraft.entity.mob.SkeletonHorseEntity;
import net.minecraft.entity.mob.SlimeEntity;
import net.minecraft.entity.mob.VexEntity;
import net.minecraft.entity.mob.WardenEntity;
import net.minecraft.entity.mob.WitchEntity;
import net.minecraft.entity.mob.ZombieEntity;
import net.minecraft.entity.passive.AxolotlEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.FrogEntity;
import net.minecraft.entity.passive.GlowSquidEntity;
import net.minecraft.entity.passive.GoatEntity;
import net.minecraft.entity.passive.HorseEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TraderLlamaEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.VillagerEntity;
import net.minecraft.entity.passive.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.text.Text;
import net.minecraft.util.DyeColor;
import net.minecraft.util.Hand;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockView;
import net.minecraft.world.World;

public class LuckyEventHandler {
    public static void executeEvent(String eventName, ServerWorld world, BlockPos pos, PlayerEntity player, BlockState state) {
        LuckyBlockWorld.LOGGER.info("Executing event '{}' at {} for player {}", new Object[]{eventName, pos, player.getName().getString()});
        switch (eventName) {
            case "spawn_wither": {
                LuckyEventHandler.spawnWither(world, pos, player);
                break;
            }
            case "large_explosion": {
                LuckyEventHandler.largeExplosion(world, pos, player);
                break;
            }
            case "instant_death": {
                LuckyEventHandler.instantDeath(world, pos, player);
                break;
            }
            case "lava_trap": {
                LuckyEventHandler.lavaTrap(world, pos, player);
                break;
            }
            case "spawn_army": {
                LuckyEventHandler.spawnArmy(world, pos, player);
                break;
            }
            case "random_teleport_far": {
                LuckyEventHandler.randomTeleportFar(world, pos, player);
                break;
            }
            case "spawn_elder_guardian": {
                LuckyEventHandler.spawnElderGuardian(world, pos, player);
                break;
            }
            case "spawn_charged_creepers": {
                LuckyEventHandler.spawnChargedCreepers(world, pos, player);
                break;
            }
            case "invert_controls": {
                LuckyEventHandler.invertControls(world, pos, player);
                break;
            }
            case "spawn_warden": {
                LuckyEventHandler.spawnWarden(world, pos, player);
                break;
            }
            case "inventory_shuffle_timer": {
                LuckyEventHandler.inventoryShuffleTimer(world, pos, player);
                break;
            }
            case "spawn_ravagers": {
                LuckyEventHandler.spawnRavagers(world, pos, player);
                break;
            }
            case "health_cap": {
                LuckyEventHandler.healthCap(world, pos, player);
                break;
            }
            case "spawn_invisible_creepers": {
                LuckyEventHandler.spawnInvisibleCreepers(world, pos, player);
                break;
            }
            case "experience_drain": {
                LuckyEventHandler.experienceDrain(world, pos, player);
                break;
            }
            case "spawn_angry_bees": {
                LuckyEventHandler.spawnAngryBees(world, pos, player);
                break;
            }
            case "nether_portal_trap": {
                LuckyEventHandler.netherPortalTrap(world, pos, player);
                break;
            }
            case "item_void": {
                LuckyEventHandler.itemVoid(world, pos, player);
                break;
            }
            case "obsidian_tomb": {
                LuckyEventHandler.obsidianTomb(world, pos, player);
                break;
            }
            case "equipment_shatter": {
                LuckyEventHandler.equipmentShatter(world, pos, player);
                break;
            }
            case "spawn_soul_sand_trap": {
                LuckyEventHandler.spawnSoulSandTrap(world, pos, player);
                break;
            }
            case "water_breathing_removal": {
                LuckyEventHandler.waterBreathingRemoval(world, pos, player);
                break;
            }
            case "small_explosion": {
                LuckyEventHandler.smallExplosion(world, pos, player);
                break;
            }
            case "lightning_strike": {
                LuckyEventHandler.lightningStrike(world, pos, player);
                break;
            }
            case "drop_anvil": {
                LuckyEventHandler.dropAnvil(world, pos, player);
                break;
            }
            case "random_teleport": {
                LuckyEventHandler.randomTeleport(world, pos, player);
                break;
            }
            case "nothing": {
                LuckyEventHandler.nothing(world, pos, player);
                break;
            }
            case "spawn_pig": {
                LuckyEventHandler.spawnPig(world, pos, player);
                break;
            }
            case "drop_dirt": {
                LuckyEventHandler.dropDirt(world, pos, player);
                break;
            }
            case "message": {
                LuckyEventHandler.message(world, pos, player);
                break;
            }
            case "random_block": {
                LuckyEventHandler.randomBlock(world, pos, player);
                break;
            }
            case "swap_items": {
                LuckyEventHandler.swapItems(world, pos, player);
                break;
            }
            case "spawn_chicken_rain": {
                LuckyEventHandler.spawnChickenRain(world, pos, player);
                break;
            }
            case "spawn_boat": {
                LuckyEventHandler.spawnBoat(world, pos, player);
                break;
            }
            case "play_music": {
                LuckyEventHandler.playMusic(world, pos, player);
                break;
            }
            case "random_dye": {
                LuckyEventHandler.randomDye(world, pos, player);
                break;
            }
            case "spawn_villager": {
                LuckyEventHandler.spawnVillager(world, pos, player);
                break;
            }
            case "item_rename": {
                LuckyEventHandler.itemRename(world, pos, player);
                break;
            }
            case "spawn_cat": {
                LuckyEventHandler.spawnCat(world, pos, player);
                break;
            }
            case "plant_tree": {
                LuckyEventHandler.plantTree(world, pos, player);
                break;
            }
            case "spawn_parrot": {
                LuckyEventHandler.spawnParrot(world, pos, player);
                break;
            }
            case "spawn_fish": {
                LuckyEventHandler.spawnFish(world, pos, player);
                break;
            }
            case "spawn_snowman": {
                LuckyEventHandler.spawnSnowman(world, pos, player);
                break;
            }
            case "random_sapling": {
                LuckyEventHandler.randomSapling(world, pos, player);
                break;
            }
            case "spawn_bunny": {
                LuckyEventHandler.spawnBunny(world, pos, player);
                break;
            }
            case "spawn_wandering_trader": {
                LuckyEventHandler.spawnWanderingTrader(world, pos, player);
                break;
            }
            case "drop_flowers": {
                LuckyEventHandler.dropFlowers(world, pos, player);
                break;
            }
            case "spawn_bee": {
                LuckyEventHandler.spawnBee(world, pos, player);
                break;
            }
            case "spawn_turtle": {
                LuckyEventHandler.spawnTurtle(world, pos, player);
                break;
            }
            case "spawn_axolotl": {
                LuckyEventHandler.spawnAxolotl(world, pos, player);
                break;
            }
            case "spawn_frog": {
                LuckyEventHandler.spawnFrog(world, pos, player);
                break;
            }
            case "spawn_glow_squid": {
                LuckyEventHandler.spawnGlowSquid(world, pos, player);
                break;
            }
            case "spawn_goat": {
                LuckyEventHandler.spawnGoat(world, pos, player);
                break;
            }
            case "random_sound": {
                LuckyEventHandler.randomSound(world, pos, player);
                break;
            }
            case "drop_bamboo": {
                LuckyEventHandler.dropBamboo(world, pos, player);
                break;
            }
            case "spawn_slime": {
                LuckyEventHandler.spawnSlime(world, pos, player);
                break;
            }
            case "spawn_mooshroom": {
                LuckyEventHandler.spawnMooshroom(world, pos, player);
                break;
            }
            case "spawn_strider": {
                LuckyEventHandler.spawnStrider(world, pos, player);
                break;
            }
            case "spawn_dolphin": {
                LuckyEventHandler.spawnDolphin(world, pos, player);
                break;
            }
            case "spawn_ocelot": {
                LuckyEventHandler.spawnOcelot(world, pos, player);
                break;
            }
            case "spawn_fox": {
                LuckyEventHandler.spawnFox(world, pos, player);
                break;
            }
            case "drop_cobblestone": {
                LuckyEventHandler.dropCobblestone(world, pos, player);
                break;
            }
            case "drop_sand": {
                LuckyEventHandler.dropSand(world, pos, player);
                break;
            }
            case "drop_kelp": {
                LuckyEventHandler.dropKelp(world, pos, player);
                break;
            }
            case "drop_ice": {
                LuckyEventHandler.dropIce(world, pos, player);
                break;
            }
            case "random_potion": {
                LuckyEventHandler.randomPotion(world, pos, player);
                break;
            }
            case "give_wooden_sword": {
                LuckyEventHandler.giveWoodenSword(world, pos, player);
                break;
            }
            case "play_tnt_sound": {
                LuckyEventHandler.playTntSound(world, pos, player);
                break;
            }
            case "play_explosion_sound": {
                LuckyEventHandler.playExplosionSound(world, pos, player);
                break;
            }
            case "teleport_surface": {
                LuckyEventHandler.teleportSurface(world, pos, player);
                break;
            }
            case "instant_house": {
                LuckyEventHandler.instantHouse(world, pos, player);
                break;
            }
            case "spawn_creeper": {
                LuckyEventHandler.spawnCreeper(world, pos, player);
                break;
            }
            case "spawn_zombies": {
                LuckyEventHandler.spawnZombies(world, pos, player);
                break;
            }
            case "spawn_silverfish": {
                LuckyEventHandler.spawnSilverfish(world, pos, player);
                break;
            }
            case "spawn_baby_zombies": {
                LuckyEventHandler.spawnBabyZombies(world, pos, player);
                break;
            }
            case "spawn_blazes": {
                LuckyEventHandler.spawnBlazes(world, pos, player);
                break;
            }
            case "spawn_witch": {
                LuckyEventHandler.spawnWitch(world, pos, player);
                break;
            }
            case "spawn_vex": {
                LuckyEventHandler.spawnVex(world, pos, player);
                break;
            }
            case "spawn_magma_cubes": {
                LuckyEventHandler.spawnMagmaCubes(world, pos, player);
                break;
            }
            case "spawn_drowned": {
                LuckyEventHandler.spawnDrowned(world, pos, player);
                break;
            }
            case "spawn_skeleton_horse": {
                LuckyEventHandler.spawnSkeletonHorse(world, pos, player);
                break;
            }
            case "spawn_piglin_brutes": {
                LuckyEventHandler.spawnPiglinBrutes(world, pos, player);
                break;
            }
            case "spawn_ghasts": {
                LuckyEventHandler.spawnGhasts(world, pos, player);
                break;
            }
            case "spawn_endermites": {
                LuckyEventHandler.spawnEndermites(world, pos, player);
                break;
            }
            case "poison_cloud": {
                LuckyEventHandler.poisonCloud(world, pos, player);
                break;
            }
            case "item_scatter": {
                LuckyEventHandler.itemScatter(world, pos, player);
                break;
            }
            case "hunger_drain": {
                LuckyEventHandler.hungerDrain(world, pos, player);
                break;
            }
            case "cobweb_trap": {
                LuckyEventHandler.cobwebTrap(world, pos, player);
                break;
            }
            case "blindness_effect": {
                LuckyEventHandler.blindnessEffect(world, pos, player);
                break;
            }
            case "armor_damage": {
                LuckyEventHandler.armorDamage(world, pos, player);
                break;
            }
            case "slow_mining": {
                LuckyEventHandler.slowMining(world, pos, player);
                break;
            }
            case "random_debuff": {
                LuckyEventHandler.randomDebuff(world, pos, player);
                break;
            }
            case "pitfall": {
                LuckyEventHandler.pitfall(world, pos, player);
                break;
            }
            case "inventory_lock": {
                LuckyEventHandler.inventoryLock(world, pos, player);
                break;
            }
            case "fire_charge": {
                LuckyEventHandler.fireCharge(world, pos, player);
                break;
            }
            case "enchantment_steal": {
                LuckyEventHandler.enchantmentSteal(world, pos, player);
                break;
            }
            case "drop_gravel": {
                LuckyEventHandler.dropGravel(world, pos, player);
                break;
            }
            case "levitation_trap": {
                LuckyEventHandler.levitationTrap(world, pos, player);
                break;
            }
            case "spawn_diamonds": {
                LuckyEventHandler.spawnDiamonds(world, pos, player);
                break;
            }
            case "enchant_gear": {
                LuckyEventHandler.enchantGear(world, pos, player);
                break;
            }
            case "heal_player": {
                LuckyEventHandler.healPlayer(world, pos, player);
                break;
            }
            case "spawn_experience": {
                LuckyEventHandler.spawnExperience(world, pos, player);
                break;
            }
            case "give_tools": {
                LuckyEventHandler.giveTools(world, pos, player);
                break;
            }
            case "spawn_emeralds": {
                LuckyEventHandler.spawnEmeralds(world, pos, player);
                break;
            }
            case "spawn_enchanted_book": {
                LuckyEventHandler.spawnEnchantedBook(world, pos, player);
                break;
            }
            case "potion_effects": {
                LuckyEventHandler.potionEffects(world, pos, player);
                break;
            }
            case "spawn_iron_blocks": {
                LuckyEventHandler.spawnIronBlocks(world, pos, player);
                break;
            }
            case "golden_apple": {
                LuckyEventHandler.goldenApple(world, pos, player);
                break;
            }
            case "spawn_horse": {
                LuckyEventHandler.spawnHorse(world, pos, player);
                break;
            }
            case "firework_show": {
                LuckyEventHandler.fireworkShow(world, pos, player);
                break;
            }
            case "totem_of_undying": {
                LuckyEventHandler.totemOfUndying(world, pos, player);
                break;
            }
            case "spawn_golem": {
                LuckyEventHandler.spawnGolem(world, pos, player);
                break;
            }
            case "repair_all": {
                LuckyEventHandler.repairAll(world, pos, player);
                break;
            }
            case "spawn_ancient_debris": {
                LuckyEventHandler.spawnAncientDebris(world, pos, player);
                break;
            }
            case "enchanted_golden_apple": {
                LuckyEventHandler.enchantedGoldenApple(world, pos, player);
                break;
            }
            case "give_shield": {
                LuckyEventHandler.giveShield(world, pos, player);
                break;
            }
            case "spawn_bookshelves": {
                LuckyEventHandler.spawnBookshelves(world, pos, player);
                break;
            }
            case "lucky_fishing": {
                LuckyEventHandler.luckyFishing(world, pos, player);
                break;
            }
            case "spawn_name_tag": {
                LuckyEventHandler.spawnNameTag(world, pos, player);
                break;
            }
            case "give_saddle": {
                LuckyEventHandler.giveSaddle(world, pos, player);
                break;
            }
            case "spawn_honey": {
                LuckyEventHandler.spawnHoney(world, pos, player);
                break;
            }
            case "spawn_ender_pearls": {
                LuckyEventHandler.spawnEnderPearls(world, pos, player);
                break;
            }
            case "spawn_redstone": {
                LuckyEventHandler.spawnRedstone(world, pos, player);
                break;
            }
            case "spawn_quartz": {
                LuckyEventHandler.spawnQuartz(world, pos, player);
                break;
            }
            case "spawn_glowstone": {
                LuckyEventHandler.spawnGlowstone(world, pos, player);
                break;
            }
            case "spawn_gold_blocks": {
                LuckyEventHandler.spawnGoldBlocks(world, pos, player);
                break;
            }
            case "absorption_hearts": {
                LuckyEventHandler.absorptionHearts(world, pos, player);
                break;
            }
            case "spawn_lapis": {
                LuckyEventHandler.spawnLapis(world, pos, player);
                break;
            }
            case "speed_boost": {
                LuckyEventHandler.speedBoost(world, pos, player);
                break;
            }
            case "night_vision": {
                LuckyEventHandler.nightVision(world, pos, player);
                break;
            }
            case "water_breathing": {
                LuckyEventHandler.waterBreathing(world, pos, player);
                break;
            }
            case "fire_resistance": {
                LuckyEventHandler.fireResistance(world, pos, player);
                break;
            }
            case "spawn_arrows": {
                LuckyEventHandler.spawnArrows(world, pos, player);
                break;
            }
            case "spawn_food": {
                LuckyEventHandler.spawnFood(world, pos, player);
                break;
            }
            case "spawn_brewing_stand": {
                LuckyEventHandler.spawnBrewingStand(world, pos, player);
                break;
            }
            case "spawn_diamond_blocks": {
                LuckyEventHandler.spawnDiamondBlocks(world, pos, player);
                break;
            }
            case "spawn_treasure": {
                LuckyEventHandler.spawnTreasure(world, pos, player);
                break;
            }
            case "spawn_shulker_box": {
                LuckyEventHandler.spawnShulkerBox(world, pos, player);
                break;
            }
            case "netherite_upgrade": {
                LuckyEventHandler.netheriteUpgrade(world, pos, player);
                break;
            }
            case "grant_levels": {
                LuckyEventHandler.grantLevels(world, pos, player);
                break;
            }
            case "creative_flight": {
                LuckyEventHandler.creativeFlight(world, pos, player);
                break;
            }
            case "infinity_bow": {
                LuckyEventHandler.infinityBow(world, pos, player);
                break;
            }
            case "spawn_conduit": {
                LuckyEventHandler.spawnConduit(world, pos, player);
                break;
            }
            case "spawn_music_discs": {
                LuckyEventHandler.spawnMusicDiscs(world, pos, player);
                break;
            }
            case "trident_drop": {
                LuckyEventHandler.tridentDrop(world, pos, player);
                break;
            }
            case "spawn_wither_skeleton_skull": {
                LuckyEventHandler.spawnWitherSkeletonSkull(world, pos, player);
                break;
            }
            case "enchanted_book_library": {
                LuckyEventHandler.enchantedBookLibrary(world, pos, player);
                break;
            }
            case "spawn_lodestone": {
                LuckyEventHandler.spawnLodestone(world, pos, player);
                break;
            }
            case "recovery_compass": {
                LuckyEventHandler.recoveryCompass(world, pos, player);
                break;
            }
            case "spawn_ender_chest": {
                LuckyEventHandler.spawnEnderChest(world, pos, player);
                break;
            }
            case "spawn_netherite_block": {
                LuckyEventHandler.spawnNetheriteBlock(world, pos, player);
                break;
            }
            case "spawn_mob_heads": {
                LuckyEventHandler.spawnMobHeads(world, pos, player);
                break;
            }
            case "enchanted_horse": {
                LuckyEventHandler.enchantedHorse(world, pos, player);
                break;
            }
            case "give_elytra": {
                LuckyEventHandler.giveElytra(world, pos, player);
                break;
            }
            case "spawn_nether_star": {
                LuckyEventHandler.spawnNetherStar(world, pos, player);
                break;
            }
            case "beacon_effect": {
                LuckyEventHandler.beaconEffect(world, pos, player);
                break;
            }
            default: {
                LuckyBlockWorld.LOGGER.warn("Unknown event: {}", (Object)eventName);
                player.sendMessage((Text)Text.literal((String)("\u00a7eUnknown event: " + eventName)), false);
            }
        }
    }

    private static void largeExplosion(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udca5 BOOM!"), false);
        world.createExplosion(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 6.0f, World.ExplosionSourceType.BLOCK);
        LuckyBlockWorld.LOGGER.info("[Event] Large Explosion at {}", (Object)pos);
    }

    private static void instantDeath(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc80 You died instantly!"), false);
        player.setHealth(0.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Instant Death for player {}", (Object)player.getName().getString());
    }

    private static void lavaTrap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        BlockPos[] corners;
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udd25 Lava trap activated!"), false);
        BlockPos playerPos = player.getBlockPos();
        for (int x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 4; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos clearPos = playerPos.add(x, y, z);
                    BlockState state = world.getBlockState(clearPos);
                    if (!(state.getHardness((BlockView)world, clearPos) >= 0.0f) || state.isOf(Blocks.BEDROCK) || state.isOf(Blocks.BARRIER)) continue;
                    world.setBlockState(clearPos, Blocks.AIR.getDefaultState(), 3);
                }
            }
        }
        for (BlockPos corner : corners = new BlockPos[]{playerPos.add(-2, 0, -2), playerPos.add(2, 0, -2), playerPos.add(-2, 0, 2), playerPos.add(2, 0, 2)}) {
            world.setBlockState(corner, Blocks.LAVA.getDefaultState(), 3);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Lava Trap - Cleared 5x5x5 area and placed lava in corners");
    }

    private static void smallExplosion(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udca5 Pop!"), false);
        world.createExplosion(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.0f, World.ExplosionSourceType.BLOCK);
        LuckyBlockWorld.LOGGER.info("[Event] Small Explosion at {}", (Object)pos);
    }

    private static void lightningStrike(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\u26a1 Lightning strikes!"), false);
        LightningEntity lightning = (LightningEntity)EntityType.LIGHTNING_BOLT.create((World)world);
        if (lightning != null) {
            lightning.refreshPositionAndAngles(player.getX(), player.getY(), player.getZ(), 0.0f, 0.0f);
            world.spawnEntity((Entity)lightning);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Lightning Strike - Struck lightning at player position");
    }

    private static void dropAnvil(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83e\udea8 Look out above!"), false);
        BlockPos playerPos = player.getBlockPos();
        int targetHeight = 10;
        BlockPos spawnPos = null;
        for (int y = targetHeight; y >= 0; --y) {
            BlockPos checkPos = playerPos.up(y);
            BlockState state = world.getBlockState(checkPos);
            if (!state.isAir() && !state.isReplaceable()) continue;
            spawnPos = checkPos;
            break;
        }
        if (spawnPos == null) {
            spawnPos = playerPos.up(2);
        }
        world.setBlockState(spawnPos, Blocks.ANVIL.getDefaultState());
        BlockState anvilState = world.getBlockState(spawnPos);
        if (anvilState.isOf(Blocks.ANVIL)) {
            world.setBlockState(spawnPos, Blocks.AIR.getDefaultState(), 3);
            FallingBlockEntity fallingAnvil = FallingBlockEntity.spawnFromBlock((World)world, (BlockPos)spawnPos, (BlockState)anvilState);
            if (fallingAnvil != null) {
                fallingAnvil.setHurtEntities(2.0f, 40);
                int blocksAbove = spawnPos.getY() - playerPos.getY();
                LuckyBlockWorld.LOGGER.info("[Event] Drop Anvil - Spawned falling anvil {} blocks above player", (Object)blocksAbove);
            }
        }
    }

    private static void randomTeleport(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83c\udf00 You've been teleported!"), false);
        BlockPos safeLocation = LuckyEventHandler.findSafeTeleportLocation(world, player.getBlockPos(), 100, 50);
        if (safeLocation != null) {
            player.teleport((double)safeLocation.getX() + 0.5, (double)safeLocation.getY(), (double)safeLocation.getZ() + 0.5, true);
            LuckyBlockWorld.LOGGER.info("[Event] Random Teleport - Teleported player to {}", (Object)safeLocation);
        } else {
            player.sendMessage((Text)Text.literal((String)"\u00a7eNo safe location found nearby!"), false);
            LuckyBlockWorld.LOGGER.warn("[Event] Random Teleport - Could not find safe location");
        }
    }

    private static void randomTeleportFar(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83c\udf00 You've been teleported FAR away!"), false);
        BlockPos safeLocation = LuckyEventHandler.findSafeTeleportLocation(world, player.getBlockPos(), 1000, 100);
        if (safeLocation != null) {
            player.teleport((double)safeLocation.getX() + 0.5, (double)safeLocation.getY(), (double)safeLocation.getZ() + 0.5, true);
            LuckyBlockWorld.LOGGER.info("[Event] Random Teleport Far - Teleported player to {}", (Object)safeLocation);
        } else {
            player.sendMessage((Text)Text.literal((String)"\u00a7eNo safe location found! Teleporting nearby instead..."), false);
            safeLocation = LuckyEventHandler.findSafeTeleportLocation(world, player.getBlockPos(), 100, 50);
            if (safeLocation != null) {
                player.teleport((double)safeLocation.getX() + 0.5, (double)safeLocation.getY(), (double)safeLocation.getZ() + 0.5, true);
            }
            LuckyBlockWorld.LOGGER.warn("[Event] Random Teleport Far - Could not find safe location at 1000 blocks");
        }
    }

    private static BlockPos findSafeTeleportLocation(ServerWorld world, BlockPos origin, int radius, int maxAttempts) {
        boolean isNether = world.getRegistryKey() == World.NETHER;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            int offsetX = world.getRandom().nextInt(radius * 2 + 1) - radius;
            int offsetZ = world.getRandom().nextInt(radius * 2 + 1) - radius;
            BlockPos targetPos = origin.add(offsetX, 0, offsetZ);
            int startY = isNether ? 120 : world.getTopY();
            int minY = world.getBottomY();
            for (int y = startY; y >= minY; --y) {
                BlockPos checkPos = new BlockPos(targetPos.getX(), y, targetPos.getZ());
                if (!LuckyEventHandler.isSafeLocation(world, checkPos)) continue;
                return checkPos;
            }
        }
        return null;
    }

    private static boolean isSafeLocation(ServerWorld world, BlockPos pos) {
        BlockPos below = pos.down();
        BlockPos feet = pos;
        BlockPos head = pos.up();
        BlockState belowState = world.getBlockState(below);
        if (!belowState.isSolidBlock((BlockView)world, below) || belowState.isAir()) {
            return false;
        }
        if (belowState.isOf(Blocks.LAVA) || belowState.isOf(Blocks.FIRE) || belowState.isOf(Blocks.MAGMA_BLOCK) || belowState.isOf(Blocks.CAMPFIRE) || belowState.isOf(Blocks.SOUL_CAMPFIRE)) {
            return false;
        }
        BlockState feetState = world.getBlockState(feet);
        BlockState headState = world.getBlockState(head);
        if (!feetState.isAir() && feetState.isSolidBlock((BlockView)world, feet)) {
            return false;
        }
        if (!headState.isAir() && headState.isSolidBlock((BlockView)world, head)) {
            return false;
        }
        return !feetState.isOf(Blocks.LAVA) && !feetState.isOf(Blocks.FIRE) && !headState.isOf(Blocks.LAVA) && !headState.isOf(Blocks.FIRE);
    }

    private static void nothing(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77... Nothing happened."), false);
        LuckyBlockWorld.LOGGER.info("[Event] Nothing");
    }

    private static void spawnPig(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udc37 Oink!"), false);
        PigEntity pig = (PigEntity)EntityType.PIG.create((World)world);
        if (pig != null) {
            pig.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)pig);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Pig - Spawned a pig");
    }

    private static void dropDirt(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77Some dirt falls out..."), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.DIRT, world.getRandom().nextInt(8) + 1));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Dirt");
    }

    private static void message(ServerWorld world, BlockPos pos, PlayerEntity player) {
        String[] messages = new String[]{"\u00a7eYou got lucky... or did you?", "\u00a7e\u00af\\_(\u30c4)_/\u00af", "\u00a7eTry again!", "\u00a7eBetter luck next time!", "\u00a7eMeh."};
        player.sendMessage((Text)Text.literal((String)messages[world.getRandom().nextInt(messages.length)]), false);
        LuckyBlockWorld.LOGGER.info("[Event] Message");
    }

    private static void randomBlock(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7eA random block appears!"), false);
        Item[] blocks = new Item[]{Items.STONE, Items.GRANITE, Items.DIORITE, Items.ANDESITE, Items.DIRT, Items.GRASS_BLOCK, Items.PODZOL, Items.COARSE_DIRT, Items.COBBLESTONE, Items.OAK_LOG, Items.SPRUCE_LOG, Items.BIRCH_LOG, Items.JUNGLE_LOG, Items.ACACIA_LOG, Items.DARK_OAK_LOG, Items.SAND, Items.GRAVEL, Items.GOLD_ORE, Items.IRON_ORE, Items.COAL_ORE, Items.OAK_LEAVES, Items.GLASS, Items.SANDSTONE, Items.CLAY, Items.OAK_PLANKS, Items.SNOW_BLOCK, Items.ICE, Items.PUMPKIN, Items.NETHERRACK, Items.SOUL_SAND, Items.GLOWSTONE, Items.MELON, Items.MYCELIUM, Items.END_STONE, Items.EMERALD_ORE, Items.QUARTZ_BLOCK, Items.PRISMARINE, Items.SEA_LANTERN, Items.RED_SAND, Items.TERRACOTTA, Items.PACKED_ICE, Items.OBSIDIAN, Items.MAGMA_BLOCK, Items.BONE_BLOCK, Items.WHITE_CONCRETE, Items.MOSS_BLOCK, Items.CALCITE, Items.DRIPSTONE_BLOCK, Items.DEEPSLATE, Items.TUFF, Items.AMETHYST_BLOCK, Items.COPPER_ORE};
        Item randomBlock = blocks[world.getRandom().nextInt(blocks.length)];
        ItemStack blockStack = new ItemStack((ItemConvertible)randomBlock, 1);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, blockStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Random Block - Dropped random block");
    }

    private static void swapItems(ServerWorld world, BlockPos pos, PlayerEntity player) {
        int i;
        player.sendMessage((Text)Text.literal((String)"\u00a7eYour items feel... different?"), false);
        ItemStack[] hotbarItems = new ItemStack[9];
        for (i = 0; i < 9; ++i) {
            hotbarItems[i] = player.getInventory().getStack(i).copy();
        }
        for (i = hotbarItems.length - 1; i > 0; --i) {
            int j = world.getRandom().nextInt(i + 1);
            ItemStack temp = hotbarItems[i];
            hotbarItems[i] = hotbarItems[j];
            hotbarItems[j] = temp;
        }
        for (i = 0; i < 9; ++i) {
            player.getInventory().setStack(i, hotbarItems[i]);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Swap Items - Shuffled player's hotbar");
    }

    private static void spawnChickenRain(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udc14 Chicken Rain!"), false);
        for (int i = 0; i < 10; ++i) {
            ChickenEntity chicken = (ChickenEntity)EntityType.CHICKEN.create((World)world);
            if (chicken == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 4.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 4.0;
            chicken.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)(pos.getY() + 2), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            if (world.getRandom().nextBoolean()) {
                chicken.setBaby(true);
            }
            world.spawnEntity((Entity)chicken);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Chicken Rain - Spawned 10 chickens");
    }

    private static void spawnBoat(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\u26f5 A boat appears!"), false);
        Item[] boats = new Item[]{Items.OAK_BOAT, Items.SPRUCE_BOAT, Items.BIRCH_BOAT, Items.JUNGLE_BOAT, Items.ACACIA_BOAT, Items.DARK_OAK_BOAT, Items.MANGROVE_BOAT, Items.CHERRY_BOAT, Items.BAMBOO_RAFT};
        Item randomBoat = boats[world.getRandom().nextInt(boats.length)];
        ItemStack boatStack = new ItemStack((ItemConvertible)randomBoat, 1);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, boatStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Boat - Dropped random boat");
    }

    private static void playMusic(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83c\udfb5 Music plays..."), false);
        RegistryEntry.Reference[] musicDiscs = new RegistryEntry.Reference[]{SoundEvents.MUSIC_DISC_13, SoundEvents.MUSIC_DISC_CAT, SoundEvents.MUSIC_DISC_BLOCKS, SoundEvents.MUSIC_DISC_CHIRP, SoundEvents.MUSIC_DISC_FAR, SoundEvents.MUSIC_DISC_MALL, SoundEvents.MUSIC_DISC_MELLOHI, SoundEvents.MUSIC_DISC_STAL, SoundEvents.MUSIC_DISC_STRAD, SoundEvents.MUSIC_DISC_WARD, SoundEvents.MUSIC_DISC_11, SoundEvents.MUSIC_DISC_WAIT, SoundEvents.MUSIC_DISC_PIGSTEP, SoundEvents.MUSIC_DISC_OTHERSIDE, SoundEvents.MUSIC_DISC_5, SoundEvents.MUSIC_DISC_RELIC};
        RegistryEntry.Reference randomMusic = musicDiscs[world.getRandom().nextInt(musicDiscs.length)];
        world.playSound(null, pos, (SoundEvent)randomMusic.value(), SoundCategory.RECORDS, 1.0f, 1.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Play Music - Playing random music disc");
    }

    private static void randomDye(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83c\udfa8 Colorful Dye!"), false);
        Item[] dyes = new Item[]{Items.WHITE_DYE, Items.ORANGE_DYE, Items.MAGENTA_DYE, Items.LIGHT_BLUE_DYE, Items.YELLOW_DYE, Items.LIME_DYE, Items.PINK_DYE, Items.GRAY_DYE, Items.LIGHT_GRAY_DYE, Items.CYAN_DYE, Items.PURPLE_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.GREEN_DYE, Items.RED_DYE, Items.BLACK_DYE};
        Item randomDye = dyes[world.getRandom().nextInt(dyes.length)];
        ItemStack dyeStack = new ItemStack((ItemConvertible)randomDye, 64);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, dyeStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Random Dye - Dropped stack of random dye");
    }

    private static void spawnVillager(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\ud83d\udc68\u200d\ud83c\udf3e A villager appears!"), false);
        String[] names = new String[]{"Fred", "George", "Emmanuel", "Walter", "Bob", "Steve", "Harold", "Gerald", "Martin", "Oliver", "Henry", "Arthur", "Thomas", "James", "Charles", "William", "Edward", "Albert", "Samuel", "Benjamin", "Daniel", "Michael", "David", "Richard", "Frank", "Larry", "Gary", "Dennis", "Kenneth", "Ronald"};
        VillagerEntity villager = (VillagerEntity)EntityType.VILLAGER.create((World)world);
        if (villager != null) {
            villager.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            String randomName = names[world.getRandom().nextInt(names.length)];
            villager.setCustomName((Text)Text.literal((String)("\u00a7e" + randomName)));
            villager.setCustomNameVisible(true);
            world.spawnEntity((Entity)villager);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Villager - Spawned villager with random name");
    }

    private static void itemRename(ServerWorld world, BlockPos pos, PlayerEntity player) {
        ItemStack heldItem = player.getMainHandStack();
        if (heldItem.isEmpty()) {
            player.sendMessage((Text)Text.literal((String)"\u00a77Nothing to rename..."), false);
            return;
        }
        String[] names = new String[]{"The Legendary Stick", "Sword of Destiny", "Bob's Favorite Tool", "Potato Peeler 3000", "Not a Weapon", "Steve's Old Boot", "The Chosen One", "Banana", "Mr. Pickles", "Super Ultra Mega Item", "Thing", "Definitely Not Stolen", "Kevin", "The Destroyer", "Butter Knife", "Jeff's Property", "Pointy End Goes Here", "Mighty Spoon", "Dragon Slayer", "Gary", "The Whacker", "Shiny Rock", "World Breaker", "Totally Normal Item", "Steve Jr.", "The Thing That Does Stuff"};
        String randomName = names[world.getRandom().nextInt(names.length)];
        heldItem.set(DataComponentTypes.CUSTOM_NAME, (Object)Text.literal((String)("\u00a7b" + randomName)));
        player.sendMessage((Text)Text.literal((String)("\u00a7eYour item has been renamed to: \u00a7b" + randomName)), false);
        LuckyBlockWorld.LOGGER.info("[Event] Item Rename - Renamed held item to: " + randomName);
    }

    private static void spawnCat(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udc31 Meow!"), false);
        CatEntity cat = (CatEntity)EntityType.CAT.create((World)world);
        if (cat != null) {
            cat.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            Registry catVariantRegistry = world.getRegistryManager().get(RegistryKeys.CAT_VARIANT);
            List variants = catVariantRegistry.streamEntries().toList();
            if (!variants.isEmpty()) {
                RegistryEntry.Reference randomVariant = (RegistryEntry.Reference)variants.get(world.getRandom().nextInt(variants.size()));
                cat.setVariant((RegistryEntry)randomVariant);
            }
            world.spawnEntity((Entity)cat);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Cat - Spawned a random colored cat");
    }

    private static void plantTree(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\ud83c\udf33 A tree begins to grow!"), false);
        Block[] saplings = new Block[]{Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.CHERRY_SAPLING, Blocks.MANGROVE_PROPAGULE};
        BlockPos belowPos = pos.down();
        world.setBlockState(belowPos, Blocks.DIRT.getDefaultState());
        Block randomSapling = saplings[world.getRandom().nextInt(saplings.length)];
        world.setBlockState(pos, randomSapling.getDefaultState());
        LuckyBlockWorld.LOGGER.info("[Event] Plant Tree - Placed sapling with dirt");
    }

    private static void spawnParrot(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83e\udd9c Squawk!"), false);
        ParrotEntity parrot = (ParrotEntity)EntityType.PARROT.create((World)world);
        if (parrot != null) {
            parrot.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            ParrotEntity.Variant[] variants = ParrotEntity.Variant.values();
            ParrotEntity.Variant randomVariant = variants[world.getRandom().nextInt(variants.length)];
            parrot.setVariant(randomVariant);
            world.spawnEntity((Entity)parrot);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Parrot - Spawned a random colored parrot");
    }

    private static void spawnFish(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc1f Fish!"), false);
        Item[] fishItems = new Item[]{Items.COD, Items.SALMON, Items.TROPICAL_FISH, Items.PUFFERFISH};
        int count = world.getRandom().nextInt(4) + 3;
        for (int i = 0; i < count; ++i) {
            Item randomFish = fishItems[world.getRandom().nextInt(fishItems.length)];
            ItemStack fishStack = new ItemStack((ItemConvertible)randomFish, 1);
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, fishStack);
            world.spawnEntity((Entity)itemEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Fish - Dropped " + count + " fish items");
    }

    private static void spawnSnowman(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7f\u26c4 A snow golem appears!"), false);
        SnowGolemEntity snowGolem = (SnowGolemEntity)EntityType.SNOW_GOLEM.create((World)world);
        if (snowGolem != null) {
            snowGolem.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)snowGolem);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Snowman - Spawned a snow golem");
    }

    private static void randomSapling(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\ud83c\udf31 Random Saplings!"), false);
        Item[] saplings = new Item[]{Items.OAK_SAPLING, Items.SPRUCE_SAPLING, Items.BIRCH_SAPLING, Items.JUNGLE_SAPLING, Items.ACACIA_SAPLING, Items.DARK_OAK_SAPLING, Items.CHERRY_SAPLING, Items.MANGROVE_PROPAGULE, Items.AZALEA, Items.FLOWERING_AZALEA};
        int count = world.getRandom().nextInt(4) + 2;
        for (int i = 0; i < count; ++i) {
            Item randomSapling = saplings[world.getRandom().nextInt(saplings.length)];
            ItemStack saplingStack = new ItemStack((ItemConvertible)randomSapling, 1);
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, saplingStack);
            world.spawnEntity((Entity)itemEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Random Sapling - Dropped " + count + " random saplings");
    }

    private static void spawnBunny(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7f\ud83d\udc30 A bunny hops by!"), false);
        RabbitEntity rabbit = (RabbitEntity)EntityType.RABBIT.create((World)world);
        if (rabbit != null) {
            rabbit.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            RabbitEntity.RabbitType[] variants = RabbitEntity.RabbitType.values();
            RabbitEntity.RabbitType randomVariant = variants[world.getRandom().nextInt(variants.length)];
            rabbit.setVariant(randomVariant);
            world.spawnEntity((Entity)rabbit);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Bunny - Spawned a random colored rabbit");
    }

    private static void spawnWanderingTrader(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc68\u200d\ud83d\udcbc A wandering trader arrives!"), false);
        WanderingTraderEntity trader = (WanderingTraderEntity)EntityType.WANDERING_TRADER.create((World)world);
        if (trader != null) {
            trader.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)trader);
            for (int i = 0; i < 2; ++i) {
                TraderLlamaEntity llama = (TraderLlamaEntity)EntityType.TRADER_LLAMA.create((World)world);
                if (llama == null) continue;
                double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
                double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
                llama.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
                world.spawnEntity((Entity)llama);
            }
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Wandering Trader - Spawned trader with llamas");
    }

    private static void dropFlowers(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83c\udf38 Flowers bloom everywhere!"), false);
        Item[] flowers = new Item[]{Items.DANDELION, Items.POPPY, Items.BLUE_ORCHID, Items.ALLIUM, Items.AZURE_BLUET, Items.RED_TULIP, Items.ORANGE_TULIP, Items.WHITE_TULIP, Items.PINK_TULIP, Items.OXEYE_DAISY, Items.CORNFLOWER, Items.LILY_OF_THE_VALLEY, Items.SUNFLOWER, Items.LILAC, Items.ROSE_BUSH, Items.PEONY};
        int count = 5 + world.getRandom().nextInt(6);
        for (int i = 0; i < count; ++i) {
            Item randomFlower = flowers[world.getRandom().nextInt(flowers.length)];
            ItemStack flowerStack = new ItemStack((ItemConvertible)randomFlower, 1);
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetY = world.getRandom().nextDouble() * 0.5;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 0.5 + offsetY, (double)pos.getZ() + 0.5 + offsetZ, flowerStack);
            world.spawnEntity((Entity)itemEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Drop Flowers - Dropped " + count + " random flowers");
    }

    private static void spawnBee(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udc1d Friendly bees appear!"), false);
        int count = 3 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            BeeEntity bee = (BeeEntity)EntityType.BEE.create((World)world);
            if (bee == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetY = world.getRandom().nextDouble() * 1.5;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            bee.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)bee);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Bee - Spawned " + count + " friendly bees");
    }

    private static void spawnTurtle(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a72\ud83d\udc22 Baby turtles hatch!"), false);
        int count = 2 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            TurtleEntity turtle = (TurtleEntity)EntityType.TURTLE.create((World)world);
            if (turtle == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            turtle.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            turtle.setBaby(true);
            world.spawnEntity((Entity)turtle);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Turtle - Spawned " + count + " baby turtles");
    }

    private static void spawnAxolotl(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83e\udd8e Colorful axolotls appear!"), false);
        int count = 2 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            AxolotlEntity axolotl = (AxolotlEntity)EntityType.AXOLOTL.create((World)world);
            if (axolotl == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            axolotl.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)axolotl);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Axolotl - Spawned " + count + " axolotls");
    }

    private static void spawnFrog(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a72\ud83d\udc38 Frogs hop by!"), false);
        int count = 2 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            FrogEntity frog = (FrogEntity)EntityType.FROG.create((World)world);
            if (frog == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            frog.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)frog);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Frog - Spawned " + count + " frogs");
    }

    private static void spawnGlowSquid(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2728 Glowing squids appear!"), false);
        int count = 2 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            GlowSquidEntity glowSquid = (GlowSquidEntity)EntityType.GLOW_SQUID.create((World)world);
            if (glowSquid == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            glowSquid.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)glowSquid);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Glow Squid - Spawned " + count + " glow squids");
    }

    private static void spawnGoat(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7f\ud83d\udc10 A goat appears!"), false);
        GoatEntity goat = (GoatEntity)EntityType.GOAT.create((World)world);
        if (goat != null) {
            goat.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            if (world.getRandom().nextFloat() < 0.2f) {
                goat.setScreaming(true);
            }
            world.spawnEntity((Entity)goat);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Goat - Spawned a goat");
    }

    private static void randomSound(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udd0a What was that sound?"), false);
        SoundEvent[] sounds = new SoundEvent[]{SoundEvents.ENTITY_COW_AMBIENT, SoundEvents.ENTITY_PIG_AMBIENT, SoundEvents.ENTITY_CHICKEN_AMBIENT, SoundEvents.ENTITY_SHEEP_AMBIENT, SoundEvents.ENTITY_HORSE_AMBIENT, SoundEvents.ENTITY_CAT_AMBIENT, SoundEvents.ENTITY_WOLF_AMBIENT, SoundEvents.ENTITY_VILLAGER_AMBIENT, SoundEvents.ENTITY_ZOMBIE_AMBIENT, SoundEvents.ENTITY_SKELETON_AMBIENT, SoundEvents.ENTITY_CREEPER_PRIMED, SoundEvents.ENTITY_ENDERMAN_AMBIENT, SoundEvents.ENTITY_GHAST_AMBIENT, SoundEvents.ENTITY_PHANTOM_AMBIENT, SoundEvents.ENTITY_DOLPHIN_AMBIENT, SoundEvents.ENTITY_PARROT_AMBIENT, SoundEvents.ENTITY_BEE_LOOP, SoundEvents.ENTITY_FOX_AMBIENT, SoundEvents.ENTITY_GOAT_SCREAMING_AMBIENT, (SoundEvent)SoundEvents.BLOCK_NOTE_BLOCK_PLING.value(), SoundEvents.ENTITY_PLAYER_BURP, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, SoundEvents.BLOCK_BELL_USE, SoundEvents.BLOCK_BREWING_STAND_BREW, SoundEvents.BLOCK_PORTAL_AMBIENT};
        SoundEvent randomSound = sounds[world.getRandom().nextInt(sounds.length)];
        world.playSound(null, pos, randomSound, SoundCategory.AMBIENT, 1.0f, 1.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Random Sound - Played random sound");
    }

    private static void dropBamboo(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a72\ud83c\udf8d Bamboo drops!"), false);
        ItemStack bambooStack = new ItemStack((ItemConvertible)Items.BAMBOO, 64);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, bambooStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Bamboo - Dropped 64 bamboo");
    }

    private static void spawnSlime(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\ud83d\udfe2 Tiny slimes bounce by!"), false);
        int count = 3 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            SlimeEntity slime = (SlimeEntity)EntityType.SLIME.create((World)world);
            if (slime == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            slime.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            slime.setSize(1, true);
            world.spawnEntity((Entity)slime);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Slime - Spawned " + count + " tiny slimes");
    }

    private static void spawnMooshroom(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83c\udf44 A mooshroom appears!"), false);
        MooshroomEntity mooshroom = (MooshroomEntity)EntityType.MOOSHROOM.create((World)world);
        if (mooshroom != null) {
            mooshroom.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)mooshroom);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Mooshroom - Spawned a mooshroom");
    }

    private static void spawnStrider(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83e\uddb5 A strider walks on lava!"), false);
        StriderEntity strider = (StriderEntity)EntityType.STRIDER.create((World)world);
        if (strider != null) {
            strider.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)strider);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Strider - Spawned a strider");
    }

    private static void spawnDolphin(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc2c Dolphins swim nearby!"), false);
        int count = 2 + world.getRandom().nextInt(2);
        for (int i = 0; i < count; ++i) {
            DolphinEntity dolphin = (DolphinEntity)EntityType.DOLPHIN.create((World)world);
            if (dolphin == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            dolphin.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)dolphin);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Dolphin - Spawned " + count + " dolphins");
    }

    private static void spawnOcelot(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udc06 An ocelot appears!"), false);
        OcelotEntity ocelot = (OcelotEntity)EntityType.OCELOT.create((World)world);
        if (ocelot != null) {
            ocelot.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)ocelot);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ocelot - Spawned an ocelot");
    }

    private static void spawnFox(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83e\udd8a A fox appears!"), false);
        FoxEntity fox = (FoxEntity)EntityType.FOX.create((World)world);
        if (fox != null) {
            fox.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)fox);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Fox - Spawned a fox");
    }

    private static void dropCobblestone(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77\ud83e\udea8 Cobblestone drops!"), false);
        ItemStack cobblestoneStack = new ItemStack((ItemConvertible)Items.COBBLESTONE, 64);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, cobblestoneStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Cobblestone - Dropped 64 cobblestone");
    }

    private static void dropSand(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\u23f3 Sand drops!"), false);
        ItemStack sandStack = new ItemStack((ItemConvertible)Items.SAND, 64);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sandStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Sand - Dropped 64 sand");
    }

    private static void dropKelp(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a72\ud83c\udf3f Kelp drops!"), false);
        ItemStack kelpStack = new ItemStack((ItemConvertible)Items.KELP, 64);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, kelpStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Kelp - Dropped 64 kelp");
    }

    private static void dropIce(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2744\ufe0f Ice blocks drop!"), false);
        Item[] iceTypes = new Item[]{Items.ICE, Items.PACKED_ICE, Items.BLUE_ICE};
        Item randomIce = iceTypes[world.getRandom().nextInt(iceTypes.length)];
        int count = 16 + world.getRandom().nextInt(17);
        ItemStack iceStack = new ItemStack((ItemConvertible)randomIce, count);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, iceStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Drop Ice - Dropped " + count + " ice blocks");
    }

    private static void randomPotion(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83e\uddea A potion appears!"), false);
        Item[] potions = new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.HONEY_BOTTLE, Items.MILK_BUCKET};
        Item randomPotionItem = potions[world.getRandom().nextInt(potions.length)];
        ItemStack potionStack = new ItemStack((ItemConvertible)randomPotionItem, 1);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, potionStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Random Potion - Dropped random potion");
    }

    private static void giveWoodenSword(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\u2694 It's dangerous to go alone! Take this."), false);
        ItemStack woodenSword = new ItemStack((ItemConvertible)Items.WOODEN_SWORD, 1);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, woodenSword);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Give Wooden Sword - Dropped wooden sword with Zelda reference");
    }

    private static void playTntSound(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udca3 *hissss*"), false);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Play TNT Sound - Played TNT fuse sound");
    }

    private static void playExplosionSound(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udca5 BOOM!"), false);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (RegistryEntry)SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 2.0f, 1.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Play Explosion Sound - Played explosion sound");
    }

    private static void teleportSurface(ServerWorld world, BlockPos pos, PlayerEntity player) {
        if (world.getRegistryKey() == World.NETHER) {
            player.sendMessage((Text)Text.literal((String)"\u00a7c\u274c Can't teleport to surface in the Nether!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Teleport Surface - Failed: Player in Nether");
            return;
        }
        if (world.getRegistryKey() == World.END) {
            player.sendMessage((Text)Text.literal((String)"\u00a7c\u274c Can't teleport to surface in the End!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Teleport Surface - Failed: Player in End");
            return;
        }
        BlockPos playerPos = player.getBlockPos();
        BlockPos.Mutable searchPos = new BlockPos.Mutable(playerPos.getX(), world.getTopY() - 1, playerPos.getZ());
        while (searchPos.getY() > world.getBottomY()) {
            BlockPos below = searchPos.down();
            if (world.getBlockState(below).isSolidBlock((BlockView)world, below) && !world.getBlockState((BlockPos)searchPos).isSolidBlock((BlockView)world, (BlockPos)searchPos) && !world.getBlockState(searchPos.up()).isSolidBlock((BlockView)world, searchPos.up()) && world.isSkyVisible((BlockPos)searchPos)) {
                player.teleport((double)searchPos.getX() + 0.5, (double)searchPos.getY(), (double)searchPos.getZ() + 0.5, true);
                player.sendMessage((Text)Text.literal((String)"\u00a7a\u2b06 Teleported to surface!"), false);
                LuckyBlockWorld.LOGGER.info("[Event] Teleport Surface - Teleported player from Y=" + playerPos.getY() + " to Y=" + searchPos.getY());
                return;
            }
            searchPos.move(0, -1, 0);
        }
        player.sendMessage((Text)Text.literal((String)"\u00a7c\u274c Could not find safe surface!"), false);
        LuckyBlockWorld.LOGGER.info("[Event] Teleport Surface - Failed: No safe surface found");
    }

    private static void instantHouse(ServerWorld world, BlockPos pos, PlayerEntity player) {
        int z;
        int x;
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83c\udfe0 A house appears!"), false);
        int sizeX = 5;
        int sizeZ = 5;
        int height = 4;
        int startX = pos.getX() - sizeX / 2;
        int startZ = pos.getZ() - sizeZ / 2;
        int startY = pos.getY();
        for (x = 0; x < sizeX; ++x) {
            for (z = 0; z < sizeZ; ++z) {
                BlockPos floorPos = new BlockPos(startX + x, startY, startZ + z);
                world.setBlockState(floorPos, Blocks.OAK_PLANKS.getDefaultState());
            }
        }
        for (int y = 1; y < height; ++y) {
            for (int x2 = 0; x2 < sizeX; ++x2) {
                for (int z2 = 0; z2 < sizeZ; ++z2) {
                    boolean isEdge;
                    BlockPos wallPos = new BlockPos(startX + x2, startY + y, startZ + z2);
                    boolean bl = isEdge = x2 == 0 || x2 == sizeX - 1 || z2 == 0 || z2 == sizeZ - 1;
                    if (isEdge) {
                        if (y <= 2 && z2 == 0 && x2 == sizeX / 2) {
                            world.setBlockState(wallPos, Blocks.AIR.getDefaultState());
                            continue;
                        }
                        world.setBlockState(wallPos, Blocks.COBBLESTONE.getDefaultState());
                        continue;
                    }
                    world.setBlockState(wallPos, Blocks.AIR.getDefaultState());
                }
            }
        }
        for (x = 0; x < sizeX; ++x) {
            for (z = 0; z < sizeZ; ++z) {
                BlockPos roofPos = new BlockPos(startX + x, startY + height, startZ + z);
                world.setBlockState(roofPos, Blocks.OAK_PLANKS.getDefaultState());
            }
        }
        BlockPos torchPos = new BlockPos(startX + 2, startY + 1, startZ + 2);
        world.setBlockState(torchPos, Blocks.TORCH.getDefaultState());
        BlockPos craftingPos = new BlockPos(startX + 1, startY + 1, startZ + 1);
        world.setBlockState(craftingPos, Blocks.CRAFTING_TABLE.getDefaultState());
        BlockPos chestPos = new BlockPos(startX + 3, startY + 1, startZ + 1);
        world.setBlockState(chestPos, Blocks.CHEST.getDefaultState());
        BlockPos bedPos = new BlockPos(startX + 1, startY + 1, startZ + 3);
        world.setBlockState(bedPos, Blocks.RED_BED.getDefaultState());
        LuckyBlockWorld.LOGGER.info("[Event] Instant House - Built a 5x5x4 house at " + String.valueOf(pos));
    }

    private static void spawnCreeper(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udca3 A charged creeper appears!"), false);
        CreeperEntity creeper = (CreeperEntity)EntityType.CREEPER.create((World)world);
        if (creeper != null) {
            creeper.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            LightningEntity lightning = (LightningEntity)EntityType.LIGHTNING_BOLT.create((World)world);
            if (lightning != null) {
                lightning.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                creeper.onStruckByLightning(world, lightning);
            }
            world.spawnEntity((Entity)creeper);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Creeper - Spawned charged creeper");
    }

    private static void spawnZombies(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83e\udddf Zombies surround you!"), false);
        int count = 3 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            ZombieEntity zombie = (ZombieEntity)EntityType.ZOMBIE.create((World)world);
            if (zombie == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 4.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 4.0;
            zombie.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)zombie);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Zombies - Spawned " + count + " zombies");
    }

    private static void spawnSilverfish(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc1b Silverfish infestation!"), false);
        int count = 10 + world.getRandom().nextInt(6);
        for (int i = 0; i < count; ++i) {
            SilverfishEntity silverfish = (SilverfishEntity)EntityType.SILVERFISH.create((World)world);
            if (silverfish == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            silverfish.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)silverfish);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Silverfish - Spawned " + count + " silverfish");
    }

    private static void spawnBabyZombies(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc76 Fast baby zombies attack!"), false);
        int count = 3 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            ZombieEntity zombie = (ZombieEntity)EntityType.ZOMBIE.create((World)world);
            if (zombie == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            zombie.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            zombie.setBaby(true);
            world.spawnEntity((Entity)zombie);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Baby Zombies - Spawned " + count + " baby zombies");
    }

    private static void spawnBlazes(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd25 Blazes appear!"), false);
        int count = 3;
        for (int i = 0; i < count; ++i) {
            BlazeEntity blaze = (BlazeEntity)EntityType.BLAZE.create((World)world);
            if (blaze == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetY = 1.0 + world.getRandom().nextDouble();
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            blaze.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)blaze);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Blazes - Spawned " + count + " blazes");
    }

    private static void spawnWitch(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83e\uddd9 A witch attacks!"), false);
        WitchEntity witch = (WitchEntity)EntityType.WITCH.create((World)world);
        if (witch != null) {
            witch.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)witch);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Witch - Spawned a witch");
    }

    private static void spawnVex(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc7b Vexes phase through walls!"), false);
        int count = 5 + world.getRandom().nextInt(6);
        for (int i = 0; i < count; ++i) {
            VexEntity vex = (VexEntity)EntityType.VEX.create((World)world);
            if (vex == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 4.0;
            double offsetY = world.getRandom().nextDouble() * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 4.0;
            vex.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)vex);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Vex - Spawned " + count + " vexes");
    }

    private static void spawnMagmaCubes(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udfe5 Magma cubes bounce!"), false);
        int count = 3 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            MagmaCubeEntity magmaCube = (MagmaCubeEntity)EntityType.MAGMA_CUBE.create((World)world);
            if (magmaCube == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            magmaCube.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            magmaCube.setSize(2, true);
            world.spawnEntity((Entity)magmaCube);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Magma Cubes - Spawned " + count + " magma cubes");
    }

    private static void spawnDrowned(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83e\udddf\u200d\u2642\ufe0f Drowned with tridents!"), false);
        int count = 2 + world.getRandom().nextInt(3);
        for (int i = 0; i < count; ++i) {
            DrownedEntity drowned = (DrownedEntity)EntityType.DROWNED.create((World)world);
            if (drowned == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            drowned.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            drowned.setStackInHand(Hand.MAIN_HAND, new ItemStack((ItemConvertible)Items.TRIDENT));
            world.spawnEntity((Entity)drowned);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Drowned - Spawned " + count + " drowned");
    }

    private static void spawnSkeletonHorse(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc0e Skeleton trap horses!"), false);
        for (int i = 0; i < 4; ++i) {
            SkeletonHorseEntity skeletonHorse = (SkeletonHorseEntity)EntityType.SKELETON_HORSE.create((World)world);
            if (skeletonHorse == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            skeletonHorse.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)skeletonHorse);
            SkeletonEntity skeleton = (SkeletonEntity)EntityType.SKELETON.create((World)world);
            if (skeleton == null) continue;
            skeleton.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            skeleton.startRiding((Entity)skeletonHorse);
            world.spawnEntity((Entity)skeleton);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Skeleton Horse - Spawned 4 skeleton horses with riders");
    }

    private static void spawnPiglinBrutes(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc37 Piglin brutes attack!"), false);
        int count = 2 + world.getRandom().nextInt(2);
        for (int i = 0; i < count; ++i) {
            PiglinBruteEntity piglinBrute = (PiglinBruteEntity)EntityType.PIGLIN_BRUTE.create((World)world);
            if (piglinBrute == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 3.0;
            piglinBrute.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)piglinBrute);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Piglin Brutes - Spawned " + count + " piglin brutes");
    }

    private static void spawnGhasts(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc7b Ghasts appear!"), false);
        int count = 2;
        for (int i = 0; i < count; ++i) {
            GhastEntity ghast = (GhastEntity)EntityType.GHAST.create((World)world);
            if (ghast == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 6.0;
            double offsetY = 3.0 + world.getRandom().nextDouble() * 3.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 6.0;
            ghast.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)ghast);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ghasts - Spawned " + count + " ghasts");
    }

    private static void spawnEndermites(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udc1b Endermite swarm!"), false);
        int count = 8 + world.getRandom().nextInt(5);
        for (int i = 0; i < count; ++i) {
            EndermiteEntity endermite = (EndermiteEntity)EntityType.ENDERMITE.create((World)world);
            if (endermite == null) continue;
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 2.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 2.0;
            endermite.refreshPositionAndAngles((double)pos.getX() + 0.5 + offsetX, (double)pos.getY(), (double)pos.getZ() + 0.5 + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)endermite);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Endermites - Spawned " + count + " endermites");
    }

    private static void poisonCloud(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\u2620 Poison cloud!"), false);
        AreaEffectCloudEntity cloud = (AreaEffectCloudEntity)EntityType.AREA_EFFECT_CLOUD.create((World)world);
        if (cloud != null) {
            cloud.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            cloud.addEffect(new StatusEffectInstance(StatusEffects.POISON, 100, 1));
            cloud.setRadius(3.0f);
            cloud.setDuration(200);
            cloud.setRadiusOnUse(-0.5f);
            cloud.setWaitTime(10);
            world.spawnEntity((Entity)cloud);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Poison Cloud - Spawned lingering poison cloud");
    }

    private static void itemScatter(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udca8 Your items scatter everywhere!"), false);
        int itemsScattered = 0;
        for (int i = 0; i < player.getInventory().size(); ++i) {
            ItemStack stack = player.getInventory().getStack(i);
            if (stack.isEmpty()) continue;
            player.getInventory().setStack(i, ItemStack.EMPTY);
            ItemEntity itemEntity = new ItemEntity((World)world, player.getX(), player.getY() + 0.5, player.getZ(), stack);
            double velocityX = world.getRandom().nextDouble() * 0.5 - 0.25;
            double velocityY = world.getRandom().nextDouble() * 0.4 + 0.1;
            double velocityZ = world.getRandom().nextDouble() * 0.5 - 0.25;
            itemEntity.setVelocity(velocityX, velocityY, velocityZ);
            world.spawnEntity((Entity)itemEntity);
            ++itemsScattered;
        }
        LuckyBlockWorld.LOGGER.info("[Event] Item Scatter - Scattered " + itemsScattered + " items from player inventory");
    }

    private static void hungerDrain(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83c\udf56 You feel starving!"), false);
        player.getHungerManager().setFoodLevel(0);
        player.getHungerManager().setSaturationLevel(0.0f);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.HUNGER, 600, 2));
        LuckyBlockWorld.LOGGER.info("[Event] Hunger Drain - Drained all hunger and added hunger effect");
    }

    private static void cobwebTrap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd78 You're trapped in cobwebs!"), false);
        BlockPos playerPos = player.getBlockPos();
        int cobwebsPlaced = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos targetPos = playerPos.add(x, y, z);
                    BlockState currentState = world.getBlockState(targetPos);
                    if (!currentState.isAir() && !currentState.isReplaceable()) continue;
                    world.setBlockState(targetPos, Blocks.COBWEB.getDefaultState(), 3);
                    ++cobwebsPlaced;
                }
            }
        }
        LuckyBlockWorld.LOGGER.info("[Event] Cobweb Trap - Placed " + cobwebsPlaced + " cobwebs around player");
    }

    private static void blindnessEffect(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a78\ud83d\udc41 You can't see anything!"), false);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.BLINDNESS, 600, 0));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.DARKNESS, 600, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Blindness Effect - Applied blindness and darkness for 30 seconds");
    }

    private static void armorDamage(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udee1 Your armor is damaged!"), false);
        int damagedPieces = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack armorPiece = (ItemStack)player.getInventory().armor.get(i);
            if (armorPiece.isEmpty() || !armorPiece.isDamageable()) continue;
            int maxDamage = armorPiece.getMaxDamage();
            int damageAmount = (int)((double)maxDamage * (0.5 + (double)world.getRandom().nextFloat() * 0.25));
            armorPiece.damage(damageAmount, (LivingEntity)player, EquipmentSlot.values()[i + 2]);
            ++damagedPieces;
        }
        if (damagedPieces > 0) {
            LuckyBlockWorld.LOGGER.info("[Event] Armor Damage - Damaged " + damagedPieces + " armor pieces");
        } else {
            player.sendMessage((Text)Text.literal((String)"\u00a77You have no armor to damage!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Armor Damage - Player had no armor equipped");
        }
    }

    private static void slowMining(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\u26cf Your mining speed is reduced!"), false);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.MINING_FATIGUE, 1200, 2));
        LuckyBlockWorld.LOGGER.info("[Event] Slow Mining - Applied Mining Fatigue III for 1 minute");
    }

    private static void randomDebuff(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\ud83e\uddea Random debuff applied!"), false);
        RegistryEntry[] debuffs = new RegistryEntry[]{StatusEffects.SLOWNESS, StatusEffects.WEAKNESS, StatusEffects.POISON, StatusEffects.WITHER, StatusEffects.NAUSEA, StatusEffects.HUNGER, StatusEffects.MINING_FATIGUE, StatusEffects.LEVITATION, StatusEffects.UNLUCK};
        int debuffCount = 1 + world.getRandom().nextInt(3);
        for (int i = 0; i < debuffCount; ++i) {
            RegistryEntry randomDebuff = debuffs[world.getRandom().nextInt(debuffs.length)];
            int duration = 300 + world.getRandom().nextInt(600);
            int amplifier = world.getRandom().nextInt(3);
            player.addStatusEffect(new StatusEffectInstance(randomDebuff, duration, amplifier));
        }
        LuckyBlockWorld.LOGGER.info("[Event] Random Debuff - Applied " + debuffCount + " random negative effects");
    }

    private static void pitfall(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd73 The ground gives way beneath you!"), false);
        BlockPos playerPos = player.getBlockPos();
        int blocksCleared = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y >= -10; --y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos targetPos = playerPos.add(x, y, z);
                    BlockState currentState = world.getBlockState(targetPos);
                    if (currentState.isAir() || currentState.isOf(Blocks.BEDROCK) || currentState.isOf(Blocks.BARRIER) || !(currentState.getHardness((BlockView)world, targetPos) >= 0.0f)) continue;
                    world.setBlockState(targetPos, Blocks.AIR.getDefaultState(), 3);
                    ++blocksCleared;
                }
            }
        }
        LuckyBlockWorld.LOGGER.info("[Event] Pitfall - Cleared " + blocksCleared + " blocks creating pit below player");
    }

    private static void inventoryLock(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd12 Your inventory is locked!"), false);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.SLOWNESS, 600, 128, false, false));
        LuckyBlockWorld.LOGGER.info("[Event] Inventory Lock - Prevented inventory access for 30 seconds");
    }

    private static void fireCharge(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd25 Incoming fire charge!"), false);
        Vec3d spawnPos = Vec3d.ofCenter((Vec3i)pos).add(0.0, 1.5, 0.0);
        Vec3d playerPos = player.getPos().add(0.0, (double)(player.getHeight() / 2.0f), 0.0);
        Vec3d direction = playerPos.subtract(spawnPos).normalize();
        SmallFireballEntity fireball = (SmallFireballEntity)EntityType.SMALL_FIREBALL.create((World)world);
        if (fireball != null) {
            fireball.setPosition(spawnPos);
            fireball.setVelocity(direction.x, direction.y, direction.z);
            world.spawnEntity((Entity)fireball);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Fire Charge - Launched fire charge at player");
    }

    private static void enchantmentSteal(ServerWorld world, BlockPos pos, PlayerEntity player) {
        ItemStack stack;
        int i;
        player.sendMessage((Text)Text.literal((String)"\u00a7c\u2728 Your enchantments are fading!"), false);
        ArrayList<ItemStack> enchantedItems = new ArrayList<ItemStack>();
        for (i = 0; i < player.getInventory().main.size(); ++i) {
            stack = (ItemStack)player.getInventory().main.get(i);
            if (stack.isEmpty() || !stack.hasEnchantments()) continue;
            enchantedItems.add(stack);
        }
        for (i = 0; i < player.getInventory().armor.size(); ++i) {
            stack = (ItemStack)player.getInventory().armor.get(i);
            if (stack.isEmpty() || !stack.hasEnchantments()) continue;
            enchantedItems.add(stack);
        }
        for (i = 0; i < player.getInventory().offHand.size(); ++i) {
            stack = (ItemStack)player.getInventory().offHand.get(i);
            if (stack.isEmpty() || !stack.hasEnchantments()) continue;
            enchantedItems.add(stack);
        }
        if (enchantedItems.isEmpty()) {
            player.sendMessage((Text)Text.literal((String)"\u00a77...but you have no enchantments to steal!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Enchantment Steal - No enchanted items found");
            return;
        }
        int enchantmentsRemoved = 0;
        int maxAttempts = 50;
        for (int attempts = 0; enchantmentsRemoved < 3 && attempts < maxAttempts; ++attempts) {
            ItemEnchantmentsComponent enchantments;
            ArrayList enchantmentList;
            ItemStack randomItem = (ItemStack)enchantedItems.get(world.random.nextInt(enchantedItems.size()));
            if (!randomItem.hasEnchantments() || (enchantmentList = new ArrayList((enchantments = randomItem.getEnchantments()).getEnchantments())).isEmpty()) continue;
            RegistryEntry randomEnchantment = (RegistryEntry)enchantmentList.get(world.random.nextInt(enchantmentList.size()));
            ItemEnchantmentsComponent.Builder builder = new ItemEnchantmentsComponent.Builder(enchantments);
            builder.remove(entry -> entry.equals((Object)randomEnchantment));
            randomItem.set(DataComponentTypes.ENCHANTMENTS, (Object)builder.build());
            ++enchantmentsRemoved;
            if (randomItem.hasEnchantments()) continue;
            enchantedItems.remove(randomItem);
            if (!enchantedItems.isEmpty()) continue;
            break;
        }
        player.sendMessage((Text)Text.literal((String)("\u00a7c" + enchantmentsRemoved + " enchantment(s) were stolen!")), false);
        LuckyBlockWorld.LOGGER.info("[Event] Enchantment Steal - Removed " + enchantmentsRemoved + " enchantments from player's items");
    }

    private static void dropGravel(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77\ud83d\udc80 Watch out above!"), false);
        BlockPos playerPos = player.getBlockPos();
        BlockPos spawnPos = playerPos.up(10);
        for (int i = 10; i >= 1; --i) {
            BlockPos checkPos = playerPos.up(i);
            BlockState state = world.getBlockState(checkPos);
            if (!state.isAir() && !state.isReplaceable()) continue;
            spawnPos = checkPos;
            break;
        }
        int gravelSpawned = 0;
        for (int i = 0; i < 10; ++i) {
            BlockPos gravelPos = spawnPos.up(i);
            world.setBlockState(gravelPos, Blocks.GRAVEL.getDefaultState(), 3);
            FallingBlockEntity.spawnFromBlock((World)world, (BlockPos)gravelPos, (BlockState)world.getBlockState(gravelPos));
            world.setBlockState(gravelPos, Blocks.AIR.getDefaultState(), 3);
            ++gravelSpawned;
        }
        LuckyBlockWorld.LOGGER.info("[Event] Drop Gravel - Spawned " + gravelSpawned + " falling gravel blocks above player");
    }

    private static void levitationTrap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\u2728 You feel lighter than air!"), false);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.LEVITATION, 600, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Levitation Trap - Applied Levitation for 30 seconds");
    }

    private static void spawnWither(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc80 A WITHER HAS BEEN SUMMONED!"), false);
        WitherEntity wither = (WitherEntity)EntityType.WITHER.create((World)world);
        if (wither != null) {
            wither.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)(pos.getY() + 2), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)wither);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Wither - Spawned Wither boss");
    }

    private static void spawnArmy(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\u2694 An army approaches!"), false);
        int mobCount = 10 + world.random.nextInt(6);
        EntityType[] mobTypes = new EntityType[]{EntityType.ZOMBIE, EntityType.SKELETON, EntityType.CREEPER, EntityType.SPIDER, EntityType.ZOMBIE_VILLAGER};
        for (int i = 0; i < mobCount; ++i) {
            EntityType mobType = mobTypes[world.random.nextInt(mobTypes.length)];
            Entity mob = mobType.create((World)world);
            if (mob == null) continue;
            double offsetX = (world.random.nextDouble() - 0.5) * 10.0;
            double offsetZ = (world.random.nextDouble() - 0.5) * 10.0;
            mob.refreshPositionAndAngles((double)pos.getX() + offsetX, (double)(pos.getY() + 1), (double)pos.getZ() + offsetZ, 0.0f, 0.0f);
            world.spawnEntity(mob);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Army - Spawned " + mobCount + " hostile mobs");
    }

    private static void spawnElderGuardian(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc1f An Elder Guardian emerges!"), false);
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)EntityType.ELDER_GUARDIAN.create((World)world);
        if (elderGuardian != null) {
            elderGuardian.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)elderGuardian);
            player.addStatusEffect(new StatusEffectInstance(StatusEffects.MINING_FATIGUE, 6000, 2));
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Elder Guardian - Spawned Elder Guardian with Mining Fatigue");
    }

    private static void spawnChargedCreepers(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\u26a1 Charged creepers surround you!"), false);
        int creeperCount = 5 + world.random.nextInt(3);
        double angleStep = Math.PI * 2 / (double)creeperCount;
        for (int i = 0; i < creeperCount; ++i) {
            CreeperEntity creeper = (CreeperEntity)EntityType.CREEPER.create((World)world);
            if (creeper == null || !(creeper instanceof CreeperEntity)) continue;
            CreeperEntity creeperEntity = creeper;
            double angle = (double)i * angleStep;
            double radius = 3.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            creeperEntity.refreshPositionAndAngles((double)pos.getX() + offsetX, (double)(pos.getY() + 1), (double)pos.getZ() + offsetZ, 0.0f, 0.0f);
            LightningEntity lightning = (LightningEntity)EntityType.LIGHTNING_BOLT.create((World)world);
            if (lightning != null) {
                lightning.refreshPositionAndAngles(creeperEntity.getX(), creeperEntity.getY(), creeperEntity.getZ(), 0.0f, 0.0f);
                world.spawnEntity((Entity)lightning);
            }
            world.spawnEntity((Entity)creeperEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Charged Creepers - Spawned " + creeperCount + " charged creepers");
    }

    private static void invertControls(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udd04 Your controls are reversed!"), false);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.NAUSEA, 600, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Invert Controls - Reversed WASD controls for 30 seconds");
    }

    private static void spawnWarden(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc80 The Warden awakens!"), false);
        WardenEntity warden = (WardenEntity)EntityType.WARDEN.create((World)world);
        if (warden != null) {
            warden.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)warden);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Warden - Spawned Warden from Deep Dark");
    }

    private static void inventoryShuffleTimer(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udd00 Your inventory will shuffle repeatedly!"), false);
        int i = 1;
        while (i <= 12) {
            int shuffleCount = i++;
            world.getServer().execute(() -> world.getServer().execute(() -> LuckyEventHandler.scheduleInventoryShuffle(world, player, shuffleCount * 200)));
        }
        LuckyBlockWorld.LOGGER.info("[Event] Inventory Shuffle Timer - Scheduled 12 inventory shuffles over 2 minutes");
    }

    private static void scheduleInventoryShuffle(final ServerWorld world, final PlayerEntity player, final int delayTicks) {
        new Object(){
            int ticksRemaining;
            {
                this.ticksRemaining = delayTicks;
            }

            void schedule() {
                world.getServer().execute(() -> {
                    if (this.ticksRemaining > 0) {
                        --this.ticksRemaining;
                        this.schedule();
                    } else if (player.isAlive()) {
                        LuckyEventHandler.shuffleInventory(player);
                        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83d\udd00 Your inventory shuffled!"), true);
                    }
                });
            }
        }.schedule();
    }

    private static void shuffleInventory(PlayerEntity player) {
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = 0; i < player.getInventory().main.size(); ++i) {
            ItemStack stack = (ItemStack)player.getInventory().main.get(i);
            items.add(stack.copy());
        }
        Collections.shuffle(items);
        for (i = 0; i < items.size() && i < player.getInventory().main.size(); ++i) {
            player.getInventory().main.set(i, (Object)((ItemStack)items.get(i)));
        }
    }

    private static void spawnRavagers(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc17 Ravagers charge in!"), false);
        int ravagerCount = 3 + world.random.nextInt(2);
        for (int i = 0; i < ravagerCount; ++i) {
            RavagerEntity ravager = (RavagerEntity)EntityType.RAVAGER.create((World)world);
            if (ravager == null) continue;
            double offsetX = (world.random.nextDouble() - 0.5) * 6.0;
            double offsetZ = (world.random.nextDouble() - 0.5) * 6.0;
            ravager.refreshPositionAndAngles((double)pos.getX() + offsetX, (double)(pos.getY() + 1), (double)pos.getZ() + offsetZ, 0.0f, 0.0f);
            world.spawnEntity((Entity)ravager);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ravagers - Spawned " + ravagerCount + " ravagers");
    }

    private static void healthCap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc94 Your health is severely limited!"), false);
        player.setHealth(2.0f);
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.WITHER, 1200, 0, false, true));
        LuckyEventHandler.scheduleHealthCap(world, player, 1200);
        LuckyBlockWorld.LOGGER.info("[Event] Health Cap - Reduced max health to 1 heart for 60 seconds");
    }

    private static void scheduleHealthCap(final ServerWorld world, final PlayerEntity player, final int totalTicks) {
        new Object(){
            int ticksRemaining;
            {
                this.ticksRemaining = totalTicks;
            }

            void schedule() {
                world.getServer().execute(() -> {
                    if (this.ticksRemaining > 0 && player.isAlive()) {
                        if (player.getHealth() > 2.0f) {
                            player.setHealth(2.0f);
                        }
                        --this.ticksRemaining;
                        this.schedule();
                    }
                });
            }
        }.schedule();
    }

    private static void spawnInvisibleCreepers(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc7b You hear hissing..."), false);
        int creeperCount = 5 + world.random.nextInt(4);
        for (int i = 0; i < creeperCount; ++i) {
            CreeperEntity creeper = (CreeperEntity)EntityType.CREEPER.create((World)world);
            if (creeper == null) continue;
            double offsetX = (world.random.nextDouble() - 0.5) * 8.0;
            double offsetZ = (world.random.nextDouble() - 0.5) * 8.0;
            creeper.refreshPositionAndAngles((double)pos.getX() + offsetX, (double)(pos.getY() + 1), (double)pos.getZ() + offsetZ, 0.0f, 0.0f);
            creeper.addStatusEffect(new StatusEffectInstance(StatusEffects.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
            world.spawnEntity((Entity)creeper);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Invisible Creepers - Spawned " + creeperCount + " invisible creepers");
    }

    private static void experienceDrain(ServerWorld world, BlockPos pos, PlayerEntity player) {
        int levelsLost = player.experienceLevel;
        player.sendMessage((Text)Text.literal((String)"\u00a74\u2728 All your experience vanishes!"), false);
        player.experienceLevel = 0;
        player.experienceProgress = 0.0f;
        player.totalExperience = 0;
        LuckyBlockWorld.LOGGER.info("[Event] Experience Drain - Drained " + levelsLost + " XP levels from player");
    }

    private static void spawnAngryBees(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc1d A swarm of angry bees!"), false);
        int beeCount = 20 + world.random.nextInt(11);
        for (int i = 0; i < beeCount; ++i) {
            BeeEntity bee = (BeeEntity)EntityType.BEE.create((World)world);
            if (bee == null || !(bee instanceof BeeEntity)) continue;
            BeeEntity beeEntity = bee;
            double offsetX = (world.random.nextDouble() - 0.5) * 6.0;
            double offsetY = world.random.nextDouble() * 3.0;
            double offsetZ = (world.random.nextDouble() - 0.5) * 6.0;
            beeEntity.refreshPositionAndAngles((double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, 0.0f, 0.0f);
            beeEntity.setTarget((LivingEntity)player);
            world.spawnEntity((Entity)beeEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Angry Bees - Spawned " + beeCount + " angry bees");
    }

    private static void netherPortalTrap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udd25 You're being pulled into the Nether!"), false);
        ServerWorld netherWorld = world.getServer().getWorld(RegistryKey.of((RegistryKey)RegistryKeys.WORLD, (Identifier)RegistryKey.of((RegistryKey)RegistryKeys.WORLD, (Identifier)Identifier.of((String)"minecraft", (String)"the_nether")).getValue()));
        if (netherWorld == null) {
            player.sendMessage((Text)Text.literal((String)"\u00a77...but the portal fails to open!"), false);
            LuckyBlockWorld.LOGGER.warn("[Event] Nether Portal Trap - Nether dimension not found!");
            return;
        }
        double netherX = player.getX() / 8.0;
        double netherY = Math.max(32.0, Math.min(player.getY(), 120.0));
        double netherZ = player.getZ() / 8.0;
        player.teleport(netherWorld, netherX, netherY, netherZ, Set.of(), player.getYaw(), player.getPitch());
        LuckyBlockWorld.LOGGER.info("[Event] Nether Portal Trap - Teleported player to Nether at ({}, {}, {})", new Object[]{netherX, netherY, netherZ});
    }

    private static void itemVoid(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udd73 Your items are slowly vanishing!"), false);
        int i = 1;
        while (i <= 12) {
            int voidCount = i++;
            LuckyEventHandler.scheduleItemVoid(world, player, voidCount * 100);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Item Void - Scheduled 12 item voids over 1 minute");
    }

    private static void scheduleItemVoid(final ServerWorld world, final PlayerEntity player, final int delayTicks) {
        new Object(){
            int ticksRemaining;
            {
                this.ticksRemaining = delayTicks;
            }

            void schedule() {
                world.getServer().execute(() -> {
                    if (this.ticksRemaining > 0) {
                        --this.ticksRemaining;
                        this.schedule();
                    } else if (player.isAlive()) {
                        LuckyEventHandler.voidOneStackableItem(player);
                    }
                });
            }
        }.schedule();
    }

    private static void voidOneStackableItem(PlayerEntity player) {
        ItemStack stack;
        ArrayList<Integer> stackableSlots = new ArrayList<Integer>();
        for (int i = 0; i < player.getInventory().main.size(); ++i) {
            stack = (ItemStack)player.getInventory().main.get(i);
            if (stack.isEmpty() || stack.getMaxCount() != 64 || stack.getCount() <= 0) continue;
            stackableSlots.add(i);
        }
        if (stackableSlots.isEmpty()) {
            return;
        }
        int randomSlot = (Integer)stackableSlots.get(player.getWorld().random.nextInt(stackableSlots.size()));
        stack = (ItemStack)player.getInventory().main.get(randomSlot);
        stack.decrement(1);
        player.sendMessage((Text)Text.literal((String)("\u00a77-1 " + stack.getName().getString())), true);
        LuckyBlockWorld.LOGGER.info("[Event] Item Void - Removed 1x {} from player inventory", (Object)stack.getName().getString());
    }

    private static void obsidianTomb(ServerWorld world, BlockPos pos, PlayerEntity player) {
        int z;
        int y;
        int x;
        player.sendMessage((Text)Text.literal((String)"\u00a74\u26b0 You are entombed in obsidian!"), false);
        BlockPos playerPos = player.getBlockPos();
        for (x = -1; x <= 1; ++x) {
            for (y = 0; y <= 2; ++y) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos clearPos = playerPos.add(x, y, z);
                    world.setBlockState(clearPos, Blocks.AIR.getDefaultState(), 3);
                }
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (y = 0; y <= 2; ++y) {
                for (z = -1; z <= 1; ++z) {
                    boolean isEdge;
                    boolean bl = isEdge = x == -1 || x == 1 || y == 0 || y == 2 || z == -1 || z == 1;
                    if (!isEdge) continue;
                    BlockPos tombPos = playerPos.add(x, y, z);
                    world.setBlockState(tombPos, Blocks.OBSIDIAN.getDefaultState(), 3);
                }
            }
        }
        LuckyBlockWorld.LOGGER.info("[Event] Obsidian Tomb - Encased player in obsidian");
    }

    private static void equipmentShatter(ServerWorld world, BlockPos pos, PlayerEntity player) {
        ItemStack armor;
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udca5 Your equipment shatters!"), false);
        ArrayList<Integer> equippedSlots = new ArrayList<Integer>();
        for (int i = 0; i < player.getInventory().armor.size(); ++i) {
            armor = (ItemStack)player.getInventory().armor.get(i);
            if (armor.isEmpty()) continue;
            equippedSlots.add(i);
        }
        if (equippedSlots.isEmpty()) {
            player.sendMessage((Text)Text.literal((String)"\u00a77...but you have no armor equipped!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Equipment Shatter - No armor equipped");
            return;
        }
        int randomSlot = (Integer)equippedSlots.get(world.random.nextInt(equippedSlots.size()));
        armor = (ItemStack)player.getInventory().armor.get(randomSlot);
        String armorName = armor.getName().getString();
        armor.setDamage(armor.getMaxDamage());
        player.getInventory().armor.set(randomSlot, (Object)ItemStack.EMPTY);
        player.sendMessage((Text)Text.literal((String)("\u00a7c" + armorName + " shattered!")), false);
        world.playSound(null, player.getBlockPos(), SoundEvents.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
        LuckyBlockWorld.LOGGER.info("[Event] Equipment Shatter - Broke " + armorName);
    }

    private static void spawnSoulSandTrap(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83d\udc7b Soul sand consumes the ground!"), false);
        BlockPos playerPos = player.getBlockPos();
        int radius = 5;
        int blocksReplaced = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos soulSandPos;
                BlockState currentState;
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius) || (currentState = world.getBlockState(soulSandPos = playerPos.add(x, 0, z))).isAir() || !(currentState.getHardness((BlockView)world, soulSandPos) >= 0.0f) || currentState.isOf(Blocks.BEDROCK) || currentState.isOf(Blocks.BARRIER)) continue;
                world.setBlockState(soulSandPos, Blocks.SOUL_SAND.getDefaultState(), 3);
                ++blocksReplaced;
            }
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Soul Sand Trap - Replaced " + blocksReplaced + " blocks with soul sand");
    }

    private static void waterBreathingRemoval(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a74\ud83c\udf0a You're being pulled underwater!"), false);
        BlockPos playerPos = player.getBlockPos();
        BlockPos underwaterPos = null;
        int searchRadius = 50;
        block0: for (int radius = 1; radius <= searchRadius && underwaterPos == null; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) != radius && Math.abs(z) != radius) continue;
                    for (int y = 10; y >= -20; --y) {
                        BlockPos abovePos;
                        BlockState aboveState;
                        BlockPos checkPos = playerPos.add(x, y, z);
                        BlockState state = world.getBlockState(checkPos);
                        if (!state.isOf(Blocks.WATER) || !(aboveState = world.getBlockState(abovePos = checkPos.up())).isOf(Blocks.WATER)) continue;
                        underwaterPos = checkPos;
                        break;
                    }
                    if (underwaterPos != null) break;
                }
                if (underwaterPos != null) continue block0;
            }
        }
        if (underwaterPos != null) {
            player.teleport((double)underwaterPos.getX() + 0.5, (double)underwaterPos.getY(), (double)underwaterPos.getZ() + 0.5, true);
            LuckyBlockWorld.LOGGER.info("[Event] Water Breathing Removal - Teleported player underwater at {}", underwaterPos);
        } else {
            player.sendMessage((Text)Text.literal((String)"\u00a77...but the water fails to pull you in!"), false);
            LuckyBlockWorld.LOGGER.info("[Event] Water Breathing Removal - No water found within {} blocks", (Object)searchRadius);
        }
    }

    private static void spawnDiamonds(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc8e Diamonds!"), false);
        int count = world.getRandom().nextInt(3) + 1;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.DIAMOND, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Diamonds ({})", (Object)count);
    }

    private static void enchantGear(ServerWorld world, BlockPos pos, PlayerEntity player) {
        RegistryKey mendingKey;
        Optional mendingEntry;
        RegistryKey unbreakingKey;
        Optional unbreakingEntry;
        int currentLevel;
        RegistryKey fortuneKey;
        Optional fortuneEntry;
        int currentLevel2;
        ItemStack heldItem = player.getMainHandStack();
        if (heldItem.isEmpty() || !heldItem.isEnchantable()) {
            LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Player not holding enchantable item, skipping");
            return;
        }
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        boolean isAxe = heldItem.getItem().toString().toLowerCase().contains("axe");
        boolean enchanted = false;
        RegistryKey efficiencyKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.EFFICIENCY.getValue());
        Optional efficiencyEntry = enchantmentRegistry.getEntry(efficiencyKey);
        if (efficiencyEntry.isPresent() && (currentLevel2 = heldItem.getEnchantments().getLevel((RegistryEntry)efficiencyEntry.get())) < 5) {
            heldItem.addEnchantment((RegistryEntry)efficiencyEntry.get(), currentLevel2 + 1);
            player.sendMessage((Text)Text.literal((String)("\u00a7b\u2728 Efficiency " + (currentLevel2 + 1) + " applied!")), false);
            enchanted = true;
            LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Applied Efficiency " + (currentLevel2 + 1));
        }
        if (!enchanted && !isAxe && (fortuneEntry = enchantmentRegistry.getEntry(fortuneKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.FORTUNE.getValue()))).isPresent() && (currentLevel = heldItem.getEnchantments().getLevel((RegistryEntry)fortuneEntry.get())) < 3) {
            heldItem.addEnchantment((RegistryEntry)fortuneEntry.get(), currentLevel + 1);
            player.sendMessage((Text)Text.literal((String)("\u00a7b\u2728 Fortune " + (currentLevel + 1) + " applied!")), false);
            enchanted = true;
            LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Applied Fortune " + (currentLevel + 1));
        }
        if (!enchanted && (unbreakingEntry = enchantmentRegistry.getEntry(unbreakingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.UNBREAKING.getValue()))).isPresent() && (currentLevel = heldItem.getEnchantments().getLevel((RegistryEntry)unbreakingEntry.get())) < 3) {
            heldItem.addEnchantment((RegistryEntry)unbreakingEntry.get(), currentLevel + 1);
            player.sendMessage((Text)Text.literal((String)("\u00a7b\u2728 Unbreaking " + (currentLevel + 1) + " applied!")), false);
            enchanted = true;
            LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Applied Unbreaking " + (currentLevel + 1));
        }
        if (!enchanted && (mendingEntry = enchantmentRegistry.getEntry(mendingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.MENDING.getValue()))).isPresent()) {
            currentLevel = heldItem.getEnchantments().getLevel((RegistryEntry)mendingEntry.get());
            if (currentLevel < 1) {
                heldItem.addEnchantment((RegistryEntry)mendingEntry.get(), 1);
                player.sendMessage((Text)Text.literal((String)"\u00a7b\u2728 Mending applied!"), false);
                enchanted = true;
                LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Applied Mending");
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7e\u2728 Your gear is already fully enchanted!"), false);
                LuckyBlockWorld.LOGGER.info("[Event] Enchant Gear - Item already fully enchanted");
            }
        }
    }

    private static void healPlayer(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2764 You feel revitalized!"), false);
        player.setHealth(player.getMaxHealth());
        player.getHungerManager().setFoodLevel(20);
        LuckyBlockWorld.LOGGER.info("[Event] Heal Player");
    }

    private static void spawnExperience(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2b50 Experience!"), false);
        player.addExperience(100 + world.getRandom().nextInt(200));
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Experience");
    }

    private static void giveTools(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u26cf Iron tools!"), false);
        ItemEntity pickaxe = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.IRON_PICKAXE));
        ItemEntity sword = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.IRON_SWORD));
        world.spawnEntity((Entity)pickaxe);
        world.spawnEntity((Entity)sword);
        LuckyBlockWorld.LOGGER.info("[Event] Give Tools");
    }

    private static void spawnEmeralds(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\ud83d\udc9a Emeralds!"), false);
        int count = world.getRandom().nextInt(5) + 2;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.EMERALD, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Emeralds ({})", (Object)count);
    }

    private static void spawnEnchantedBook(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udcd6 Enchanted Book!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        Random random = world.getRandom();
        RegistryKey[] enchantmentKeys = new RegistryKey[]{Enchantments.PROTECTION, Enchantments.FIRE_PROTECTION, Enchantments.BLAST_PROTECTION, Enchantments.PROJECTILE_PROTECTION, Enchantments.FEATHER_FALLING, Enchantments.THORNS, Enchantments.RESPIRATION, Enchantments.AQUA_AFFINITY, Enchantments.DEPTH_STRIDER, Enchantments.FROST_WALKER, Enchantments.SHARPNESS, Enchantments.SMITE, Enchantments.BANE_OF_ARTHROPODS, Enchantments.KNOCKBACK, Enchantments.FIRE_ASPECT, Enchantments.LOOTING, Enchantments.SWEEPING_EDGE, Enchantments.EFFICIENCY, Enchantments.SILK_TOUCH, Enchantments.UNBREAKING, Enchantments.FORTUNE, Enchantments.POWER, Enchantments.PUNCH, Enchantments.FLAME, Enchantments.INFINITY, Enchantments.LUCK_OF_THE_SEA, Enchantments.LURE, Enchantments.LOYALTY, Enchantments.IMPALING, Enchantments.RIPTIDE, Enchantments.CHANNELING, Enchantments.MENDING, Enchantments.SWIFT_SNEAK, Enchantments.SOUL_SPEED};
        ItemStack enchantedBook = new ItemStack((ItemConvertible)Items.ENCHANTED_BOOK);
        RegistryKey enchantKey = enchantmentKeys[random.nextInt(enchantmentKeys.length)];
        Optional enchantEntry = enchantmentRegistry.getEntry(enchantKey);
        if (enchantEntry.isPresent()) {
            int maxLevel = ((Enchantment)((RegistryEntry.Reference)enchantEntry.get()).value()).getMaxLevel();
            int level = random.nextInt(maxLevel) + 1;
            enchantedBook.addEnchantment((RegistryEntry)enchantEntry.get(), level);
        }
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, enchantedBook);
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Enchanted Book - Dropped random enchanted book");
    }

    private static void potionEffects(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2728 Beneficial Potions!"), false);
        int duration = 1200;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.SPEED, duration, 1));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.STRENGTH, duration, 1));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.REGENERATION, duration, 0));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.RESISTANCE, duration, 0));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.FIRE_RESISTANCE, duration, 0));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.NIGHT_VISION, duration, 0));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.HASTE, duration, 1));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.ABSORPTION, duration, 1));
        LuckyBlockWorld.LOGGER.info("[Event] Potion Effects - Applied 8 beneficial effects for 60 seconds");
    }

    private static void spawnIronBlocks(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77\u26d3 Iron Blocks!"), false);
        int count = world.getRandom().nextInt(6) + 3;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.IRON_BLOCK, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Iron Blocks - Dropped {} iron blocks", (Object)count);
    }

    private static void goldenApple(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83c\udf4e Golden Apples!"), false);
        int count = world.getRandom().nextInt(3) + 1;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.GOLDEN_APPLE, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Golden Apple - Dropped {} golden apples", (Object)count);
    }

    private static void spawnHorse(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udc34 Pre-tamed Horse!"), false);
        HorseEntity horse = (HorseEntity)EntityType.HORSE.create((World)world);
        if (horse != null) {
            horse.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            horse.setTame(true);
            horse.setOwnerUuid(player.getUuid());
            horse.getInventory().setStack(0, new ItemStack((ItemConvertible)Items.SADDLE));
            world.spawnEntity((Entity)horse);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Horse - Spawned pre-tamed horse with saddle");
    }

    private static void fireworkShow(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\ud83c\udf86 Fireworks!"), false);
        ItemStack firework = new ItemStack((ItemConvertible)Items.FIREWORK_ROCKET);
        IntArrayList colors = new IntArrayList();
        colors.add(DyeColor.RED.getFireworkColor());
        colors.add(DyeColor.YELLOW.getFireworkColor());
        colors.add(DyeColor.BLUE.getFireworkColor());
        IntArrayList fadeColors = new IntArrayList();
        FireworkExplosionComponent explosion = new FireworkExplosionComponent(FireworkExplosionComponent.Type.LARGE_BALL, (IntList)colors, (IntList)fadeColors, true, true);
        firework.set(DataComponentTypes.FIREWORKS, (Object)new FireworksComponent(2, List.of(explosion)));
        FireworkRocketEntity fireworkEntity = new FireworkRocketEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, firework);
        world.spawnEntity((Entity)fireworkEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Firework Show - Launched firework at block location");
    }

    private static void totemOfUndying(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\u2728 Totem of Undying!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.TOTEM_OF_UNDYING));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Totem of Undying - Dropped totem of undying");
    }

    private static void spawnGolem(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a77\ud83e\udd16 Iron Golem Protector!"), false);
        IronGolemEntity golem = (IronGolemEntity)EntityType.IRON_GOLEM.create((World)world);
        if (golem != null) {
            golem.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            golem.setPlayerCreated(true);
            world.spawnEntity((Entity)golem);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Golem - Spawned Iron Golem protector");
    }

    private static void repairAll(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udd27 All items repaired!"), false);
        int repairedCount = 0;
        for (int i = 0; i < player.getInventory().size(); ++i) {
            ItemStack stack = player.getInventory().getStack(i);
            if (stack.isEmpty() || !stack.isDamaged()) continue;
            stack.setDamage(0);
            ++repairedCount;
        }
        for (ItemStack armorStack : player.getArmorItems()) {
            if (armorStack.isEmpty() || !armorStack.isDamaged()) continue;
            armorStack.setDamage(0);
            ++repairedCount;
        }
        if (repairedCount == 0) {
            player.sendMessage((Text)Text.literal((String)"\u00a7eNo damaged items to repair!"), false);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Repair All - Repaired {} items", (Object)repairedCount);
    }

    private static void spawnAncientDebris(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\ud83d\udd2e Ancient Debris!"), false);
        int count = world.getRandom().nextInt(3) + 1;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.ANCIENT_DEBRIS, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ancient Debris - Dropped {} ancient debris", (Object)count);
    }

    private static void enchantedGoldenApple(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\u2728 Enchanted Golden Apple!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.ENCHANTED_GOLDEN_APPLE));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Enchanted Golden Apple - Dropped enchanted golden apple");
    }

    private static void giveShield(ServerWorld world, BlockPos pos, PlayerEntity player) {
        RegistryKey mendingKey;
        Optional mendingEntry;
        player.sendMessage((Text)Text.literal((String)"\u00a79\ud83d\udee1 Enchanted Shield!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        ItemStack shield = new ItemStack((ItemConvertible)Items.SHIELD);
        RegistryKey unbreakingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.UNBREAKING.getValue());
        Optional unbreakingEntry = enchantmentRegistry.getEntry(unbreakingKey);
        if (unbreakingEntry.isPresent()) {
            shield.addEnchantment((RegistryEntry)unbreakingEntry.get(), 3);
        }
        if ((mendingEntry = enchantmentRegistry.getEntry(mendingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.MENDING.getValue()))).isPresent()) {
            shield.addEnchantment((RegistryEntry)mendingEntry.get(), 1);
        }
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, shield);
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Give Shield - Dropped enchanted shield");
    }

    private static void spawnBookshelves(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83d\udcda Bookshelves!"), false);
        int count = world.getRandom().nextInt(6) + 10;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.BOOKSHELF, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Bookshelves - Dropped {} bookshelves", (Object)count);
    }

    private static void luckyFishing(ServerWorld world, BlockPos pos, PlayerEntity player) {
        RegistryKey unbreakingKey;
        Optional unbreakingEntry;
        RegistryKey mendingKey;
        Optional mendingEntry;
        RegistryKey lureKey;
        Optional lureEntry;
        int level;
        RegistryKey luckKey;
        Optional luckEntry;
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83c\udfa3 Enchanted Fishing Rod!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        Random random = world.getRandom();
        ItemStack fishingRod = new ItemStack((ItemConvertible)Items.FISHING_ROD);
        boolean hasEnchant = false;
        int enchantCount = 0;
        if (random.nextBoolean() && (luckEntry = enchantmentRegistry.getEntry(luckKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.LUCK_OF_THE_SEA.getValue()))).isPresent()) {
            level = random.nextInt(3) + 1;
            fishingRod.addEnchantment((RegistryEntry)luckEntry.get(), level);
            hasEnchant = true;
            ++enchantCount;
        }
        if (random.nextBoolean() && (lureEntry = enchantmentRegistry.getEntry(lureKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.LURE.getValue()))).isPresent()) {
            level = random.nextInt(3) + 1;
            fishingRod.addEnchantment((RegistryEntry)lureEntry.get(), level);
            hasEnchant = true;
            ++enchantCount;
        }
        if (random.nextBoolean() && (mendingEntry = enchantmentRegistry.getEntry(mendingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.MENDING.getValue()))).isPresent()) {
            fishingRod.addEnchantment((RegistryEntry)mendingEntry.get(), 1);
            hasEnchant = true;
            ++enchantCount;
        }
        if (random.nextBoolean() && (unbreakingEntry = enchantmentRegistry.getEntry(unbreakingKey = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.UNBREAKING.getValue()))).isPresent()) {
            level = random.nextInt(3) + 1;
            fishingRod.addEnchantment((RegistryEntry)unbreakingEntry.get(), level);
            hasEnchant = true;
            ++enchantCount;
        }
        if (!hasEnchant) {
            int randomChoice = random.nextInt(4);
            switch (randomChoice) {
                case 0: {
                    RegistryKey luckKey2 = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.LUCK_OF_THE_SEA.getValue());
                    Optional luckEntry2 = enchantmentRegistry.getEntry(luckKey2);
                    if (!luckEntry2.isPresent()) break;
                    fishingRod.addEnchantment((RegistryEntry)luckEntry2.get(), random.nextInt(3) + 1);
                    break;
                }
                case 1: {
                    RegistryKey lureKey2 = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.LURE.getValue());
                    Optional lureEntry2 = enchantmentRegistry.getEntry(lureKey2);
                    if (!lureEntry2.isPresent()) break;
                    fishingRod.addEnchantment((RegistryEntry)lureEntry2.get(), random.nextInt(3) + 1);
                    break;
                }
                case 2: {
                    RegistryKey mendingKey2 = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.MENDING.getValue());
                    Optional mendingEntry2 = enchantmentRegistry.getEntry(mendingKey2);
                    if (!mendingEntry2.isPresent()) break;
                    fishingRod.addEnchantment((RegistryEntry)mendingEntry2.get(), 1);
                    break;
                }
                case 3: {
                    RegistryKey unbreakingKey2 = RegistryKey.of((RegistryKey)RegistryKeys.ENCHANTMENT, (Identifier)Enchantments.UNBREAKING.getValue());
                    Optional unbreakingEntry2 = enchantmentRegistry.getEntry(unbreakingKey2);
                    if (!unbreakingEntry2.isPresent()) break;
                    fishingRod.addEnchantment((RegistryEntry)unbreakingEntry2.get(), random.nextInt(3) + 1);
                }
            }
            enchantCount = 1;
        }
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, fishingRod);
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Lucky Fishing - Dropped fishing rod with {} enchantments", (Object)enchantCount);
    }

    private static void spawnNameTag(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udcdb Name Tags!"), false);
        int count = world.getRandom().nextInt(3) + 2;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.NAME_TAG, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Name Tag - Dropped {} name tags", (Object)count);
    }

    private static void giveSaddle(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83c\udfc7 Saddles and Horse Armor!"), false);
        int saddleCount = world.getRandom().nextInt(2) + 2;
        ItemEntity saddles = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.SADDLE, saddleCount));
        world.spawnEntity((Entity)saddles);
        Item[] armorTypes = new Item[]{Items.IRON_HORSE_ARMOR, Items.GOLDEN_HORSE_ARMOR, Items.DIAMOND_HORSE_ARMOR};
        ItemEntity armor = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)armorTypes[world.getRandom().nextInt(armorTypes.length)]));
        world.spawnEntity((Entity)armor);
        LuckyBlockWorld.LOGGER.info("[Event] Give Saddle - Dropped {} saddles and horse armor", (Object)saddleCount);
    }

    private static void spawnHoney(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83c\udf6f Honey Blocks and Honeycomb!"), false);
        int honeyCount = world.getRandom().nextInt(5) + 4;
        ItemEntity honeyBlocks = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.HONEY_BLOCK, honeyCount));
        world.spawnEntity((Entity)honeyBlocks);
        int honeycombCount = world.getRandom().nextInt(9) + 8;
        ItemEntity honeycomb = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.HONEYCOMB, honeycombCount));
        world.spawnEntity((Entity)honeycomb);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Honey - Dropped {} honey blocks and {} honeycomb", (Object)honeyCount, (Object)honeycombCount);
    }

    private static void spawnEnderPearls(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\ud83d\udd2e Ender Pearls!"), false);
        int count = world.getRandom().nextInt(9) + 8;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.ENDER_PEARL, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ender Pearls - Dropped {} ender pearls", (Object)count);
    }

    private static void spawnRedstone(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7c\u26a1 Redstone Dust!"), false);
        int count = world.getRandom().nextInt(33) + 32;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.REDSTONE, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Redstone - Dropped {} redstone dust", (Object)count);
    }

    private static void spawnQuartz(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7f\u25c7 Nether Quartz!"), false);
        int count = world.getRandom().nextInt(33) + 32;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.QUARTZ, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Quartz - Dropped {} nether quartz", (Object)count);
    }

    private static void spawnGlowstone(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\u2728 Glowstone Blocks!"), false);
        int count = world.getRandom().nextInt(17) + 16;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.GLOWSTONE, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Glowstone - Dropped {} glowstone blocks", (Object)count);
    }

    private static void spawnGoldBlocks(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\u2728 Gold Blocks!"), false);
        int count = world.getRandom().nextInt(4) + 3;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.GOLD_BLOCK, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Gold Blocks - Dropped {} gold blocks", (Object)count);
    }

    private static void absorptionHearts(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\u2764 Absorption Hearts!"), false);
        int duration = 1200;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.ABSORPTION, duration, 3));
        LuckyBlockWorld.LOGGER.info("[Event] Absorption Hearts - Granted Absorption IV for 60 seconds");
    }

    private static void spawnLapis(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc8e Lapis Lazuli!"), false);
        int count = world.getRandom().nextInt(32) + 32;
        ItemStack lapisStack = new ItemStack((ItemConvertible)Items.LAPIS_LAZULI, count);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, lapisStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Lapis - Dropped " + count + " lapis lazuli");
    }

    private static void speedBoost(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u26a1 Speed Boost!"), false);
        int duration = 1200;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.SPEED, duration, 1));
        LuckyBlockWorld.LOGGER.info("[Event] Speed Boost - Granted Speed II for 60 seconds");
    }

    private static void nightVision(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83d\udc41 Night Vision!"), false);
        int duration = 6000;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.NIGHT_VISION, duration, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Night Vision - Granted Night Vision for 5 minutes");
    }

    private static void waterBreathing(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83c\udf0a Water Breathing!"), false);
        int duration = 3600;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.WATER_BREATHING, duration, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Water Breathing - Granted Water Breathing for 3 minutes");
    }

    private static void fireResistance(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83d\udd25 Fire Resistance!"), false);
        int duration = 3600;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.FIRE_RESISTANCE, duration, 0));
        LuckyBlockWorld.LOGGER.info("[Event] Fire Resistance - Granted Fire Resistance for 3 minutes");
    }

    private static void spawnArrows(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7f\ud83c\udff9 Arrows!"), false);
        int count = world.getRandom().nextInt(32) + 32;
        ItemStack arrowStack = new ItemStack((ItemConvertible)Items.ARROW, count);
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, arrowStack);
        world.spawnEntity((Entity)itemEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Arrows - Dropped " + count + " arrows");
    }

    private static void spawnFood(ServerWorld world, BlockPos pos, PlayerEntity player) {
        Item[] foods;
        player.sendMessage((Text)Text.literal((String)"\u00a7e\ud83c\udf56 Cooked Food!"), false);
        for (Item food : foods = new Item[]{Items.COOKED_BEEF, Items.COOKED_PORKCHOP, Items.COOKED_CHICKEN, Items.COOKED_MUTTON, Items.COOKED_SALMON, Items.COOKED_COD, Items.BAKED_POTATO, Items.BREAD}) {
            int count = world.getRandom().nextInt(8) + 4;
            ItemStack foodStack = new ItemStack((ItemConvertible)food, count);
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, foodStack);
            world.spawnEntity((Entity)itemEntity);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Food - Dropped variety of cooked food");
    }

    private static void spawnBrewingStand(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83e\uddea Brewing Stand + Weakness Potion Ingredients!"), false);
        ItemStack brewingStand = new ItemStack((ItemConvertible)Items.BREWING_STAND);
        ItemEntity brewingEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, brewingStand);
        world.spawnEntity((Entity)brewingEntity);
        ItemStack blazePowder = new ItemStack((ItemConvertible)Items.BLAZE_POWDER, 8);
        ItemEntity blazeEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, blazePowder);
        world.spawnEntity((Entity)blazeEntity);
        ItemStack fermentedEye = new ItemStack((ItemConvertible)Items.FERMENTED_SPIDER_EYE, 3);
        ItemEntity eyeEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, fermentedEye);
        world.spawnEntity((Entity)eyeEntity);
        ItemStack netherWart = new ItemStack((ItemConvertible)Items.NETHER_WART, 16);
        ItemEntity wartEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, netherWart);
        world.spawnEntity((Entity)wartEntity);
        ItemStack waterBottles = new ItemStack((ItemConvertible)Items.POTION, 3);
        ItemEntity bottleEntity = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, waterBottles);
        world.spawnEntity((Entity)bottleEntity);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Brewing Stand - Dropped brewing stand with weakness potion ingredients");
    }

    private static void spawnDiamondBlocks(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udc8e\ud83d\udc8e\ud83d\udc8e JACKPOT! Diamond blocks!"), false);
        int count = world.getRandom().nextInt(3) + 2;
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.DIAMOND_BLOCK, count));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Diamond Blocks ({})", (Object)count);
    }

    private static void spawnTreasure(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83c\udfc6 Treasure chest!"), false);
        world.setBlockState(pos, Blocks.CHEST.getDefaultState());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            Optional unbreaking;
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            Random random = world.getRandom();
            Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
            chest.setStack(0, new ItemStack((ItemConvertible)Items.DIAMOND, random.nextInt(6) + 3));
            chest.setStack(1, new ItemStack((ItemConvertible)Items.EMERALD, random.nextInt(9) + 4));
            chest.setStack(2, new ItemStack((ItemConvertible)Items.GOLD_INGOT, random.nextInt(11) + 5));
            if (random.nextFloat() < 0.7f) {
                ItemStack enchantedSword = new ItemStack((ItemConvertible)Items.DIAMOND_SWORD);
                Optional sharpness = enchantmentRegistry.getEntry(Enchantments.SHARPNESS);
                unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING);
                if (sharpness.isPresent()) {
                    enchantedSword.addEnchantment((RegistryEntry)sharpness.get(), 3 + random.nextInt(2));
                }
                if (unbreaking.isPresent()) {
                    enchantedSword.addEnchantment((RegistryEntry)unbreaking.get(), 2);
                }
                chest.setStack(3, enchantedSword);
            }
            if (random.nextFloat() < 0.7f) {
                ItemStack enchantedPickaxe = new ItemStack((ItemConvertible)Items.DIAMOND_PICKAXE);
                Optional efficiency = enchantmentRegistry.getEntry(Enchantments.EFFICIENCY);
                unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING);
                if (efficiency.isPresent()) {
                    enchantedPickaxe.addEnchantment((RegistryEntry)efficiency.get(), 3 + random.nextInt(2));
                }
                if (unbreaking.isPresent()) {
                    enchantedPickaxe.addEnchantment((RegistryEntry)unbreaking.get(), 2);
                }
                chest.setStack(4, enchantedPickaxe);
            }
            int bookCount = random.nextInt(2) + 2;
            RegistryKey[] enchantmentKeys = new RegistryKey[]{Enchantments.PROTECTION, Enchantments.SHARPNESS, Enchantments.EFFICIENCY, Enchantments.FORTUNE, Enchantments.LOOTING};
            for (int i = 0; i < bookCount && i + 5 < 27; ++i) {
                ItemStack enchantedBook = new ItemStack((ItemConvertible)Items.ENCHANTED_BOOK);
                RegistryKey enchantKey = enchantmentKeys[random.nextInt(enchantmentKeys.length)];
                Optional enchantEntry = enchantmentRegistry.getEntry(enchantKey);
                if (enchantEntry.isPresent()) {
                    enchantedBook.addEnchantment((RegistryEntry)enchantEntry.get(), 1 + random.nextInt(2));
                }
                chest.setStack(5 + i, enchantedBook);
            }
            if (random.nextFloat() < 0.5f) {
                chest.setStack(8, new ItemStack((ItemConvertible)Items.GOLDEN_APPLE, random.nextInt(3) + 2));
            }
            if (random.nextFloat() < 0.6f) {
                chest.setStack(9, new ItemStack((ItemConvertible)Items.ENDER_PEARL, random.nextInt(5) + 4));
            }
            if (random.nextFloat() < 0.3f) {
                ItemStack rareItem = switch (random.nextInt(5)) {
                    case 0 -> new ItemStack((ItemConvertible)Items.TOTEM_OF_UNDYING);
                    case 1 -> new ItemStack((ItemConvertible)Items.ELYTRA);
                    case 2 -> new ItemStack((ItemConvertible)Items.TRIDENT);
                    case 3 -> new ItemStack((ItemConvertible)Items.NETHERITE_INGOT, random.nextInt(2) + 1);
                    default -> new ItemStack((ItemConvertible)Items.ENCHANTED_GOLDEN_APPLE);
                };
                chest.setStack(10, rareItem);
            }
            chest.setStack(11, new ItemStack((ItemConvertible)Items.EXPERIENCE_BOTTLE, random.nextInt(4) + 3));
            LuckyBlockWorld.LOGGER.info("[Event] Spawn Treasure - Placed chest with valuable loot at {}", (Object)pos);
        } else {
            LuckyBlockWorld.LOGGER.warn("[Event] Spawn Treasure - Failed to place chest at {}", (Object)pos);
        }
    }

    private static void spawnShulkerBox(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udce6 Shulker box with treasures!"), false);
        world.setBlockState(pos, Blocks.SHULKER_BOX.getDefaultState());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ShulkerBoxBlockEntity) {
            Optional unbreaking;
            ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)blockEntity;
            Random random = world.getRandom();
            Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
            shulkerBox.setStack(0, new ItemStack((ItemConvertible)Items.DIAMOND, random.nextInt(4) + 2));
            shulkerBox.setStack(1, new ItemStack((ItemConvertible)Items.EMERALD, random.nextInt(6) + 3));
            shulkerBox.setStack(2, new ItemStack((ItemConvertible)Items.GOLD_INGOT, random.nextInt(7) + 4));
            if (random.nextFloat() < 0.5f) {
                ItemStack enchantedSword = new ItemStack((ItemConvertible)Items.DIAMOND_SWORD);
                Optional sharpness = enchantmentRegistry.getEntry(Enchantments.SHARPNESS);
                unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING);
                if (sharpness.isPresent()) {
                    enchantedSword.addEnchantment((RegistryEntry)sharpness.get(), 2 + random.nextInt(2));
                }
                if (unbreaking.isPresent()) {
                    enchantedSword.addEnchantment((RegistryEntry)unbreaking.get(), 1 + random.nextInt(2));
                }
                shulkerBox.setStack(3, enchantedSword);
            }
            if (random.nextFloat() < 0.5f) {
                ItemStack enchantedPickaxe = new ItemStack((ItemConvertible)Items.DIAMOND_PICKAXE);
                Optional efficiency = enchantmentRegistry.getEntry(Enchantments.EFFICIENCY);
                unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING);
                if (efficiency.isPresent()) {
                    enchantedPickaxe.addEnchantment((RegistryEntry)efficiency.get(), 2 + random.nextInt(2));
                }
                if (unbreaking.isPresent()) {
                    enchantedPickaxe.addEnchantment((RegistryEntry)unbreaking.get(), 1 + random.nextInt(2));
                }
                shulkerBox.setStack(4, enchantedPickaxe);
            }
            int bookCount = random.nextInt(2) + 1;
            RegistryKey[] enchantmentKeys = new RegistryKey[]{Enchantments.PROTECTION, Enchantments.SHARPNESS, Enchantments.EFFICIENCY, Enchantments.FORTUNE, Enchantments.LOOTING};
            for (int i = 0; i < bookCount && i + 5 < 27; ++i) {
                ItemStack enchantedBook = new ItemStack((ItemConvertible)Items.ENCHANTED_BOOK);
                RegistryKey enchantKey = enchantmentKeys[random.nextInt(enchantmentKeys.length)];
                Optional enchantEntry = enchantmentRegistry.getEntry(enchantKey);
                if (enchantEntry.isPresent()) {
                    enchantedBook.addEnchantment((RegistryEntry)enchantEntry.get(), 1 + random.nextInt(2));
                }
                shulkerBox.setStack(5 + i, enchantedBook);
            }
            if (random.nextFloat() < 0.4f) {
                shulkerBox.setStack(7, new ItemStack((ItemConvertible)Items.GOLDEN_APPLE, random.nextInt(3) + 1));
            }
            if (random.nextFloat() < 0.5f) {
                shulkerBox.setStack(8, new ItemStack((ItemConvertible)Items.ENDER_PEARL, random.nextInt(4) + 3));
            }
            if (random.nextFloat() < 0.2f) {
                ItemStack rareItem = switch (random.nextInt(4)) {
                    case 0 -> new ItemStack((ItemConvertible)Items.TOTEM_OF_UNDYING);
                    case 1 -> new ItemStack((ItemConvertible)Items.TRIDENT);
                    case 2 -> new ItemStack((ItemConvertible)Items.NETHERITE_INGOT);
                    default -> new ItemStack((ItemConvertible)Items.ENCHANTED_GOLDEN_APPLE);
                };
                shulkerBox.setStack(9, rareItem);
            }
            shulkerBox.setStack(10, new ItemStack((ItemConvertible)Items.EXPERIENCE_BOTTLE, random.nextInt(3) + 2));
            LuckyBlockWorld.LOGGER.info("[Event] Spawn Shulker Box - Placed shulker box with loot at {}", (Object)pos);
        } else {
            LuckyBlockWorld.LOGGER.warn("[Event] Spawn Shulker Box - Failed to place shulker box at {}", (Object)pos);
        }
    }

    private static void netheriteUpgrade(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\u2b06 Netherite upgrade materials!"), false);
        ItemEntity upgradeTemplate = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE));
        world.spawnEntity((Entity)upgradeTemplate);
        ItemEntity netheriteIngot = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.NETHERITE_INGOT));
        world.spawnEntity((Entity)netheriteIngot);
        LuckyBlockWorld.LOGGER.info("[Event] Netherite Upgrade - Dropped upgrade template and netherite ingot");
    }

    private static void grantLevels(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7a\u2728 +5 Experience Levels!"), false);
        player.addExperienceLevels(5);
        LuckyBlockWorld.LOGGER.info("[Event] Grant Levels - Added 5 levels to player {}", (Object)player.getName().getString());
    }

    private static void creativeFlight(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83e\udebd You can fly for 15 seconds!"), false);
        player.getAbilities().allowFlying = true;
        player.getAbilities().flying = true;
        player.sendAbilitiesUpdate();
        world.getServer().execute(() -> LuckyEventHandler.scheduleFlightRemoval(world, player, 300));
        LuckyBlockWorld.LOGGER.info("[Event] Creative Flight - Granted 15 seconds of flight to player {}", (Object)player.getName().getString());
    }

    private static void scheduleFlightRemoval(ServerWorld world, PlayerEntity player, int ticks) {
        if (ticks <= 0) {
            if (!player.isCreative() && !player.isSpectator()) {
                player.getAbilities().allowFlying = false;
                player.getAbilities().flying = false;
                player.sendAbilitiesUpdate();
                player.sendMessage((Text)Text.literal((String)"\u00a7e\u2708 Flight ended!"), false);
                LuckyBlockWorld.LOGGER.info("[Event] Creative Flight - Removed flight from player {}", (Object)player.getName().getString());
            }
            return;
        }
        world.getServer().execute(() -> {
            if (player.isAlive() && !player.isCreative() && !player.isSpectator()) {
                LuckyEventHandler.scheduleFlightRemoval(world, player, ticks - 1);
            }
        });
    }

    private static void infinityBow(ServerWorld world, BlockPos pos, PlayerEntity player) {
        Optional unbreaking;
        Optional flame;
        Optional power;
        player.sendMessage((Text)Text.literal((String)"\u00a76\ud83c\udff9 Legendary Bow!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        ItemStack bow = new ItemStack((ItemConvertible)Items.BOW);
        Optional infinity = enchantmentRegistry.getEntry(Enchantments.INFINITY);
        if (infinity.isPresent()) {
            bow.addEnchantment((RegistryEntry)infinity.get(), 1);
        }
        if ((power = enchantmentRegistry.getEntry(Enchantments.POWER)).isPresent()) {
            bow.addEnchantment((RegistryEntry)power.get(), 5);
        }
        if ((flame = enchantmentRegistry.getEntry(Enchantments.FLAME)).isPresent()) {
            bow.addEnchantment((RegistryEntry)flame.get(), 1);
        }
        if ((unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING)).isPresent()) {
            bow.addEnchantment((RegistryEntry)unbreaking.get(), 3);
        }
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, bow);
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Infinity Bow - Dropped bow with Infinity, Power V, Flame, Unbreaking III");
    }

    private static void spawnConduit(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83c\udf0a Conduit with prismarine blocks!"), false);
        ItemEntity conduit = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.CONDUIT));
        world.spawnEntity((Entity)conduit);
        ItemEntity prismarine = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.PRISMARINE, 16));
        world.spawnEntity((Entity)prismarine);
        ItemEntity seaLanterns = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.SEA_LANTERN, 8));
        world.spawnEntity((Entity)seaLanterns);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Conduit - Dropped conduit with prismarine blocks");
    }

    private static void spawnMusicDiscs(ServerWorld world, BlockPos pos, PlayerEntity player) {
        Item[] musicDiscs;
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83c\udfb5 All music discs!"), false);
        for (Item disc : musicDiscs = new Item[]{Items.MUSIC_DISC_13, Items.MUSIC_DISC_CAT, Items.MUSIC_DISC_BLOCKS, Items.MUSIC_DISC_CHIRP, Items.MUSIC_DISC_FAR, Items.MUSIC_DISC_MALL, Items.MUSIC_DISC_MELLOHI, Items.MUSIC_DISC_STAL, Items.MUSIC_DISC_STRAD, Items.MUSIC_DISC_WARD, Items.MUSIC_DISC_11, Items.MUSIC_DISC_WAIT, Items.MUSIC_DISC_OTHERSIDE, Items.MUSIC_DISC_5, Items.MUSIC_DISC_PIGSTEP, Items.MUSIC_DISC_RELIC, Items.MUSIC_DISC_PRECIPICE, Items.MUSIC_DISC_CREATOR, Items.MUSIC_DISC_CREATOR_MUSIC_BOX}) {
            ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)disc));
            world.spawnEntity((Entity)item);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Music Discs - Dropped all {} music discs", (Object)musicDiscs.length);
    }

    private static void tridentDrop(ServerWorld world, BlockPos pos, PlayerEntity player) {
        Optional mending;
        Optional unbreaking;
        Optional impaling;
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udd31 Enchanted Trident!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        Random random = world.getRandom();
        ItemStack trident = new ItemStack((ItemConvertible)Items.TRIDENT);
        Optional loyalty = enchantmentRegistry.getEntry(Enchantments.LOYALTY);
        if (loyalty.isPresent()) {
            trident.addEnchantment((RegistryEntry)loyalty.get(), 3);
        }
        if ((impaling = enchantmentRegistry.getEntry(Enchantments.IMPALING)).isPresent()) {
            trident.addEnchantment((RegistryEntry)impaling.get(), 5);
        }
        if ((unbreaking = enchantmentRegistry.getEntry(Enchantments.UNBREAKING)).isPresent()) {
            trident.addEnchantment((RegistryEntry)unbreaking.get(), 3);
        }
        if ((mending = enchantmentRegistry.getEntry(Enchantments.MENDING)).isPresent()) {
            trident.addEnchantment((RegistryEntry)mending.get(), 1);
        }
        if (random.nextBoolean()) {
            Optional channeling = enchantmentRegistry.getEntry(Enchantments.CHANNELING);
            if (channeling.isPresent()) {
                trident.addEnchantment((RegistryEntry)channeling.get(), 1);
            }
        } else {
            Optional riptide = enchantmentRegistry.getEntry(Enchantments.RIPTIDE);
            if (riptide.isPresent()) {
                trident.addEnchantment((RegistryEntry)riptide.get(), 3);
            }
        }
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, trident);
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Trident Drop - Dropped enchanted trident");
    }

    private static void spawnWitherSkeletonSkull(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a78\ud83d\udc80 Wither Skeleton Skulls!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.WITHER_SKELETON_SKULL, 3));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Wither Skeleton Skull - Dropped 3 wither skeleton skulls");
    }

    private static void enchantedBookLibrary(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\ud83d\udcda Enchanted Book Library!"), false);
        Registry enchantmentRegistry = world.getRegistryManager().get(RegistryKeys.ENCHANTMENT);
        Random random = world.getRandom();
        RegistryKey[] enchantmentKeys = new RegistryKey[]{Enchantments.PROTECTION, Enchantments.FIRE_PROTECTION, Enchantments.BLAST_PROTECTION, Enchantments.PROJECTILE_PROTECTION, Enchantments.FEATHER_FALLING, Enchantments.THORNS, Enchantments.RESPIRATION, Enchantments.AQUA_AFFINITY, Enchantments.DEPTH_STRIDER, Enchantments.FROST_WALKER, Enchantments.SHARPNESS, Enchantments.SMITE, Enchantments.BANE_OF_ARTHROPODS, Enchantments.KNOCKBACK, Enchantments.FIRE_ASPECT, Enchantments.LOOTING, Enchantments.SWEEPING_EDGE, Enchantments.EFFICIENCY, Enchantments.SILK_TOUCH, Enchantments.UNBREAKING, Enchantments.FORTUNE, Enchantments.POWER, Enchantments.PUNCH, Enchantments.FLAME, Enchantments.INFINITY, Enchantments.LUCK_OF_THE_SEA, Enchantments.LURE, Enchantments.LOYALTY, Enchantments.IMPALING, Enchantments.RIPTIDE, Enchantments.CHANNELING, Enchantments.MENDING, Enchantments.SWIFT_SNEAK, Enchantments.SOUL_SPEED};
        for (int i = 0; i < 5; ++i) {
            ItemStack enchantedBook = new ItemStack((ItemConvertible)Items.ENCHANTED_BOOK);
            RegistryKey enchantKey = enchantmentKeys[random.nextInt(enchantmentKeys.length)];
            Optional enchantEntry = enchantmentRegistry.getEntry(enchantKey);
            if (!enchantEntry.isPresent()) continue;
            int maxLevel = ((Enchantment)((RegistryEntry.Reference)enchantEntry.get()).value()).getMaxLevel();
            enchantedBook.addEnchantment((RegistryEntry)enchantEntry.get(), maxLevel);
            ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, enchantedBook);
            world.spawnEntity((Entity)item);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Enchanted Book Library - Dropped 5 max-level enchanted books");
    }

    private static void spawnLodestone(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a75\ud83e\udded Lodestone and compass!"), false);
        ItemEntity lodestone = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.LODESTONE));
        world.spawnEntity((Entity)lodestone);
        ItemEntity compass = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.COMPASS));
        world.spawnEntity((Entity)compass);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Lodestone - Dropped lodestone and compass");
    }

    private static void recoveryCompass(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83e\udded Recovery Compass!"), false);
        ItemEntity compass = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.RECOVERY_COMPASS));
        world.spawnEntity((Entity)compass);
        LuckyBlockWorld.LOGGER.info("[Event] Recovery Compass - Dropped recovery compass");
    }

    private static void spawnEnderChest(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udce6 Ender Chest!"), false);
        world.setBlockState(pos, Blocks.ENDER_CHEST.getDefaultState());
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Ender Chest - Placed ender chest at block location");
    }

    private static void spawnNetheriteBlock(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udfe6 Netherite Block!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.NETHERITE_BLOCK, 1));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Netherite Blocks - Dropped 1 netherite block");
    }

    private static void spawnMobHeads(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udc80 Mob Head Collection!"), false);
        ItemEntity zombieHead = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.ZOMBIE_HEAD));
        world.spawnEntity((Entity)zombieHead);
        ItemEntity skeletonSkull = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.SKELETON_SKULL));
        world.spawnEntity((Entity)skeletonSkull);
        ItemEntity creeperHead = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.CREEPER_HEAD));
        world.spawnEntity((Entity)creeperHead);
        ItemEntity dragonHead = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.DRAGON_HEAD));
        world.spawnEntity((Entity)dragonHead);
        ItemEntity piglinHead = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.PIGLIN_HEAD));
        world.spawnEntity((Entity)piglinHead);
        ItemEntity playerHead = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.PLAYER_HEAD));
        world.spawnEntity((Entity)playerHead);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Mob Heads - Dropped all mob heads");
    }

    private static void enchantedHorse(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7d\ud83d\udc34 Legendary Horse!"), false);
        HorseEntity horse = (HorseEntity)EntityType.HORSE.create((World)world);
        if (horse != null) {
            horse.refreshPositionAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            horse.getAttributeInstance(EntityAttributes.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3375);
            horse.getAttributeInstance(EntityAttributes.GENERIC_JUMP_STRENGTH).setBaseValue(1.0);
            horse.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH).setBaseValue(30.0);
            horse.setHealth(30.0f);
            horse.setTame(true);
            horse.setOwnerUuid(player.getUuid());
            horse.getInventory().setStack(0, new ItemStack((ItemConvertible)Items.SADDLE));
            world.spawnEntity((Entity)horse);
        }
        LuckyBlockWorld.LOGGER.info("[Event] Enchanted Horse - Spawned legendary horse with max stats");
    }

    private static void giveElytra(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83e\udebd An Elytra!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.ELYTRA));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Give Elytra");
    }

    private static void spawnNetherStar(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\u2b50 A Nether Star!"), false);
        ItemEntity item = new ItemEntity((World)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemConvertible)Items.NETHER_STAR));
        world.spawnEntity((Entity)item);
        LuckyBlockWorld.LOGGER.info("[Event] Spawn Nether Star");
    }

    private static void beaconEffect(ServerWorld world, BlockPos pos, PlayerEntity player) {
        player.sendMessage((Text)Text.literal((String)"\u00a7b\ud83d\udd06 You feel empowered!"), false);
        int duration = 1200;
        int amplifier = 0;
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.SPEED, duration, amplifier, false, true, true));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.HASTE, duration, amplifier, false, true, true));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.RESISTANCE, duration, amplifier, false, true, true));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.JUMP_BOOST, duration, amplifier, false, true, true));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.STRENGTH, duration, amplifier, false, true, true));
        player.addStatusEffect(new StatusEffectInstance(StatusEffects.REGENERATION, duration, amplifier, false, true, true));
        LuckyBlockWorld.LOGGER.info("[Event] Beacon Effect - Applied all beacon effects to player {}", (Object)player.getName().getString());
    }
}

