/*
 * Decompiled with CFR 0.152.
 */
package com.luckyblockworld.mixin;

import com.luckyblockworld.block.LuckyBlockManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockBreakMixin {
    @Inject(method={"onBreak"}, at={@At(value="HEAD")})
    private void onBlockBreak(World world, BlockPos pos, BlockState state, PlayerEntity player, CallbackInfoReturnable<BlockState> cir) {
        if (!world.isClient && world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            if (LuckyBlockManager.isLuckyBlock(world, pos)) {
                LuckyBlockManager.triggerLuckyEvent(serverWorld, pos, player, state);
            }
        }
    }
}

