/*
 * Decompiled with CFR 0.152.
 */
package net.stehschnitzel.cheesus.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.stehschnitzel.cheesus.common.blocks.EatableCheese;
import net.stehschnitzel.cheesus.init.BlockInit;

public class CheesusBlockStateProvider
extends BlockStateProvider {
    public CheesusBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cheesus", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.normalCheeseBuilder(BlockInit.CHEESE);
        this.normalCheeseBuilder(BlockInit.ALTITUDE_CHEESE);
        this.normalCheeseBuilder(BlockInit.BLUE_MOLD_CHEESE);
        this.normalCheeseBuilder(BlockInit.DIABOLICAL_CHEESE);
        this.smallCheeseBuilder(BlockInit.GREY_CHEESE);
        this.smallCheeseBuilder(BlockInit.WHITE_MOLD_CHEESE);
        this.smallCheeseBuilder(BlockInit.CHEESE_CAKE);
    }

    public void smallCheeseBuilder(RegistryObject<? extends Block> block) {
        this.cheeseBuilder(block, "small_cheese");
    }

    public void normalCheeseBuilder(RegistryObject<? extends Block> block) {
        this.cheeseBuilder(block, "normal_cheese");
    }

    public void cheeseBuilder(RegistryObject<? extends Block> block, String template_name) {
        String name = block.getId().m_135815_();
        ModelBuilder f0 = this.cheese(name, 0, template_name);
        ModelBuilder f1 = this.cheese(name, 1, template_name);
        ModelBuilder f2 = this.cheese(name, 2, template_name);
        ModelBuilder f3 = this.cheese(name, 3, template_name);
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(arg_0 -> CheesusBlockStateProvider.lambda$cheeseBuilder$0((ModelFile)f1, (ModelFile)f2, (ModelFile)f3, (ModelFile)f0, arg_0), new Property[0]);
    }

    public ModelBuilder cheese(String name, int cnt, String template_name) {
        ResourceLocation cheese_texture = ResourceLocation.m_214293_((String)"cheesus", (String)("block/" + name));
        ResourceLocation cheese_particle = ResourceLocation.m_214293_((String)"cheesus", (String)("item/" + name));
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_" + cnt, ResourceLocation.m_214293_((String)"cheesus", (String)("block/" + template_name + "_" + cnt)))).texture("texture", cheese_texture)).texture("particle", cheese_particle);
        return model;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$cheeseBuilder$0(ModelFile f1, ModelFile f2, ModelFile f3, ModelFile f0, BlockState state) {
        int bit = (Integer)state.m_61143_((Property)EatableCheese.BITES);
        return ConfiguredModel.builder().modelFile(switch (bit) {
            case 1 -> f1;
            case 2 -> f2;
            case 3 -> f3;
            default -> f0;
        }).build();
    }
}

