/*
 * Decompiled with CFR 0.152.
 */
package net.stehschnitzel.cheesus.init;

import com.google.common.base.Supplier;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.stehschnitzel.cheesus.common.blocks.BasicCheese;
import net.stehschnitzel.cheesus.common.blocks.CheeseCover;
import net.stehschnitzel.cheesus.common.blocks.CheeseStrainer;
import net.stehschnitzel.cheesus.common.blocks.EatableCheese;
import net.stehschnitzel.cheesus.common.blocks.SmallCheese;

public class BlockInit {
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"cheesus");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cheesus");
    public static final RegistryObject<BasicCheese> CHEESE = BlockInit.registerBlockWItem("cheese", () -> new BasicCheese(BlockBehaviour.Properties.m_284310_().m_60913_(0.8f, 1.5f).m_60918_(SoundType.f_56753_)));
    public static final RegistryObject<EatableCheese> ALTITUDE_CHEESE = BlockInit.registerBlockWItem("altitude_cheese", () -> new EatableCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get())), MobEffects.f_19606_));
    public static final RegistryObject<EatableCheese> BLUE_MOLD_CHEESE = BlockInit.registerBlockWItem("blue_mold_cheese", () -> new EatableCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get())), MobEffects.f_19618_));
    public static final RegistryObject<EatableCheese> DIABOLICAL_CHEESE = BlockInit.registerBlockWItem("diabolical_cheese", () -> new EatableCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get())), MobEffects.f_19607_));
    public static final RegistryObject<EatableCheese> GREY_CHEESE = BlockInit.registerBlockWItem("grey_cheese", () -> new SmallCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get())), MobEffects.f_19600_));
    public static final RegistryObject<EatableCheese> WHITE_MOLD_CHEESE = BlockInit.registerBlockWItem("white_mold_cheese", () -> new SmallCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get())), MobEffects.f_19605_));
    public static final RegistryObject<Block> CHEESE_CAKE = BlockInit.registerBlockWItem("cheese_cake", () -> new SmallCheese(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)CHEESE.get()))));
    public static final RegistryObject<Block> CHEESE_COVER = BlockInit.registerBlock("cheese_cover", () -> new CheeseCover(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_()));
    public static final RegistryObject<Block> CHEESE_STRAINER = BlockInit.registerBlockWItem("cheese_strainer", () -> new CheeseStrainer(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));

    private static <T extends Block> RegistryObject<T> registerBlockWItem(String name, Supplier<T> block) {
        RegistryObject<T> to_return = BlockInit.registerBlock(name, block);
        BlockInit.registerBlockItem(name, to_return);
        return to_return;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return BLOCK_ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        BLOCK_ITEMS.register(bus);
    }
}

