/*
 * Decompiled with CFR 0.152.
 */
package net.stehschnitzel.cheesus.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stehschnitzel.cheesus.common.blocks.BasicCheese;
import net.stehschnitzel.cheesus.common.blocks.CheesusVoxels;
import net.stehschnitzel.cheesus.common.blocks.entities.CheeseStrainerBlockEntity;
import net.stehschnitzel.cheesus.init.BlockEntityInit;
import net.stehschnitzel.cheesus.init.BlockInit;
import org.jetbrains.annotations.Nullable;

public class CheeseStrainer
extends BaseEntityBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)11);
    public static final DispenseItemBehavior DISPENSE_CHEESE_STRAINER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            if (stack.m_41720_() != ((Block)BlockInit.CHEESE_STRAINER.get()).m_5456_()) {
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
            ServerLevel level = source.m_7727_();
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            level.m_46597_(blockpos, ((Block)BlockInit.CHEESE_STRAINER.get()).m_49966_());
            return ItemStack.f_41583_;
        }
    };
    public static final DispenseItemBehavior DISPENSE_INTO_CHEESE_STRAINER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel level = source.m_7727_();
            if (level.m_8055_(blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_))).m_60713_((Block)BlockInit.CHEESE_STRAINER.get())) {
                BlockState state = level.m_8055_(blockpos);
                if (stack.m_41720_() == Items.f_42447_ && (Integer)state.m_61143_((Property)LEVEL) == 0) {
                    source.m_7727_().m_46597_(blockpos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(7)));
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                if (stack.m_41720_() == Items.f_42455_ && (Integer)state.m_61143_((Property)LEVEL) < 4) {
                    source.m_7727_().m_46597_(blockpos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LEVEL) + 1)));
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                if (stack.m_41720_() == ((BasicCheese)((Object)BlockInit.CHEESE.get())).m_5456_() && (Integer)state.m_61143_((Property)LEVEL) == 0) {
                    source.m_7727_().m_46597_(blockpos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(5)));
                    return ItemStack.f_41583_;
                }
            }
            return this.defaultDispenseItemBehavior.m_6115_(source, stack);
        }
    };

    public CheeseStrainer(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return switch ((Integer)pState.m_61143_((Property)LEVEL)) {
            case 1, 5 -> 1;
            case 2, 3 -> (Integer)pState.m_61143_((Property)LEVEL);
            case 4, 6 -> 4;
            case 7, 8, 9, 10, 11 -> 15 - ((Integer)pState.m_61143_((Property)LEVEL) - 7) * 3;
            default -> 0;
        };
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CheesusVoxels.CheeseStrainer();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int level = (Integer)pLevel.m_8055_(pPos).m_61143_((Property)LEVEL);
        Item item = pPlayer.m_21120_(pHand).m_41720_();
        if (level < 3 && item == Items.f_42455_) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level + 1)));
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21205_().m_41774_(1);
                this.addItemOrDrop((ItemLike)Items.f_42446_, pPlayer);
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (level == 0 && item == ((BasicCheese)((Object)BlockInit.CHEESE.get())).m_5456_()) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(5)));
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21120_(pHand).m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if ((level == 0 || level >= 7) && item == Items.f_42447_) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(7)));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (level == 4) {
            this.addItemOrDrop((ItemLike)BlockInit.CHEESE.get(), pPlayer);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        if (level == 6) {
            this.addItemOrDrop((ItemLike)BlockInit.GREY_CHEESE.get(), pPlayer);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private void addItemOrDrop(ItemLike item, Player player) {
        if (!player.m_36356_(new ItemStack(item))) {
            player.m_36176_(new ItemStack(item), false);
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double r2;
        double r1;
        double r0;
        double d2;
        double d1;
        double d0;
        if ((Integer)pState.m_61143_((Property)LEVEL) >= 7) {
            d0 = (double)pPos.m_123341_() + 0.1;
            d1 = (double)pPos.m_123342_() + 0.9 - (double)((Integer)pState.m_61143_((Property)LEVEL) - 7) * 0.2;
            d2 = (double)pPos.m_123343_() + 0.1;
            r0 = 0.8;
            r1 = 0.1;
            r2 = 0.8;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175825_, (double)pPos.m_123341_(), d1 + pRandom.m_188500_() * r1, d2 + pRandom.m_188500_() * r2, 0.0, 2.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175825_, d0 + pRandom.m_188500_() * r0, d1 + pRandom.m_188500_() * r1, (double)pPos.m_123343_(), 0.0, 2.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175825_, (double)(pPos.m_123341_() + 1), d1 + pRandom.m_188500_() * r1, d2 + pRandom.m_188500_() * r2, 0.0, 2.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175825_, d0 + pRandom.m_188500_() * r0, d1 + pRandom.m_188500_() * r1, (double)(pPos.m_123343_() + 1), 0.0, 2.0, 0.0);
        }
        if (this.m_6724_(pState)) {
            d0 = (double)pPos.m_123341_() + 0.5;
            d1 = (double)pPos.m_123342_() + 0.9;
            d2 = (double)pPos.m_123343_() + 0.5;
            r0 = pRandom.m_188500_() * 0.6 - 0.3;
            r1 = pRandom.m_188500_() * 0.1;
            r2 = pRandom.m_188500_() * 0.6 - 0.3;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123757_, d0 + r0, d1 + r1, d2 + r2, 0.0, 2.0, 0.0);
        }
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)LEVEL) == 3 || (Integer)pState.m_61143_((Property)LEVEL) == 5;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)LEVEL) == 3) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(4)));
        } else if ((Integer)pState.m_61143_((Property)LEVEL) == 5) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(6)));
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LEVEL});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_() && (Integer)pState.m_61143_((Property)LEVEL) < 7) {
            return null;
        }
        return CheeseStrainer.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.CHEESE_STRAINER.get()), (level, blockPos, blockState, growthChamberBlockEntity) -> growthChamberBlockEntity.tick(level, blockPos, blockState));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CheeseStrainerBlockEntity(pPos, pState);
    }
}

