/*
 * Decompiled with CFR 0.152.
 */
package net.stehschnitzel.cheesus.datagen;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.stehschnitzel.cheesus.datagen.CheesusAdvancmentProvider;
import net.stehschnitzel.cheesus.datagen.CheesusBlockStateProvider;
import net.stehschnitzel.cheesus.datagen.CheesusBlockTagProvider;
import net.stehschnitzel.cheesus.datagen.CheesusItemModelProvider;
import net.stehschnitzel.cheesus.datagen.CheesusItemTagProvider;
import net.stehschnitzel.cheesus.datagen.CheesusRecipeProvider;
import net.stehschnitzel.cheesus.datagen.LootTableProvider;

@Mod.EventBusSubscriber(modid="cheesus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) throws IOException {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new CheesusBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)LootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new CheesusItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CheesusRecipeProvider(packOutput));
        CheesusBlockTagProvider blockTagsProvider = new CheesusBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CheesusItemTagProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new CheesusAdvancmentProvider())));
    }
}

