/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.model;

import baguchi.bagus_lib.client.layer.IArmor;
import baguchi.hunters_return.client.animation.HunterAnimations;
import baguchi.hunters_return.client.render.state.HunterRenderState;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class HunterModel<T extends HunterRenderState>
extends EntityModel<T>
implements ArmedModel<T>,
HeadedModel,
IArmor {
    public final ModelPart body;
    public final ModelPart everything;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart root;
    public final ModelPart head;
    private final ModelPart nose;
    private final ModelPart cape;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    public final KeyframeAnimation dodghRightAnimation;
    public final KeyframeAnimation dodghLeftAnimation;

    public HunterModel(ModelPart root) {
        super(root);
        this.root = root;
        this.everything = root.getChild("everything");
        this.body = this.everything.getChild("body");
        this.cape = this.body.getChild("cape");
        this.LeftLeg = this.everything.getChild("left_leg");
        this.RightLeg = this.everything.getChild("right_leg");
        this.RightArm = this.body.getChild("right_arm");
        this.LeftArm = this.body.getChild("left_arm");
        this.head = this.body.getChild("head");
        this.nose = this.head.getChild("nose");
        this.dodghRightAnimation = HunterAnimations.right_dodge.bake(root);
        this.dodghLeftAnimation = HunterAnimations.left_dodge.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(49, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 44).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 13).addBox(-4.0f, -11.75f, -2.5f, 8.0f, 14.0f, 5.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition cape = body.addOrReplaceChild("cape", CubeListBuilder.create().texOffs(28, 32).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(65, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.15f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(6, 7).addBox(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(6, 7).addBox(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.addOrReplaceChild("righteyebrows", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.addOrReplaceChild("righteyebrows_r1", CubeListBuilder.create().texOffs(39, 0).addBox(-1.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.addOrReplaceChild("lefteyebrows", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.addOrReplaceChild("lefteyebrows_r1", CubeListBuilder.create().texOffs(39, 0).mirror().addBox(-3.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(16, 44).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(17, 18).addBox(5.0f, 2.25f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(48, 32).mirror().addBox(0.0f, -0.75f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition leftHand = left_arm.addOrReplaceChild("leftHand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)9.5f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 36).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(19, 0).addBox(-7.0f, 2.25f, -3.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 0).mirror().addBox(-5.0f, -0.75f, -3.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightHand = right_arm.addOrReplaceChild("rightHand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T p_364104_) {
        super.setupAnim(p_364104_);
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.125f, 0.0f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.75f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.RightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.LeftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.RightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.LeftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public void translateToHand(T entityRenderState, HumanoidArm humanoidArm, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        this.getArm(humanoidArm).translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.125f, 0.0f);
    }
}

