/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.render;

import baguchi.hunters_return.client.render.state.BoomerangRenderState;
import baguchi.hunters_return.entity.projectile.BoomerangEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class BoomerangRender
extends EntityRenderer<BoomerangEntity, BoomerangRenderState> {
    private final ItemModelResolver itemModelResolver;

    public BoomerangRender(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.itemModelResolver = renderManager.getItemModelResolver();
    }

    public void submit(BoomerangRenderState renderState, PoseStack stackIn, SubmitNodeCollector bufferIn, CameraRenderState p_451076_) {
        stackIn.pushPose();
        stackIn.translate(-0.0f, 0.0f, 0.15f);
        stackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        if (!renderState.inGround) {
            stackIn.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
        }
        stackIn.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        if (!renderState.inGround) {
            stackIn.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(renderState.ageInTicks * (renderState.speed * 80.0f)));
        }
        stackIn.scale(1.4f, 1.4f, 1.4f);
        renderState.boomerang.submit(stackIn, bufferIn, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
        stackIn.popPose();
        super.submit((EntityRenderState)renderState, stackIn, bufferIn, p_451076_);
    }

    public BoomerangRenderState createRenderState() {
        return new BoomerangRenderState();
    }

    public void extractRenderState(BoomerangEntity p_361771_, BoomerangRenderState p_364204_, float p_360538_) {
        super.extractRenderState((Entity)p_361771_, (EntityRenderState)p_364204_, p_360538_);
        p_364204_.xRot = p_361771_.getXRot(p_360538_);
        p_364204_.yRot = p_361771_.getYRot(p_360538_);
        p_364204_.inGround = p_361771_.inGround;
        p_364204_.speed = (float)p_361771_.getSpeed();
        this.itemModelResolver.updateForNonLiving(p_364204_.boomerang, p_361771_.getBoomerang(), ItemDisplayContext.GROUND, (Entity)p_361771_);
    }
}

