/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.data;

import baguchi.hunters_return.data.BiomeTagGenerator;
import baguchi.hunters_return.data.BlockTagGenerator;
import baguchi.hunters_return.data.EntityTagGenerator;
import baguchi.hunters_return.data.ItemTagGenerator;
import baguchi.hunters_return.data.RegistryDataGenerator;
import baguchi.hunters_return.data.generator.CraftingGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="hunters_return")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.getGenerator().addProvider(true, (DataProvider)new RegistryDataGenerator(packOutput, lookupProvider));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider);
        event.getGenerator().addProvider(true, (DataProvider)blocktags);
        event.getGenerator().addProvider(true, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new BiomeTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new Runner(packOutput, lookupProvider));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new CraftingGenerator(lookupProvider, output);
        }

        public String getName() {
            return "hunters_returnrecipes";
        }
    }
}

