/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;

public class MiniCrossBowAttackGoal<T extends Mob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public <M extends Monster> MiniCrossBowAttackGoal(M p_25814_, double p_25815_, float p_25816_) {
        this(p_25814_, p_25815_, p_25816_);
    }

    public MiniCrossBowAttackGoal(T p_25814_, double p_25815_, float p_25816_) {
        this.mob = p_25814_;
        this.speedModifier = p_25815_;
        this.attackRadiusSqr = p_25816_ * p_25816_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.isHolding(is -> is.getItem() instanceof CrossbowItem);
    }

    public boolean canContinueToUse() {
        return this.isValidTarget() && (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.getTarget() != null && this.mob.getTarget().isAlive();
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.mob.setTarget(null);
        this.seeTime = 0;
        if (this.mob.isUsingItem()) {
            this.mob.stopUsingItem();
            ((CrossbowAttackMob)this.mob).setChargingCrossbow(false);
            this.mob.getUseItem().set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        }
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        InteractionHand hand2 = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem) == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.distanceToSqr((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.getNavigation().moveTo((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.75);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.mob.getRandom());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.getNavigation().stop();
            }
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.mob.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.mob).setChargingCrossbow(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.mob.isUsingItem()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.mob.getTicksUsingItem()) >= (itemstack = this.mob.getUseItem()).getUseDuration(this.mob)) {
                    this.mob.releaseUsingItem();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 12 + this.mob.getRandom().nextInt(4);
                    ((CrossbowAttackMob)this.mob).setChargingCrossbow(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                ((CrossbowAttackMob)this.mob).performCrossbowAttack(this.mob, 1.2f);
                Item item2 = this.mob.getItemInHand(hand2).getItem();
                if (item2 instanceof CrossbowItem) {
                    CrossbowItem miniCrossBowItem = (CrossbowItem)item2;
                    this.attackDelay = 8;
                    this.crossbowState = CrossbowState.READY_TO_ATTACK_SECOND;
                } else {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK_SECOND && flag) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.performSecondCrossbowAttack((LivingEntity)this.mob, hand2, 1.2f);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }
    }

    protected void performSecondCrossbowAttack(LivingEntity p_32337_, InteractionHand hand, float p_32338_) {
        ItemStack itemstack = p_32337_.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (item instanceof CrossbowItem) {
            CrossbowItem crossbowitem = (CrossbowItem)item;
            crossbowitem.performShooting(p_32337_.level(), p_32337_, hand, itemstack, p_32338_, (float)(14 - p_32337_.level().getDifficulty().getId() * 4), this.mob.getTarget());
        }
        ((CrossbowAttackMob)this.mob).onCrossbowAttackPerformed();
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK,
        READY_TO_ATTACK_SECOND;

    }
}

