# Calculate pitch based on charge progress (30 down to 0 = pitch 0.5 to 2.0)
# Timer goes from 30 to 0, so we need to invert it
# When timer=30 (start): pitch should be 0.5
# When timer=0 (end): pitch should be 2.0

# Get current timer value
execute store result score #timer turret_beam_tick run scoreboard players get @s turret_charge_timer

# Calculate progress: 30 - timer gives us 0 at start, 30 at end
scoreboard players set #progress turret_beam_tick 30
scoreboard players operation #progress turret_beam_tick -= #timer turret_beam_tick

# Map progress 0-30 to pitch ranges
# 0-5 = pitch 0.5, 6-10 = 0.75, 11-15 = 1.0, 16-20 = 1.25, 21-24 = 1.5, 25-28 = 1.75, 29-30 = 2.0
execute if score #progress turret_beam_tick matches 0..5 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 0.5 1
execute if score #progress turret_beam_tick matches 6..10 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 0.75 1
execute if score #progress turret_beam_tick matches 11..15 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 1.0 1
execute if score #progress turret_beam_tick matches 16..20 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 1.25 1
execute if score #progress turret_beam_tick matches 21..24 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 1.5 1
execute if score #progress turret_beam_tick matches 25..28 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 1.75 1
execute if score #progress turret_beam_tick matches 29..30 run playsound minecraft:block.stone_button.click_on block @a[distance=..40] ~ ~ ~ 1.5 2.0 1
