# Find the position with the highest concentration of enemies
# This function finds the best target by counting nearby enemies around each potential target
# Requires at least 2 enemies within 4 blocks to be considered a valid concentration

# Initialize best concentration variables
scoreboard players set #best_concentration turret_beam_tick 0
scoreboard players set #min_concentration turret_beam_tick 2
tag @e[tag=concentration_best] remove concentration_best

# Check each potential target and count nearby enemies within 4 blocks (including self)
execute as @e[type=#dispenser_turret:targets,distance=..50] at @s store result score @s turret_beam_tick if entity @e[type=#dispenser_turret:targets,distance=..4]

# Find the entity with the highest concentration score (must be at least 2)
execute as @e[type=#dispenser_turret:targets,distance=..50] if score @s turret_beam_tick >= #min_concentration turret_beam_tick if score @s turret_beam_tick > #best_concentration turret_beam_tick run scoreboard players operation #best_concentration turret_beam_tick = @s turret_beam_tick

# Tag the entity(ies) with the best concentration (only if meets minimum requirement)
execute as @e[type=#dispenser_turret:targets,distance=..50] if score @s turret_beam_tick = #best_concentration turret_beam_tick if score #best_concentration turret_beam_tick >= #min_concentration turret_beam_tick run tag @s add concentration_best

# Store whether we found a valid concentration
execute store result score #found_concentration turret_beam_tick if entity @e[tag=concentration_best,distance=..50]
