# Check target exists - if not, try to find a new concentration target
execute unless entity @e[tag=flame_turret_target] run tag @e[tag=flame_turret_target] remove flame_turret_target
execute unless entity @e[tag=flame_turret_target] run function dispenser_turret:find_enemy_concentration
execute unless entity @e[tag=flame_turret_target] if score #found_concentration turret_beam_tick matches 1.. run tag @e[type=#dispenser_turret:targets,distance=..25,limit=1,sort=nearest,tag=concentration_best] add flame_turret_target
execute unless entity @e[tag=flame_turret_target] if score #found_concentration turret_beam_tick matches 0 run tag @e[type=#dispenser_turret:targets,distance=..25,limit=1,sort=nearest] add flame_turret_target
execute unless entity @e[tag=flame_turret_target] run tag @e[tag=concentration_best] remove concentration_best

# If still no target, stop firing
execute unless entity @e[tag=flame_turret_target] run tag @s remove flame_firing
execute unless entity @e[tag=flame_turret_target] run return 0

# Clear concentration tags
tag @e[tag=concentration_best] remove concentration_best

# Rotate display to track target
execute store result score #this_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #this_id turret_beam_tick at @s facing entity @e[tag=flame_turret_target,limit=1,sort=nearest] feet run tp @s ~ ~ ~ ~ ~

# Draw flame beam from turret to target
execute positioned ~ ~0.5 ~ facing entity @e[tag=flame_turret_target,limit=1] feet run function dispenser_turret:flame_beam_recursive

# Light fire to blocks in radius FIRST (10 block radius)
execute at @e[tag=flame_turret_target,limit=1] run function dispenser_turret:flame_ignite_blocks

# Spawn fire-themed firework at target (before damage)
execute at @e[tag=flame_turret_target,limit=1] run summon minecraft:firework_rocket ~ ~2 ~ {LifeTime:0,FireworksItem:{id:"minecraft:firework_rocket",count:1,components:{"minecraft:fireworks":{explosions:[{shape:"burst",colors:[I;16711680,16744192,16760576,16776960],fade_colors:[I;11141120,5046016]}]}}}}

# Fire explosion particles at target (2 blocks up)
execute at @e[tag=flame_turret_target,limit=1] run particle minecraft:explosion_emitter ~ ~2 ~ 0 0 0 0 1 force
execute at @e[tag=flame_turret_target,limit=1] run particle minecraft:flame ~ ~2 ~ 3 3 3 0.2 60 force
execute at @e[tag=flame_turret_target,limit=1] run particle minecraft:lava ~ ~2 ~ 3 3 3 0 12 force
execute at @e[tag=flame_turret_target,limit=1] run particle minecraft:large_smoke ~ ~2 ~ 3 3 3 0.1 30 force
execute at @e[tag=flame_turret_target,limit=1] run particle minecraft:campfire_cosy_smoke ~ ~2 ~ 3 3 3 0.1 20 force
execute at @e[tag=flame_turret_target,limit=1] run particle dust{color:[1.0,0.3,0.0],scale:2.0} ~ ~2 ~ 3 3 3 0.2 25 force
execute at @e[tag=flame_turret_target,limit=1] run particle dust{color:[1.0,0.6,0.0],scale:1.5} ~ ~2 ~ 3 3 3 0.2 15 force
execute at @e[tag=flame_turret_target,limit=1] run playsound minecraft:entity.generic.explode block @a[distance=..50] ~ ~2 ~ 2 0.8 1
execute at @e[tag=flame_turret_target,limit=1] run playsound minecraft:entity.wind_charge.wind_burst block @a[distance=..50] ~ ~2 ~ 2 1 1
execute at @e[tag=flame_turret_target,limit=1] run playsound minecraft:item.firecharge.use block @a[distance=..50] ~ ~2 ~ 2 0.8 1

# AOE damage and ignite enemies near target (10 block radius, 3 damage max)
execute at @e[tag=flame_turret_target,limit=1] as @e[type=#dispenser_turret:targets,distance=..10,limit=20,sort=nearest] run damage @s 3
execute at @e[tag=flame_turret_target,limit=1] as @e[type=#dispenser_turret:targets,distance=..10,limit=20,sort=nearest] run data merge entity @s {Fire:200s}

# Deal damage to main target LAST (also 3 damage)
damage @e[tag=flame_turret_target,limit=1] 3

# Sounds at turret
playsound minecraft:entity.blaze.shoot block @a[distance=..40] ~ ~ ~ 2 0.8 1
playsound minecraft:item.firecharge.use block @a[distance=..40] ~ ~ ~ 2 1 1
playsound minecraft:block.furnace.fire_crackle block @a[distance=..40] ~ ~ ~ 2 1.2 1

# Particles at turret
particle minecraft:flame ~ ~0.5 ~ 0.3 0.3 0.3 0.1 30 force
particle minecraft:smoke ~ ~0.5 ~ 0.2 0.2 0.2 0.05 15 force

# Shake animation
scoreboard players set @s turret_anim_timer 12
tag @s add dispenser_turret_animating

# Unlight the blast furnace
execute store result score #unlight_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #unlight_id turret_beam_tick run data merge entity @s {block_state:{Name:"minecraft:blast_furnace",Properties:{lit:"false",facing:"north"}}}

# Go on cooldown (4 seconds = 80 ticks)
tag @e[tag=flame_turret_target] remove flame_turret_target
tag @s add dispenser_turret_cooldown
scoreboard players set @s turret_cooldown_timer 80
playsound minecraft:block.fire.extinguish block @a[distance=..40] ~ ~ ~ 2 0.8 1
