# Check if target still exists
execute unless entity @e[tag=flame_turret_target] run tag @s remove flame_charging
execute unless entity @e[tag=flame_turret_target] run tag @e[tag=flame_turret_target] remove flame_turret_target
execute unless entity @e[tag=flame_turret_target] run return 0

# Rotate turret to face target during charging
execute store result score #rotate_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #rotate_id turret_beam_tick at @s facing entity @e[tag=flame_turret_target,limit=1,sort=nearest] feet run tp @s ~ ~ ~ ~ ~

# Countdown charge timer
scoreboard players remove @s turret_charge_timer 1

# Play pitching firework blast sound with increasing speed and pitch
scoreboard players remove @s turret_sound_timer 1

# Calculate pitch based on remaining charge time (higher pitch as timer approaches 0)
# Charge timer goes from 30 to 0, so invert it for pitch calculation
execute store result score #pitch_calc turret_beam_tick run scoreboard players get @s turret_charge_timer
scoreboard players operation #pitch_calc turret_beam_tick *= #-1 turret_beam_tick
scoreboard players add #pitch_calc turret_beam_tick 30

# Play sound with dynamic pitch and reduced interval as it gets closer to firing
execute if score @s turret_charge_timer matches 20..30 if score @s turret_sound_timer matches ..0 run playsound minecraft:entity.firework_rocket.large_blast block @a[distance=..30] ~ ~ ~ 0.5 0.8 1
execute if score @s turret_charge_timer matches 20..30 if score @s turret_sound_timer matches ..0 run scoreboard players set @s turret_sound_timer 10

execute if score @s turret_charge_timer matches 10..19 if score @s turret_sound_timer matches ..0 run playsound minecraft:entity.firework_rocket.large_blast block @a[distance=..30] ~ ~ ~ 0.6 1.0 1
execute if score @s turret_charge_timer matches 10..19 if score @s turret_sound_timer matches ..0 run scoreboard players set @s turret_sound_timer 7

execute if score @s turret_charge_timer matches 1..9 if score @s turret_sound_timer matches ..0 run playsound minecraft:entity.firework_rocket.large_blast block @a[distance=..30] ~ ~ ~ 0.7 1.3 1
execute if score @s turret_charge_timer matches 1..9 if score @s turret_sound_timer matches ..0 run scoreboard players set @s turret_sound_timer 4

# Smoke particles during charge
execute if score @s turret_sound_timer matches ..0 run particle minecraft:large_smoke ~ ~0.5 ~ 0.3 0.3 0.3 0.03 8 force
execute if score @s turret_sound_timer matches ..0 run particle minecraft:campfire_cosy_smoke ~ ~0.5 ~ 0.2 0.2 0.2 0.02 5 force

# Fire when timer reaches 0 (fire once immediately)
execute if score @s turret_charge_timer matches ..0 run tag @s remove flame_charging
execute if score @s turret_charge_timer matches ..0 run playsound minecraft:entity.blaze.shoot block @a[distance=..30] ~ ~ ~ 2 1 1
execute if score @s turret_charge_timer matches ..0 run particle minecraft:flame ~ ~0.5 ~ 0.6 0.6 0.6 0.1 30 force
execute if score @s turret_charge_timer matches ..0 at @s run function dispenser_turret:flame_fire
execute if score @s turret_charge_timer matches ..0 run return 1
