# Check if currently firing or charging
execute if entity @s[tag=flame_firing] run return 0
execute if entity @s[tag=flame_charging] run return 0

# Check if any targets exist in range
execute unless entity @e[type=#dispenser_turret:targets,distance=..25] run return 0

# Find the highest concentration of enemies (requires at least 2 within 4 blocks)
function dispenser_turret:find_enemy_concentration

# If valid concentration found, use it
execute if score #found_concentration turret_beam_tick matches 1.. run tag @e[type=#dispenser_turret:targets,distance=..25,limit=1,sort=nearest,tag=concentration_best] add flame_turret_target

# Otherwise, fallback to nearest single target
execute if score #found_concentration turret_beam_tick matches 0 run tag @e[type=#dispenser_turret:targets,distance=..25,limit=1,sort=nearest] add flame_turret_target

# Clear concentration tags
tag @e[tag=concentration_best] remove concentration_best

# Verify target exists
execute unless entity @e[tag=flame_turret_target,distance=..25] run return 0

# Start charging (1.5 seconds = 30 ticks)
tag @s add flame_charging
scoreboard players set @s turret_charge_timer 30
scoreboard players set @s turret_sound_timer 10

# Light the blast furnace
execute store result score #light_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #light_id turret_beam_tick run data merge entity @s {block_state:{Name:"minecraft:blast_furnace",Properties:{lit:"true",facing:"north"}}}

# Initial ignition sound and particles
playsound minecraft:item.firecharge.use block @a[distance=..30] ~ ~ ~ 2 0.8 1
playsound minecraft:block.furnace.fire_crackle block @a[distance=..30] ~ ~ ~ 2 1 1
particle minecraft:large_smoke ~ ~0.5 ~ 0.4 0.4 0.4 0.05 15 force
particle minecraft:campfire_cosy_smoke ~ ~0.5 ~ 0.3 0.3 0.3 0.03 10 force
