# Check if target still exists - if not, abort charging
execute unless entity @e[tag=rocket_turret_target] run tag @s remove dispenser_turret_charging
execute unless entity @e[tag=rocket_turret_target] run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute unless entity @e[tag=rocket_turret_target] run return 0

# Rotate the loom display to track the target every tick
execute store result score #this_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #this_id turret_beam_tick at @s facing entity @e[tag=rocket_turret_target,limit=1,sort=nearest] feet run tp @s ~ ~ ~ ~ ~

# Countdown charge timer
scoreboard players remove @s turret_charge_timer 1

# Play button click sound every 2 ticks
scoreboard players add @s turret_sound_timer 1
execute if score @s turret_sound_timer matches 2.. run scoreboard players set @s turret_sound_timer 0
execute if score @s turret_sound_timer matches 0 run function dispenser_turret:charging_click

# Rocket mode: extra charging particles (rainbow effect spread out over 60 tick charge)
execute if score @s turret_charge_timer matches 54 at @s run particle minecraft:dust{color:[1.0,0.0,0.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 48 at @s run particle minecraft:dust{color:[1.0,0.5,0.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 42 at @s run particle minecraft:dust{color:[1.0,1.0,0.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 36 at @s run particle minecraft:dust{color:[0.0,1.0,0.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 30 at @s run particle minecraft:dust{color:[0.0,1.0,1.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 24 at @s run particle minecraft:dust{color:[0.0,0.0,1.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 3 force
execute if score @s turret_charge_timer matches 24 at @s run particle minecraft:electric_spark ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 18 at @s run particle minecraft:dust{color:[0.5,0.0,1.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 3 force
execute if score @s turret_charge_timer matches 18 at @s run particle minecraft:electric_spark ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 12 at @s run particle minecraft:dust{color:[1.0,0.0,1.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 4 force
execute if score @s turret_charge_timer matches 12 at @s run particle minecraft:firework ~ ~0.5 ~ 0.5 0.5 0.5 0.1 2 force
execute if score @s turret_charge_timer matches 6 at @s run particle minecraft:dust{color:[1.0,1.0,1.0],scale:1.2} ~ ~0.5 ~ 0.5 0.5 0.5 0.1 5 force
execute if score @s turret_charge_timer matches 6 at @s run particle minecraft:firework ~ ~0.5 ~ 0.5 0.5 0.5 0.1 3 force
execute if score @s turret_charge_timer matches 6 at @s run particle minecraft:electric_spark ~ ~0.5 ~ 0.5 0.5 0.5 0.1 3 force

# Rocket mode: extra charging sounds at key moments
execute if score @s turret_charge_timer matches 40 at @s run playsound minecraft:entity.firework_rocket.twinkle block @a[distance=..40] ~ ~ ~ 1 0.8 1
execute if score @s turret_charge_timer matches 20 at @s run playsound minecraft:entity.firework_rocket.twinkle block @a[distance=..40] ~ ~ ~ 1 1.2 1
execute if score @s turret_charge_timer matches 10 at @s run playsound minecraft:entity.firework_rocket.twinkle block @a[distance=..40] ~ ~ ~ 1.5 1.5 1

# Fire when timer reaches 0 or below - start burst (3 shots, uses separate timer)
execute if score @s turret_charge_timer matches ..0 at @s run playsound minecraft:entity.firework_rocket.blast block @a[distance=..40] ~ ~ ~ 2 1.2 1
execute if score @s turret_charge_timer matches ..0 run tag @s remove dispenser_turret_charging
execute if score @s turret_charge_timer matches ..0 run tag @s add rocket_firing
execute if score @s turret_charge_timer matches ..0 run scoreboard players set @s turret_rapid_shots 3
execute if score @s turret_charge_timer matches ..0 run scoreboard players set @s turret_rocket_timer 0
