# Mark current target as recently targeted (to avoid picking same target)
tag @e[tag=minigun_turret_target] add minigun_recent_target

# Clear current target
tag @e[tag=minigun_turret_target] remove minigun_turret_target

# Prefer NEAREST targets without slowness, excluding recently targeted
tag @e[type=#dispenser_turret:targets,distance=..20,limit=1,sort=nearest,tag=!minigun_recent_target,nbt=!{active_effects:[{id:"minecraft:slowness"}]}] add minigun_turret_target

# If no non-slow targets found (excluding recent), try NEAREST target including recent (but still prefer non-slow)
execute unless entity @e[tag=minigun_turret_target,distance=..20] run tag @e[type=#dispenser_turret:targets,distance=..20,limit=1,sort=nearest,nbt=!{active_effects:[{id:"minecraft:slowness"}]}] add minigun_turret_target

# If ALL targets have slowness, then pick NEAREST target (including slow ones)
execute unless entity @e[tag=minigun_turret_target,distance=..20] run tag @e[type=#dispenser_turret:targets,distance=..20,limit=1,sort=nearest] add minigun_turret_target

# Clear the recent target tag from the previous target
tag @e[tag=minigun_recent_target] remove minigun_recent_target

# If we found a target, play sound and particles
execute if entity @e[tag=minigun_turret_target,distance=..20] run playsound minecraft:block.note_block.pling block @a[distance=..40] ~ ~ ~ 1 2 1
execute if entity @e[tag=minigun_turret_target,distance=..20] at @e[tag=minigun_turret_target,limit=1] run particle minecraft:end_rod ~ ~1 ~ 0.3 0.5 0.3 0.1 10 force
