# Chain lightning effect - finds nearby enemies and creates arcing lightning between them
# This is called for each primary target hit by the mortar

# Find up to 3 nearby enemies within 15 blocks (excluding self)
tag @e[tag=mortar_chain_target] remove mortar_chain_target
tag @e[type=#dispenser_turret:targets,distance=0.1..15,limit=3,sort=nearest] add mortar_chain_target

# Only proceed if we found chain targets
execute unless entity @e[tag=mortar_chain_target] run return 0

# Arc particles at primary target origin
function dispenser_turret:mortar_arc_particles

# Create lightning arc to each chained target
execute as @e[tag=mortar_chain_target,limit=3] at @s run function dispenser_turret:mortar_chain_arc

# Deal 20 damage to each chained target
execute as @e[tag=mortar_chain_target,limit=3] run damage @s 20

# Clear chain target tags
tag @e[tag=mortar_chain_target] remove mortar_chain_target
