# Check target exists - if not, try to find a new concentration target
execute unless entity @e[tag=rocket_turret_target] run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute unless entity @e[tag=rocket_turret_target] run function dispenser_turret:find_enemy_concentration
execute unless entity @e[tag=rocket_turret_target] if score #found_concentration turret_beam_tick matches 1.. run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest,tag=concentration_best] add rocket_turret_target
execute unless entity @e[tag=rocket_turret_target] if score #found_concentration turret_beam_tick matches 0 run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest] add rocket_turret_target
execute unless entity @e[tag=rocket_turret_target] run tag @e[tag=concentration_best] remove concentration_best

# If still no target, stop firing
execute unless entity @e[tag=rocket_turret_target] run tag @s remove rocket_firing
execute unless entity @e[tag=rocket_turret_target] run return 0

# Clear concentration tags
tag @e[tag=concentration_best] remove concentration_best

# Rotate loom display to track target
execute store result score #this_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #this_id turret_beam_tick at @s facing entity @e[tag=rocket_turret_target,limit=1,sort=nearest] feet run tp @s ~ ~ ~ ~ ~

# Draw beam from turret to target
execute positioned ~ ~0.5 ~ facing entity @e[tag=rocket_turret_target,limit=1] feet run function dispenser_turret:rocket_beam_recursive

# Spawn firework rocket at target FIRST (before damage kills them)
execute at @e[tag=rocket_turret_target,limit=1] run summon minecraft:firework_rocket ~ ~2 ~ {LifeTime:0,FireworksItem:{id:"minecraft:firework_rocket",count:1,components:{"minecraft:fireworks":{explosions:[{shape:"large_ball",colors:[I;16711680,16753920,16776960,65280,255,9699583,16711935]}]}}}}

# Rainbow explosion particles at target (2 blocks up)
execute at @e[tag=rocket_turret_target,limit=1] run particle minecraft:explosion_emitter ~ ~2 ~ 0 0 0 0 1 force
execute at @e[tag=rocket_turret_target,limit=1] run particle minecraft:firework ~ ~2 ~ 2 2 2 0.3 100 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[1.0,0.0,0.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[1.0,0.5,0.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[1.0,1.0,0.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[0.0,1.0,0.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[0.0,1.0,1.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[0.0,0.0,1.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run particle dust{color:[1.0,0.0,1.0],scale:1.5} ~ ~2 ~ 2 2 2 0.2 30 force
execute at @e[tag=rocket_turret_target,limit=1] run playsound minecraft:entity.generic.explode block @a[distance=..50] ~ ~2 ~ 2 1 1
execute at @e[tag=rocket_turret_target,limit=1] run playsound minecraft:entity.firework_rocket.large_blast block @a[distance=..50] ~ ~2 ~ 2 1 1

# Deal damage to main target
damage @e[tag=rocket_turret_target,limit=1] 10

# AOE damage - find enemies near target and damage them (8 block radius, 10 damage)
execute at @e[tag=rocket_turret_target,limit=1] as @e[type=#dispenser_turret:targets,distance=..8,limit=10,sort=nearest] unless entity @s[tag=rocket_turret_target] run damage @s 10

# Sounds at turret
playsound minecraft:block.respawn_anchor.deplete block @a[distance=..40] ~ ~ ~ 2 1.5 1
playsound minecraft:entity.blaze.shoot block @a[distance=..40] ~ ~ ~ 2 0.8 1
playsound minecraft:entity.firework_rocket.launch block @a[distance=..40] ~ ~ ~ 1.5 1.5 1

# Particles at turret
particle minecraft:electric_spark ~ ~0.5 ~ 0.2 0.2 0.2 0.1 15 force
particle minecraft:smoke ~ ~0.5 ~ 0.2 0.2 0.2 0.05 10 force

# Shake animation
scoreboard players set @s turret_anim_timer 12
tag @s add dispenser_turret_animating

# Remove shots
scoreboard players remove @s turret_rapid_shots 1

# Switch to new concentration target if more shots remaining
execute if score @s turret_rapid_shots matches 1.. run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute if score @s turret_rapid_shots matches 1.. at @s run function dispenser_turret:find_enemy_concentration
execute if score @s turret_rapid_shots matches 1.. at @s if score #found_concentration turret_beam_tick matches 1.. run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest,tag=concentration_best] add rocket_turret_target
execute if score @s turret_rapid_shots matches 1.. at @s if score #found_concentration turret_beam_tick matches 0 run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest] add rocket_turret_target
execute if score @s turret_rapid_shots matches 1.. run tag @e[tag=concentration_best] remove concentration_best

# End burst if out of shots
execute if score @s turret_rapid_shots matches ..0 run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute if score @s turret_rapid_shots matches ..0 run tag @s remove rocket_firing
execute if score @s turret_rapid_shots matches ..0 run tag @s add dispenser_turret_cooldown
execute if score @s turret_rapid_shots matches ..0 run scoreboard players set @s turret_cooldown_timer 120
execute if score @s turret_rapid_shots matches ..0 run playsound minecraft:block.respawn_anchor.deplete block @a[distance=..40] ~ ~ ~ 2 0.5 1
